/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import javax.inject.Inject;
import javax.inject.Provider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.model.builder.CampaignLibraryTreeNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.RequirementLibraryTreeNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.TestCaseLibraryTreeNodeBuilder;

@Configuration
public class TreeNodeBuildersConfig {
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    Provider<TestCaseLibraryTreeNodeBuilder> testCaseLibraryTreeNodeBuilderProvider;
    @Inject
    Provider<RequirementLibraryTreeNodeBuilder> requirementLibraryTreeNodeBuilderProvider;
    @Inject
    Provider<CampaignLibraryTreeNodeBuilder> campaignLibraryTreeNodeBuilderProvider;

    @Bean(name={"testCase.driveNodeBuilder"})
    @Scope(value="prototype")
    public DriveNodeBuilder<TestCaseLibraryNode> testCaseDriveNodeBuilder() {
        return new DriveNodeBuilder<TestCaseLibraryNode>(this.permissionEvaluationService, this.testCaseLibraryTreeNodeBuilderProvider);
    }

    @Bean(name={"requirement.driveNodeBuilder"})
    @Scope(value="prototype")
    public DriveNodeBuilder<RequirementLibraryNode> requirementDriveNodeBuilder() {
        return new DriveNodeBuilder<RequirementLibraryNode>(this.permissionEvaluationService, this.requirementLibraryTreeNodeBuilderProvider);
    }

    @Bean(name={"campaign.driveNodeBuilder"})
    @Scope(value="prototype")
    public DriveNodeBuilder<CampaignLibraryNode> campaignDriveNodeBuilder() {
        return new DriveNodeBuilder<CampaignLibraryNode>(this.permissionEvaluationService, this.campaignLibraryTreeNodeBuilderProvider);
    }
}

