/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import org.apache.catalina.Context;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TomcatContainerConfig {
    @Bean
    @ConditionalOnProperty(prefix="squash", name={"run-as-war"}, havingValue="false", matchIfMissing=true)
    public TomcatServletWebServerFactory containerFactory() {
        CustomizedTomcatServerFactory tomcatServerFactory = new CustomizedTomcatServerFactory();
        return tomcatServerFactory;
    }

    private static final class CustomizedTomcatServerFactory
    extends TomcatServletWebServerFactory {
        private static final Logger LOGGER = LoggerFactory.getLogger(CustomizedTomcatServerFactory.class);

        private CustomizedTomcatServerFactory() {
        }

        protected void customizeConnector(Connector connector) {
            super.customizeConnector(connector);
            if (connector.getProtocolHandler() instanceof AbstractHttp11Protocol) {
                ((AbstractHttp11Protocol)connector.getProtocolHandler()).setMaxSwallowSize(-1);
            }
        }

        protected void postProcessContext(Context context) {
            StandardRoot standardRoot = new StandardRoot(context);
            standardRoot.setCacheMaxSize(40960L);
            context.setResources((WebResourceRoot)standardRoot);
        }
    }
}

