/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import java.io.IOException;
import java.util.Collection;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.user.AdministrationService;

@Component
@Configuration
public class SquashAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private static final String ROLE_TF_AUTOMATION_PROGRAMMER = "ROLE_TF_AUTOMATION_PROGRAMMER";
    private static final String ROLE_TF_FUNCTIONAL_TESTER = "ROLE_TF_FUNCTIONAL_TESTER";
    private RequestCache requestCache = new HttpSessionRequestCache();
    @Inject
    private AdministrationService administrationService;

    public SquashAuthenticationSuccessHandler() {
        this.setUseReferer(true);
        this.setAlwaysUseDefaultTargetUrl(false);
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        HttpSession session = request.getSession();
        UserDetails authUser = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        session.setAttribute("username", (Object)authUser.getUsername());
        response.setStatus(200);
        Collection authorities = authentication.getAuthorities();
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        String targetUrl = "/home-workspace";
        if (this.isUserProgrammerButNotTester(authorities)) {
            targetUrl = "/automation-workspace";
        } else if (savedRequest != null) {
            targetUrl = savedRequest.getRedirectUrl();
        }
        if (this.administrationService.findInformation().size() != 0) {
            this.getRedirectStrategy().sendRedirect(request, response, "/information?targetUrl=" + targetUrl);
        } else {
            this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
        }
    }

    private boolean isUserProgrammerButNotTester(Collection<? extends GrantedAuthority> authorities) {
        return authorities.stream().anyMatch(auth -> ROLE_TF_AUTOMATION_PROGRAMMER.equals(auth.getAuthority())) && authorities.stream().noneMatch(auth -> ROLE_TF_FUNCTIONAL_TESTER.equals(auth.getAuthority()));
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }
}

