/*
 * Decompiled with CFR 0.152.
 */
package squashtm.testautomation.repository.hibernate;

import java.util.List;
import javax.inject.Inject;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import squashtm.testautomation.domain.TestAutomationProject;
import squashtm.testautomation.domain.TestAutomationServer;
import squashtm.testautomation.repository.NonUniqueEntityException;
import squashtm.testautomation.repository.TestAutomationServerDao;

public class HibernateTestAutomationServerDao
implements TestAutomationServerDao {
    @Inject
    private SessionFactory sessionFactory;

    @Override
    public void persist(TestAutomationServer server) {
        if (this.findByExample(server) != null) {
            throw new NonUniqueEntityException();
        }
        this.sessionFactory.getCurrentSession().persist((Object)server);
    }

    @Override
    public TestAutomationServer uniquePersist(TestAutomationServer server) {
        if (server.getId() != null && this.findById(server.getId()) != null) {
            return server;
        }
        TestAutomationServer baseServer = this.findByExample(server);
        if (baseServer != null) {
            return baseServer;
        }
        this.sessionFactory.getCurrentSession().persist((Object)server);
        return server;
    }

    @Override
    public TestAutomationServer findById(Long id) {
        Session session = this.sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("testAutomationServer.findById");
        query.setParameter("serverId", (Object)id);
        return (TestAutomationServer)query.uniqueResult();
    }

    @Override
    public TestAutomationServer findByExample(TestAutomationServer example) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(TestAutomationServer.class);
        criteria.add((Criterion)Example.create((Object)example));
        List res = criteria.list();
        if (res.isEmpty()) {
            return null;
        }
        if (res.size() == 1) {
            return (TestAutomationServer)res.get(0);
        }
        throw new NonUniqueEntityException();
    }

    @Override
    public List<TestAutomationProject> findAllHostedProjects(long serverId) {
        Session session = this.sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("testAutomationServer.findAllHostedProjects");
        query.setParameter("serverId", (Object)serverId);
        return query.list();
    }
}

