/*
 * Decompiled with CFR 0.152.
 */
package squashtm.testautomation.repository.hibernate;

import java.util.List;
import javax.inject.Inject;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Restrictions;
import squashtm.testautomation.domain.TestAutomationProject;
import squashtm.testautomation.repository.NonUniqueEntityException;
import squashtm.testautomation.repository.TestAutomationProjectDao;

public class HibernateTestAutomationProjectDao
implements TestAutomationProjectDao {
    @Inject
    private SessionFactory sessionFactory;

    @Override
    public void persist(TestAutomationProject newProject) {
        if (this.findByExample(newProject) != null) {
            throw new NonUniqueEntityException();
        }
        this.sessionFactory.getCurrentSession().persist((Object)newProject);
    }

    @Override
    public TestAutomationProject uniquePersist(TestAutomationProject newProject) {
        if (newProject.getId() != null && this.findById(newProject.getId()) != null) {
            return newProject;
        }
        TestAutomationProject baseProject = this.findByExample(newProject);
        if (baseProject != null) {
            return baseProject;
        }
        this.sessionFactory.getCurrentSession().persist((Object)newProject);
        return newProject;
    }

    @Override
    public TestAutomationProject findById(Long id) {
        Session session = this.sessionFactory.getCurrentSession();
        Query query = session.getNamedQuery("testAutomationProject.findById");
        query.setParameter("projectId", (Object)id);
        return (TestAutomationProject)query.uniqueResult();
    }

    @Override
    public TestAutomationProject findByExample(TestAutomationProject example) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(TestAutomationProject.class);
        criteria = criteria.add((Criterion)Example.create((Object)example));
        List res = (criteria = criteria.add((Criterion)Restrictions.eq((String)"server", (Object)example.getServer()))).list();
        if (res.isEmpty()) {
            return null;
        }
        if (res.size() == 1) {
            return (TestAutomationProject)res.get(0);
        }
        throw new NonUniqueEntityException();
    }
}

