/*
 * Decompiled with CFR 0.152.
 */
package squashtm.testautomation.internal.tasks;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import squashtm.testautomation.domain.TestAutomationProject;
import squashtm.testautomation.domain.TestAutomationServer;
import squashtm.testautomation.domain.TestAutomationTest;
import squashtm.testautomation.internal.service.TestAutomationConnectorRegistry;
import squashtm.testautomation.internal.tasks.TestAutomationConnectorTask;
import squashtm.testautomation.model.TestAutomationProjectContent;
import squashtm.testautomation.spi.TestAutomationConnector;

public class FetchTestListTask
implements TestAutomationConnectorTask<TestAutomationProjectContent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationConnectorTask.class);
    private TestAutomationConnectorRegistry connectorRegistry;
    private TestAutomationProject project;

    public FetchTestListTask(TestAutomationConnectorRegistry connectorRegistry, TestAutomationProject project) {
        this.connectorRegistry = connectorRegistry;
        this.project = project;
    }

    @Override
    public TestAutomationProjectContent call() throws Exception {
        TestAutomationServer server = this.project.getServer();
        TestAutomationConnector connector = this.connectorRegistry.getConnectorForKind(server.getKind());
        Collection<TestAutomationTest> allTests = connector.listTestsInProject(this.project);
        return new TestAutomationProjectContent(this.project, allTests);
    }

    @Override
    public TestAutomationProjectContent buildFailedResult(Exception thrownException) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("TestAutomationConnector : the task 'fetch test list' failed for project '" + this.project.getName() + "' on server '" + this.project.getServer().getBaseURL() + "', caused by :", (Throwable)thrownException);
        }
        return new TestAutomationProjectContent(this.project, thrownException);
    }
}

