/*
 * Decompiled with CFR 0.152.
 */
package squashtm.testautomation.internal.service;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.osgi.extensions.annotation.ServiceReference;
import org.springframework.transaction.annotation.Transactional;
import squashtm.testautomation.domain.TestAutomationProject;
import squashtm.testautomation.domain.TestAutomationServer;
import squashtm.testautomation.internal.service.InsecureTestAutomationManagementService;
import squashtm.testautomation.internal.service.TestAutomationConnectorRegistry;
import squashtm.testautomation.internal.tasks.FetchTestListTask;
import squashtm.testautomation.internal.thread.FetchTestListFuture;
import squashtm.testautomation.internal.thread.TestAutomationTaskExecutor;
import squashtm.testautomation.model.TestAutomationProjectContent;
import squashtm.testautomation.repository.TestAutomationProjectDao;
import squashtm.testautomation.repository.TestAutomationServerDao;
import squashtm.testautomation.spi.TestAutomationConnector;

@Transactional
public class TestAutomationManagementServiceImpl
implements InsecureTestAutomationManagementService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationManagementServiceImpl.class);
    private static final int DEFAULT_THREAD_TIMEOUT = 30000;
    private int timeoutMillis = 30000;
    @Inject
    private TestAutomationServerDao serverDao;
    @Inject
    private TestAutomationProjectDao projectDao;
    @Inject
    private TestAutomationConnectorRegistry connectorRegistry;
    @Inject
    private TestAutomationServer defaultServer;
    private TestAutomationTaskExecutor executor;

    @ServiceReference
    public void setAsyncTaskExecutor(AsyncTaskExecutor executor) {
        TestAutomationTaskExecutor taExecutor;
        this.executor = taExecutor = new TestAutomationTaskExecutor(executor);
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    public Collection<TestAutomationProject> listProjectsOnServer(TestAutomationServer server) {
        TestAutomationConnector connector = this.connectorRegistry.getConnectorForKind(server.getKind());
        connector.checkCredentials(server);
        return connector.listProjectsOnServer(server);
    }

    @Override
    public Collection<TestAutomationProject> listProjectsOnServer(URL serverURL, String login, String password) {
        TestAutomationServer server = new TestAutomationServer(serverURL, login, password);
        return this.listProjectsOnServer(server);
    }

    @Override
    public Collection<TestAutomationProjectContent> listTestsInProjects(Collection<TestAutomationProject> projects) {
        Collection<FetchTestListTask> tasks = this.prepareAllFetchTestListTasks(projects);
        Collection<FetchTestListFuture> futures = this.submitAllFetchTestListTasks(tasks);
        return this.collectAllTestLists(futures);
    }

    @Override
    public TestAutomationProject persistOrAttach(TestAutomationProject newProject) {
        TestAutomationServer inBaseServer = this.serverDao.uniquePersist(newProject.getServer());
        return this.projectDao.uniquePersist(newProject.newWithServer(inBaseServer));
    }

    @Override
    public TestAutomationServer getDefaultServer() {
        return this.defaultServer;
    }

    private Collection<FetchTestListTask> prepareAllFetchTestListTasks(Collection<TestAutomationProject> projects) {
        ArrayList<FetchTestListTask> tasks = new ArrayList<FetchTestListTask>();
        for (TestAutomationProject project : projects) {
            tasks.add(new FetchTestListTask(this.connectorRegistry, project));
        }
        return tasks;
    }

    private Collection<FetchTestListFuture> submitAllFetchTestListTasks(Collection<FetchTestListTask> tasks) {
        ArrayList<FetchTestListFuture> futures = new ArrayList<FetchTestListFuture>();
        for (FetchTestListTask task : tasks) {
            futures.add(this.executor.sumbitFetchTestListTask(task));
        }
        return futures;
    }

    private Collection<TestAutomationProjectContent> collectAllTestLists(Collection<FetchTestListFuture> futures) {
        ArrayList<TestAutomationProjectContent> results = new ArrayList<TestAutomationProjectContent>();
        for (FetchTestListFuture future : futures) {
            try {
                TestAutomationProjectContent projectContent = future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
                results.add(projectContent);
            }
            catch (Exception ex) {
                results.add(future.getTask().buildFailedResult(ex));
            }
        }
        return results;
    }
}

