/*
 * Decompiled with CFR 0.152.
 */
package squashtm.testautomation.internal.service;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import squashtm.testautomation.spi.TestAutomationConnector;
import squashtm.testautomation.spi.exceptions.UnknownConnectorKind;

public class TestAutomationConnectorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationConnectorRegistry.class);
    private Map<String, TestAutomationConnector> availableConnectors = new ConcurrentHashMap<String, TestAutomationConnector>(5);

    public Collection<String> listRegisteredConnectors() {
        return this.availableConnectors.keySet();
    }

    public TestAutomationConnector getConnectorForKind(String kind) {
        TestAutomationConnector connector = this.availableConnectors.get(kind);
        if (connector == null) {
            UnknownConnectorKind ex = new UnknownConnectorKind("TestAutomationConnector : unknown kind '" + kind + "'");
            ex.addArg(kind);
            throw ex;
        }
        return connector;
    }

    public void registerConnector(TestAutomationConnector connector, Map serviceProperties) {
        String kind = connector.getConnectorKind();
        if (kind == null) {
            throw new IllegalArgumentException("TestAutomationConnector : kind is undefined");
        }
        LOGGER.info("Registering connector for test automation platforms of kind '{}'", (Object)kind);
        this.availableConnectors.put(kind, connector);
    }

    public void unregisterConnector(TestAutomationConnector connector, Map serviceProperties) {
        if (connector == null) {
            return;
        }
        String kind = connector.getConnectorKind();
        LOGGER.info("Unregistering connector for test automation platforms of kind '{}'", (Object)kind);
        this.availableConnectors.remove(kind);
    }
}

