/*
 * Decompiled with CFR 0.152.
 */
package squashtm.testautomation.domain;

import java.net.URL;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;

@NamedQueries(value={@NamedQuery(name="testAutomationServer.findById", query="from TestAutomationServer where id = :serverId"), @NamedQuery(name="testAutomationServer.findAllHostedProjects", query="select p from TestAutomationProject p join p.server s where s.id = :serverId")})
@Entity
public class TestAutomationServer {
    private static final String DEFAULT_KIND = "jenkins";
    @Id
    @GeneratedValue
    @Column(name="SERVER_ID")
    private Long id;
    @Column
    private URL baseURL;
    @Column
    private String login;
    @Column
    private String password;
    @Column
    private String kind = "jenkins";

    public Long getId() {
        return this.id;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKind() {
        return this.kind;
    }

    public String toString() {
        return this.baseURL.toExternalForm();
    }

    public TestAutomationServer newWithURL(URL baseURL) {
        return new TestAutomationServer(baseURL, this.login, this.password, this.kind);
    }

    public TestAutomationServer newWithLogin(String login) {
        return new TestAutomationServer(this.baseURL, login, this.password, this.kind);
    }

    public TestAutomationServer newWithPassword(String password) {
        return new TestAutomationServer(this.baseURL, this.login, password, this.kind);
    }

    public TestAutomationServer newWithKind(String kind) {
        return new TestAutomationServer(this.baseURL, this.login, this.password, kind);
    }

    public TestAutomationServer() {
    }

    public TestAutomationServer(URL baseURL) {
        this.baseURL = baseURL;
    }

    public TestAutomationServer(URL baseURL, String kind) {
        this.baseURL = baseURL;
        this.kind = kind;
    }

    public TestAutomationServer(URL baseURL, String login, String password) {
        this.baseURL = baseURL;
        this.login = login;
        this.password = password;
        this.kind = DEFAULT_KIND;
    }

    public TestAutomationServer(URL baseURL, String login, String password, String kind) {
        this.baseURL = baseURL;
        this.login = login;
        this.password = password;
        this.kind = kind;
    }
}

