/*
 * Decompiled with CFR 0.152.
 */
package squashtm.testautomation.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import squashtm.testautomation.domain.TestAutomationServer;

@NamedQueries(value={@NamedQuery(name="testAutomationProject.findById", query="from TestAutomationProject where id = :projectId"), @NamedQuery(name="testAutomationProject.findAllKnownTests", query="select t from TestAutomationTest t join t.project p where p.id = :projectId")})
@Entity
public class TestAutomationProject {
    @Id
    @GeneratedValue
    @Column(name="PROJECT_ID")
    private Long id;
    @Column
    private String name;
    @ManyToOne
    @JoinColumn(name="SERVER_ID")
    private TestAutomationServer server;

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TestAutomationServer getServer() {
        return this.server;
    }

    public TestAutomationProject newWithName(String name) {
        return new TestAutomationProject(name, this.server);
    }

    public TestAutomationProject newWithServer(TestAutomationServer server) {
        return new TestAutomationProject(this.name, server);
    }

    public TestAutomationProject() {
    }

    public TestAutomationProject(String name, TestAutomationServer server) {
        this.name = name;
        this.server = server;
    }
}

