/*
 * Decompiled with CFR 0.152.
 */
package squashtm.testautomation.configuration;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import squashtm.testautomation.domain.TestAutomationServer;

public class PropertiesBasedDefaultTestAutomationServerFactoryBean
implements FactoryBean<TestAutomationServer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesBasedDefaultTestAutomationServerFactoryBean.class);
    private static final String DEFAULT_URL_KEY = "tm.test.automation.server.defaulturl";
    private static final String DEFAULT_LOGIN_KEY = "tm.test.automation.server.defaultlogin";
    private static final String DEFAULT_PASSWORD_KEY = "tm.test.automation.server.defaultpassword";
    @Inject
    @Qualifier(value="squashtest.tm.ta.defaults")
    private Properties defaultsProperties;

    public void setDefaultsProperties(Properties defaultsProperties) {
        this.defaultsProperties = defaultsProperties;
    }

    public TestAutomationServer getObject() throws Exception {
        String baseStrUrl = this.defaultsProperties.getProperty(DEFAULT_URL_KEY, "");
        URL baseURL = null;
        try {
            baseURL = new URL(baseStrUrl);
        }
        catch (MalformedURLException malformedURLException) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("default automated test server configuration : malformed url '" + baseStrUrl + "', proceeding with empty url");
            }
            baseURL = new URL("http://locahost");
        }
        String defaultLogin = this.defaultsProperties.getProperty(DEFAULT_LOGIN_KEY, "");
        String defaultPass = this.defaultsProperties.getProperty(DEFAULT_PASSWORD_KEY, "");
        TestAutomationServer defaultServer = new TestAutomationServer(baseURL, defaultLogin, defaultPass);
        if (LOGGER.isInfoEnabled()) {
            String displayablePassword = defaultPass.length() > 0 ? String.valueOf(defaultPass.substring(0, 1)) + "****" : "(hidden)";
            LOGGER.info("default automated test server configuration : url = '" + baseURL.toExternalForm() + "', login : '" + defaultLogin + "', password : '" + displayablePassword + "...'");
        }
        return defaultServer;
    }

    public Class<?> getObjectType() {
        return TestAutomationServer.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

