/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.exploratory;

import javax.inject.Inject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.testcase.ExploratoryTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.internal.repository.ExploratoryTestCaseDao;
import org.squashtest.tm.service.testcase.exploratory.ExploratoryTestCaseService;

@Service
@Transactional
public class ExploratoryTestCaseServiceImpl
implements ExploratoryTestCaseService {
    @Inject
    private ExploratoryTestCaseDao exploratoryTestCaseDao;

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void updateCharter(@Id long testCaseId, String charter) {
        ExploratoryTestCase exploratoryTestCase = (ExploratoryTestCase)this.exploratoryTestCaseDao.findById(testCaseId).orElseThrow();
        if (charter.isEmpty()) {
            exploratoryTestCase.setCharter(null);
        } else {
            exploratoryTestCase.setCharter(charter);
        }
        exploratoryTestCase.updateLastModificationWithCurrentUser();
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestCase.class)
    public void updateSessionDuration(@Id long testCaseId, int sessionDurationInMinutes) {
        ExploratoryTestCase exploratoryTestCase = (ExploratoryTestCase)this.exploratoryTestCaseDao.findById(testCaseId).orElseThrow();
        if (sessionDurationInMinutes == 0) {
            exploratoryTestCase.setSessionDuration(null);
        } else {
            exploratoryTestCase.setSessionDuration(Integer.valueOf(sessionDurationInMinutes));
        }
        exploratoryTestCase.updateLastModificationWithCurrentUser();
    }
}

