/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd.robot;

import java.util.List;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.service.internal.testcase.bdd.TextGridFormatter;
import org.squashtest.tm.service.internal.testcase.bdd.robot.RobotSyntaxHelpers;

public final class SectionBuilderHelpers {
    public static final String FOUR_SPACES = "    ";
    public static final String TEST_SETUP = "Test Setup";
    public static final String TEST_TEARDOWN = "Test Teardown";
    public static final String DATASET_VARIABLE_NAME = "dataset";
    public static final String RETRIEVE_DATASET_KEYWORD_NAME = "Retrieve Dataset";
    public static final String DATATABLES_VARIABLE_NAME = "datatables";
    private static final String DATATABLE_PARAM_FORMAT = "datatable_%s";
    public static final String RETRIEVE_DATATABLES_KEYWORD_NAME = "Retrieve Datatables";
    public static final String DOCSTRINGS_VARIABLE_NAME = "docstrings";
    public static final String DOCSTRING_NAME_FORMAT = "docstring_%s";
    public static final String RETRIEVE_DOCSTRINGS_KEYWORD_NAME = "Retrieve Docstrings";

    private SectionBuilderHelpers() {
        throw new UnsupportedOperationException("This class is not meant to be instantiated.");
    }

    public static String formatDocumentationSettingLines(List<String> content) {
        return new TextGridFormatter().addRows(SectionBuilderHelpers.buildDocumentationSettingLines(content)).format(TextGridFormatter.withRowPrefix(FOUR_SPACES));
    }

    private static List<List<String>> buildDocumentationSettingLines(List<String> content) {
        return RobotSyntaxHelpers.buildMultilineEntry(RobotSyntaxHelpers.documentationSetting(), content);
    }

    public static String formatDatatableName(int number) {
        return String.format(DATATABLE_PARAM_FORMAT, number);
    }

    public static String formatDatatableAccessor(int number) {
        return SectionBuilderHelpers.formatDictionaryAccessor(DATATABLES_VARIABLE_NAME, SectionBuilderHelpers.formatDatatableName(number));
    }

    public static String formatDocstringName(int number) {
        return String.format(DOCSTRING_NAME_FORMAT, number);
    }

    public static String formatDocstringAccessor(int number) {
        return SectionBuilderHelpers.formatDictionaryAccessor(DOCSTRINGS_VARIABLE_NAME, SectionBuilderHelpers.formatDocstringName(number));
    }

    private static String formatDictionaryAccessor(String dictionaryName, String key) {
        return String.valueOf(RobotSyntaxHelpers.scalarVariable(dictionaryName)) + RobotSyntaxHelpers.memberAccess(key);
    }

    public static boolean isTestCaseUsingDatasets(KeywordTestCase testCase) {
        return testCase.containsStepsUsingTcParam();
    }

    public static boolean isTestCaseUsingDatatables(KeywordTestCase testCase) {
        return testCase.containsStepsUsingDatatable();
    }

    public static boolean isTestCaseUsingDocstrings(KeywordTestCase testCase) {
        return !SectionBuilderHelpers.extractUsedDocstrings(testCase).isEmpty();
    }

    public static List<String> extractUsedDocstrings(KeywordTestCase keywordTestCase) {
        return keywordTestCase.getSteps().stream().filter(KeywordTestStep.class::isInstance).filter(step -> {
            boolean hasDatatable;
            String docstring = ((KeywordTestStep)step).getDocstring();
            String datatable = ((KeywordTestStep)step).getDatatable();
            boolean hasDocstring = docstring != null && !docstring.isEmpty();
            boolean bl = hasDatatable = datatable != null && !datatable.isEmpty();
            return hasDocstring && !hasDatatable;
        }).map(step -> ((KeywordTestStep)step).getDocstring()).toList();
    }

    public static final class MultiLineStringBuilder {
        final StringBuilder stringBuilder = new StringBuilder();

        public MultiLineStringBuilder append(String content) {
            this.stringBuilder.append(content);
            return this;
        }

        public MultiLineStringBuilder appendLine(String content) {
            this.stringBuilder.append(content).append(RobotSyntaxHelpers.NEW_LINE);
            return this;
        }

        public MultiLineStringBuilder appendNewLine() {
            this.stringBuilder.append(RobotSyntaxHelpers.NEW_LINE);
            return this;
        }

        public String toString() {
            return this.stringBuilder.toString();
        }
    }
}

