/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;

public class TextGridFormatter {
    private static final int MIN_COLUMN_SPACING = 4;
    private static final String LINE_SEPARATOR = "\n";
    private final List<Row> rows = new ArrayList<Row>();

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public TextGridFormatter addRow(String ... cells) {
        this.addRow(Arrays.asList(cells));
        return this;
    }

    public TextGridFormatter addRow(List<String> cells) {
        this.rows.add(new Row(cells));
        return this;
    }

    public TextGridFormatter addRows(List<List<String>> rowsToAdd) {
        this.rows.addAll(rowsToAdd.stream().map(Row::new).toList());
        return this;
    }

    public String format() {
        return this.format(null);
    }

    public String format(@Nullable FormatOptions formatOptions) {
        List<Integer> columnWidths = this.computeColumnWidths();
        return this.processRows(formatOptions, columnWidths);
    }

    /*
     * Unable to fully structure code
     */
    private List<Integer> computeColumnWidths() {
        columnWidths = new ArrayList<Integer>();
        for (Row row : this.rows) {
            column = 0;
            ** GOTO lbl14
            {
                columnWidths.add(0);
                do {
                    if (columnWidths.size() <= column) continue block1;
                    length = row.cells.get(column).length();
                    max = Math.max(length, (Integer)columnWidths.get(column));
                    columnWidths.set(column, max);
                    ++column;
lbl14:
                    // 2 sources

                } while (column < row.cells.size());
            }
        }
        return columnWidths;
    }

    private String processRows(FormatOptions formatOptions, List<Integer> columnWidths) {
        String rowPrefix = formatOptions == null ? "" : formatOptions.rowPrefix;
        StringBuilder sb = new StringBuilder();
        for (Row row : this.rows) {
            int column = 0;
            while (column < row.cells.size()) {
                sb.append(this.processCell(columnWidths, rowPrefix, row, column));
                ++column;
            }
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private String processCell(List<Integer> columnWidths, String rowPrefix, Row row, int column) {
        int minLength = columnWidths.get(column) + 4;
        String textContent = row.cells.get(column);
        if (column < row.cells.size() - 1) {
            textContent = this.padRight(textContent, minLength);
        }
        if (column == 0 && rowPrefix != null) {
            textContent = String.valueOf(rowPrefix) + textContent;
        }
        return textContent;
    }

    public static FormatOptions withRowPrefix(String prefix) {
        return new FormatOptions(prefix);
    }

    private String padRight(String input, int minLength) {
        StringBuilder sb = new StringBuilder(input);
        while (sb.length() < minLength) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static final class FormatOptions {
        private String rowPrefix;

        private FormatOptions(String rowPrefix) {
            this.rowPrefix = rowPrefix;
        }

        public String getRowPrefix() {
            return this.rowPrefix;
        }

        public void setRowPrefix(String rowPrefix) {
            this.rowPrefix = rowPrefix;
        }
    }

    public static class Row {
        private final List<String> cells;

        public Row(List<String> cells) {
            this.cells = cells;
        }
    }
}

