/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import java.util.Collection;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.service.statistics.helpers.WorkspaceStatisticsHelper;
import org.squashtest.tm.service.statistics.testcase.TestCaseBoundRequirementsStatistics;
import org.squashtest.tm.service.statistics.testcase.TestCaseImportanceStatistics;
import org.squashtest.tm.service.statistics.testcase.TestCaseSizeStatistics;
import org.squashtest.tm.service.statistics.testcase.TestCaseStatisticsBundle;
import org.squashtest.tm.service.statistics.testcase.TestCaseStatusesStatistics;
import org.squashtest.tm.service.testcase.TestCaseStatisticsService;

@Service(value="TestCaseStatisticsService")
@Transactional(readOnly=true)
public class TestCaseStatisticsServiceImpl
implements TestCaseStatisticsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseStatisticsService.class);
    private static final String TEST_CASE_IDS = "testCaseIds";
    private static final String SQL_SIZE_STATISTICS = "select sct.sizeclass, count(sct.sizeclass) as count from (select case \twhen count(tcs.step_id) = 0 then 0 \twhen count(tcs.step_id) < 11 then 1 \twhen count(tcs.step_id) < 21 then 2 \telse 3  end as sizeclass from TEST_CASE tc left outer join TEST_CASE_STEPS tcs on tc.tcln_id = tcs.test_case_id where tc.tcln_id in (:testCaseIds) group by tc.tcln_id ) as sct group by sct.sizeclass";
    private static final String SQL_BOUND_REQS_STATISTICS = "select coverage.sizeclass, count(coverage.sizeclass) as count from (select case \twhen count(cov.requirement_version_coverage_id) = 0 then 0 \twhen count(cov.requirement_version_coverage_id) = 1 then 1 \telse 2  end as sizeclass from TEST_CASE tc left outer join REQUIREMENT_VERSION_COVERAGE cov on tc.tcln_id = cov.verifying_test_case_id where tc.tcln_id in (:testCaseIds) group by tc.tcln_id ) as coverage group by coverage.sizeclass";
    private static final String IMPORTANCE_NAMED_QUERY = "TestCaseStatistics.importanceStatistics";
    private static final String STATUSES_NAMED_QUERY = "TestCaseStatistics.statusesStatistics";
    @PersistenceContext
    private EntityManager em;

    @Override
    public TestCaseBoundRequirementsStatistics gatherBoundRequirementStatistics(Collection<Long> testCaseIds) {
        if (testCaseIds.isEmpty()) {
            return new TestCaseBoundRequirementsStatistics();
        }
        Map<Object, Integer> tuples = WorkspaceStatisticsHelper.retrieveAllStatisticsResultPartitionsIntoMap(SQL_BOUND_REQS_STATISTICS, true, TEST_CASE_IDS, testCaseIds, this.em);
        TestCaseBoundRequirementsStatistics stats = new TestCaseBoundRequirementsStatistics();
        for (Map.Entry<Object, Integer> tuple : tuples.entrySet()) {
            Integer sizeClass = (Integer)tuple.getKey();
            Integer count = tuple.getValue();
            switch (sizeClass) {
                case 0: {
                    stats.setZeroRequirements(count);
                    break;
                }
                case 1: {
                    stats.setOneRequirement(count);
                    break;
                }
                case 2: {
                    stats.setManyRequirements(count);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("TestCaseStatisticsServiceImpl#gatherBoundRequirementStatistics : there should not be a sizeclass <0 or >2. It's a bug.");
                }
            }
        }
        return stats;
    }

    @Override
    public TestCaseImportanceStatistics gatherTestCaseImportanceStatistics(Collection<Long> testCaseIds) {
        if (testCaseIds.isEmpty()) {
            return new TestCaseImportanceStatistics();
        }
        Map<Object, Integer> tuples = WorkspaceStatisticsHelper.retrieveAllStatisticsResultPartitionsIntoMap(IMPORTANCE_NAMED_QUERY, false, TEST_CASE_IDS, testCaseIds, this.em);
        TestCaseImportanceStatistics stats = new TestCaseImportanceStatistics();
        for (Map.Entry<Object, Integer> tuple : tuples.entrySet()) {
            TestCaseImportance importance = (TestCaseImportance)tuple.getKey();
            Integer cardinality = tuple.getValue();
            switch (importance) {
                case VERY_HIGH: {
                    stats.setVeryHigh(cardinality);
                    break;
                }
                case HIGH: {
                    stats.setHigh(cardinality);
                    break;
                }
                case MEDIUM: {
                    stats.setMedium(cardinality);
                    break;
                }
                case LOW: {
                    stats.setLow(cardinality);
                    break;
                }
                default: {
                    LOGGER.warn("TestCaseStatisticsService cannot handle the following TestCaseImportance value: '{}'", new Object[]{tuple.getKey()});
                }
            }
        }
        return stats;
    }

    @Override
    public TestCaseStatusesStatistics gatherTestCaseStatusesStatistics(Collection<Long> testCaseIds) {
        if (testCaseIds.isEmpty()) {
            return new TestCaseStatusesStatistics();
        }
        Map<Object, Integer> tuples = WorkspaceStatisticsHelper.retrieveAllStatisticsResultPartitionsIntoMap(STATUSES_NAMED_QUERY, false, TEST_CASE_IDS, testCaseIds, this.em);
        TestCaseStatusesStatistics stats = new TestCaseStatusesStatistics();
        for (Map.Entry<Object, Integer> tuple : tuples.entrySet()) {
            TestCaseStatus status = (TestCaseStatus)tuple.getKey();
            Integer cardinality = tuple.getValue();
            switch (status) {
                case WORK_IN_PROGRESS: {
                    stats.setWorkInProgress(cardinality);
                    break;
                }
                case APPROVED: {
                    stats.setApproved(cardinality);
                    break;
                }
                case OBSOLETE: {
                    stats.setObsolete(cardinality);
                    break;
                }
                case TO_BE_UPDATED: {
                    stats.setToBeUpdated(cardinality);
                    break;
                }
                case UNDER_REVIEW: {
                    stats.setUnderReview(cardinality);
                    break;
                }
            }
        }
        return stats;
    }

    @Override
    public TestCaseSizeStatistics gatherTestCaseSizeStatistics(Collection<Long> testCaseIds) {
        if (testCaseIds.isEmpty()) {
            return new TestCaseSizeStatistics();
        }
        Map<Object, Integer> tuples = WorkspaceStatisticsHelper.retrieveAllStatisticsResultPartitionsIntoMap(SQL_SIZE_STATISTICS, true, TEST_CASE_IDS, testCaseIds, this.em);
        TestCaseSizeStatistics stats = new TestCaseSizeStatistics();
        for (Map.Entry<Object, Integer> tuple : tuples.entrySet()) {
            Integer sizeClass = (Integer)tuple.getKey();
            Integer count = tuple.getValue();
            switch (sizeClass) {
                case 0: {
                    stats.setZeroSteps(count);
                    break;
                }
                case 1: {
                    stats.setBetween0And10Steps(count);
                    break;
                }
                case 2: {
                    stats.setBetween11And20Steps(count);
                    break;
                }
                case 3: {
                    stats.setAbove20Steps(count);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("TestCaseStatisticsServiceImpl#gatherTestCaseSizeStatistics : there should not be a sizeclass <0 or >3. It's a bug.");
                }
            }
        }
        return stats;
    }

    @Override
    public TestCaseStatisticsBundle gatherTestCaseStatisticsBundle(Collection<Long> testCaseIds) {
        TestCaseBoundRequirementsStatistics reqs = this.gatherBoundRequirementStatistics(testCaseIds);
        TestCaseImportanceStatistics imp = this.gatherTestCaseImportanceStatistics(testCaseIds);
        TestCaseStatusesStatistics status = this.gatherTestCaseStatusesStatistics(testCaseIds);
        TestCaseSizeStatistics size = this.gatherTestCaseSizeStatistics(testCaseIds);
        return new TestCaseStatisticsBundle(reqs, imp, status, size, testCaseIds);
    }
}

