/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.loaders.testcase.TestCaseLoader;
import org.squashtest.tm.service.internal.testcase.TestCaseCallTreeFinder;
import org.squashtest.tm.service.testcase.TestCaseImportanceManagerService;

@Service
@Transactional
public class TestCaseImportanceManagerServiceImpl
implements TestCaseImportanceManagerService {
    @Inject
    private RequirementDao requirementDao;
    @Inject
    private RequirementVersionDao requirementVersionDao;
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private TestCaseCallTreeFinder callTreeFinder;
    @Inject
    private TestCaseLoader testCaseLoader;

    private List<RequirementCriticality> findAllDistinctRequirementsCriticalityByTestCaseId(long testCaseId) {
        Set<Long> calleesIds = this.callTreeFinder.getTestCaseCallTree(testCaseId);
        calleesIds.add(testCaseId);
        return this.requirementDao.findDistinctRequirementsCriticalitiesVerifiedByTestCases(calleesIds);
    }

    private TestCaseImportance deduceImportanceAuto(long testCaseId) {
        List<RequirementCriticality> rCriticalities = this.findAllDistinctRequirementsCriticalityByTestCaseId(testCaseId);
        return TestCaseImportance.deduceTestCaseImportance(rCriticalities);
    }

    @Override
    public void changeImportanceIfIsAuto(long testCaseId) {
        TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId);
        if (Boolean.TRUE.equals(testCase.isImportanceAuto())) {
            TestCaseImportance importance = this.deduceImportanceAuto(testCaseId);
            testCase.setImportance(importance);
        }
    }

    @Override
    public void changeImportanceIfRelationsAddedToReq(List<TestCase> testCases, RequirementVersion requirementVersion) {
        RequirementCriticality requirementCriticality = requirementVersion.getCriticality();
        for (TestCase testCase : testCases) {
            this.changeImportanceIfRelationAdded(testCase, requirementCriticality);
        }
    }

    @Override
    public void changeImportanceIfRelationsAddedToTestCase(List<RequirementVersion> requirementVersions, TestCase testCase) {
        if (!requirementVersions.isEmpty()) {
            List<RequirementCriticality> requirementCriticalities = this.extractCriticalities(requirementVersions);
            RequirementCriticality strongestRequirementCriticality = RequirementCriticality.findStrongestCriticality(requirementCriticalities);
            this.changeImportanceIfRelationAdded(testCase, strongestRequirementCriticality);
        }
    }

    private List<RequirementCriticality> extractCriticalities(List<RequirementVersion> requirementVersions) {
        ArrayList<RequirementCriticality> requirementCriticalities = new ArrayList<RequirementCriticality>(requirementVersions.size());
        for (RequirementVersion requirementVersion : requirementVersions) {
            requirementCriticalities.add(requirementVersion.getCriticality());
        }
        return requirementCriticalities;
    }

    private void changeImportanceIfRelationAdded(TestCase testCase, RequirementCriticality requirementCriticality) {
        block3: {
            block2: {
                if (!Boolean.TRUE.equals(testCase.isImportanceAuto())) break block2;
                TestCaseImportance importance = testCase.getImportance();
                TestCaseImportance newImportance = importance.deduceNewImporanceWhenAddCriticality(requirementCriticality);
                if (newImportance == importance) break block3;
                testCase.setImportance(newImportance);
                List callingTestCases = this.testCaseDao.findAllCallingTestCases(testCase.getId(), null);
                for (TestCase callingTestCase : callingTestCases) {
                    this.changeImportanceIfRelationAdded(callingTestCase, requirementCriticality);
                }
                break block3;
            }
            List callingTestCases = this.testCaseDao.findAllCallingTestCases(testCase.getId(), null);
            for (TestCase callingTestCase : callingTestCases) {
                this.changeImportanceIfRelationAdded(callingTestCase, requirementCriticality);
            }
        }
    }

    @Override
    public void changeImportanceIfRelationsRemovedFromReq(List<Long> testCasesIds, long requirementVersionId) {
        RequirementVersion requirementVersion = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        RequirementCriticality requirementCriticality = requirementVersion.getCriticality();
        TestCaseImportance reqCritImportance = TestCaseImportance.deduceTestCaseImportance(Arrays.asList(requirementCriticality));
        List<TestCase> testCases = this.extractTestCases(testCasesIds);
        for (TestCase testCase : testCases) {
            this.changeImportanceIfRelationRemoved(reqCritImportance, testCase);
        }
    }

    @Override
    public void changeImportanceIfRelationRemoved(TestCaseImportance maxReqCritImportance, TestCase testCase) {
        if (Boolean.TRUE.equals(testCase.isImportanceAuto())) {
            TestCaseImportance newImportance;
            TestCaseImportance actualImportance = testCase.getImportance();
            if (maxReqCritImportance.getLevel() <= actualImportance.getLevel() && (newImportance = this.deduceImportanceAuto(testCase.getId())) != actualImportance) {
                this.changeImportanceIfRelationRemovedForAll(testCase, newImportance, maxReqCritImportance);
            }
        } else {
            List callingTestCases = this.testCaseDao.findAllCallingTestCases(testCase.getId(), null);
            for (TestCase callingTestCase : callingTestCases) {
                this.changeImportanceIfRelationRemoved(maxReqCritImportance, callingTestCase);
            }
        }
    }

    private void changeImportanceIfRelationRemovedForAll(TestCase testCase, TestCaseImportance newImportance, TestCaseImportance maxReqCritImportance) {
        testCase.setImportance(newImportance);
        List callingTestCases = this.testCaseDao.findAllCallingTestCases(testCase.getId(), null);
        for (TestCase callingTestCase : callingTestCases) {
            this.changeImportanceIfRelationRemoved(maxReqCritImportance, callingTestCase);
        }
    }

    private List<TestCase> extractTestCases(List<Long> testCasesIds) {
        return this.testCaseLoader.load(testCasesIds);
    }

    @Override
    public void changeImportanceIfRelationsRemovedFromTestCase(List<Long> requirementsVersionIds, long testCaseId) {
        if (!requirementsVersionIds.isEmpty()) {
            TestCase testCase = (TestCase)this.testCaseLoader.load(testCaseId);
            List<RequirementCriticality> reqCriticalities = this.requirementDao.findDistinctRequirementsCriticalities(requirementsVersionIds);
            TestCaseImportance maxReqCritImportance = TestCaseImportance.deduceTestCaseImportance(reqCriticalities);
            this.changeImportanceIfRelationRemoved(maxReqCritImportance, testCase);
        }
    }

    @Override
    public void changeImportanceIfRequirementCriticalityChanged(long requirementVersionId, RequirementCriticality oldRequirementCriticality) {
        RequirementVersion requirementVersion = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        List testCases = this.testCaseDao.findUnsortedAllByVerifiedRequirementVersion(requirementVersionId);
        for (TestCase testCase : testCases) {
            this.changeImportanceIfRequirementCriticalityChanged(oldRequirementCriticality, requirementVersion, testCase);
        }
    }

    private void changeImportanceIfRequirementCriticalityChanged(RequirementCriticality oldRequirementCriticality, RequirementVersion requirementVersion, TestCase testCase) {
        if (Boolean.TRUE.equals(testCase.isImportanceAuto())) {
            TestCaseImportance newImportanceAuto;
            TestCaseImportance importanceAuto = testCase.getImportance();
            boolean importanceAutoCanChange = importanceAuto.changeOfCriticalityCanChangeImportanceAuto(oldRequirementCriticality, requirementVersion.getCriticality());
            if (importanceAutoCanChange && importanceAuto != (newImportanceAuto = this.deduceImportanceAuto(testCase.getId()))) {
                testCase.setImportance(newImportanceAuto);
                this.changeImportanceIfRequirementCriticalityChangedForAll(testCase, oldRequirementCriticality, requirementVersion);
            }
        } else {
            List callingTestCases = this.testCaseDao.findAllCallingTestCases(testCase.getId(), null);
            for (TestCase callingTestCase : callingTestCases) {
                this.changeImportanceIfRequirementCriticalityChanged(oldRequirementCriticality, requirementVersion, callingTestCase);
            }
        }
    }

    private void changeImportanceIfRequirementCriticalityChangedForAll(TestCase testCase, RequirementCriticality oldRequirementCriticality, RequirementVersion requirementVersion) {
        List callingTestCases = this.testCaseDao.findAllCallingTestCases(testCase.getId(), null);
        for (TestCase callingTestCase : callingTestCases) {
            this.changeImportanceIfRequirementCriticalityChanged(oldRequirementCriticality, requirementVersion, callingTestCase);
        }
    }

    @Override
    public void changeImportanceIfCallStepAddedToTestCases(TestCase calledTestCase, TestCase parentTestCase) {
        List<RequirementCriticality> rCriticalities = this.findAllDistinctRequirementsCriticalityByTestCaseId(calledTestCase.getId());
        if (!rCriticalities.isEmpty()) {
            RequirementCriticality strongestRequirementCriticality = RequirementCriticality.findStrongestCriticality(rCriticalities);
            this.changeImportanceIfRelationAdded(parentTestCase, strongestRequirementCriticality);
        }
    }

    @Override
    public void changeImportanceIfCallStepAddedToTestCases(Map<TestCase, Set<Long>> calledIdsByCaller) {
        Map<Long, Set<RequirementCriticality>> calledCriticalityListByCallerId = this.findAllReqCriticalityByTestCaseCallerId(calledIdsByCaller);
        if (calledCriticalityListByCallerId.isEmpty()) {
            return;
        }
        Map<TestCase, RequirementCriticality> strongestCriticalityByCaller = calledIdsByCaller.keySet().stream().map(caller -> Map.entry(caller, (Set)calledCriticalityListByCallerId.get(caller.getId()))).filter(entry -> !((Set)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, entry -> RequirementCriticality.findStrongestCriticality(List.copyOf((Collection)entry.getValue()))));
        List<Long> callerIds = strongestCriticalityByCaller.keySet().stream().map(TestCaseLibraryNode::getId).toList();
        Map callingTestCaseByCallerId = this.testCaseDao.findRecursiveCallerTestCasesByCalledId(callerIds);
        for (Map.Entry<TestCase, RequirementCriticality> entry2 : strongestCriticalityByCaller.entrySet()) {
            TestCase callerTestCase = entry2.getKey();
            RequirementCriticality criticality = entry2.getValue();
            if (Boolean.TRUE.equals(callerTestCase.isImportanceAuto())) {
                this.updateTestCaseImportance(callerTestCase, criticality);
            }
            callingTestCaseByCallerId.getOrDefault(callerTestCase.getId(), Collections.emptyList()).stream().filter(calling -> Boolean.TRUE.equals(calling.isImportanceAuto())).forEach(callingTestCase -> this.updateTestCaseImportance((TestCase)callingTestCase, criticality));
        }
    }

    private void updateTestCaseImportance(TestCase testCase, RequirementCriticality criticality) {
        TestCaseImportance currentImportance = testCase.getImportance();
        TestCaseImportance newImportance = currentImportance.deduceNewImporanceWhenAddCriticality(criticality);
        if (!newImportance.equals((Object)currentImportance)) {
            testCase.setImportance(newImportance);
        }
    }

    private Map<Long, Set<RequirementCriticality>> findAllReqCriticalityByTestCaseCallerId(Map<TestCase, Set<Long>> calledIdsByParent) {
        Set<Long> allCalledIds = calledIdsByParent.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map calledListByCallerId = this.testCaseDao.findRecursiveCalledIdsByCallerId(allCalledIds);
        allCalledIds.forEach(calledId -> {
            boolean bl = calledListByCallerId.computeIfAbsent(calledId, k -> new ArrayList()).add(calledId);
        });
        Map<Long, RequirementCriticality> criticalityByCalledId = this.requirementDao.findRequirementsCriticalityVerifiedByTestCases(calledListByCallerId.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        HashMap<Long, Set<RequirementCriticality>> calledCriticalityListByCallerId = new HashMap<Long, Set<RequirementCriticality>>();
        for (Map.Entry<TestCase, Set<Long>> entry : calledIdsByParent.entrySet()) {
            entry.getValue().stream().map(calledListByCallerId::get).flatMap(Collection::stream).filter(criticalityByCalledId::containsKey).forEach(id -> {
                boolean bl = calledCriticalityListByCallerId.computeIfAbsent(((TestCase)entry.getKey()).getId(), k -> new HashSet()).add((RequirementCriticality)criticalityByCalledId.get(id));
            });
        }
        if (calledCriticalityListByCallerId.isEmpty()) {
            return Collections.emptyMap();
        }
        return calledCriticalityListByCallerId;
    }

    @Override
    public void changeImportanceIfCallStepRemoved(TestCase calledTestCase, TestCase parentTestCase) {
        List<RequirementCriticality> rCriticalities = this.findAllDistinctRequirementsCriticalityByTestCaseId(calledTestCase.getId());
        if (!rCriticalities.isEmpty()) {
            TestCaseImportance maxReqCritImportance = TestCaseImportance.deduceTestCaseImportance(rCriticalities);
            this.changeImportanceIfRelationRemoved(maxReqCritImportance, parentTestCase);
        }
    }
}

