/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.logging.log4j.util.Strings;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.ThrowIfNotStandardTestCaseVisitor;
import org.squashtest.tm.exception.CyclicStepCallException;
import org.squashtest.tm.exception.NonClassicStepCallException;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.internal.batchimport.Batch;
import org.squashtest.tm.service.internal.batchimport.CallStepImportData;
import org.squashtest.tm.service.internal.display.dto.testcase.AbstractTestStepDto;
import org.squashtest.tm.service.internal.display.dto.testcase.PasteTestStepOperationReport;
import org.squashtest.tm.service.internal.repository.CustomDatasetParamValueDao;
import org.squashtest.tm.service.internal.repository.DatasetParamValueDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.TestStepDao;
import org.squashtest.tm.service.internal.repository.display.TestStepDisplayDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;
import org.squashtest.tm.service.internal.repository.loaders.testcase.TestCaseLoader;
import org.squashtest.tm.service.internal.testcase.TestCaseCallTreeFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.testcase.CallStepManagerService;
import org.squashtest.tm.service.testcase.DatasetModificationService;
import org.squashtest.tm.service.testcase.TestCaseCyclicCallChecker;
import org.squashtest.tm.service.testcase.TestCaseImportanceManagerService;

@Service(value="squashtest.tm.service.CallStepManagerService")
@Transactional
public class CallStepManagerServiceImpl
implements CallStepManagerService,
TestCaseCyclicCallChecker {
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private TestStepDao testStepDao;
    @Inject
    private TestCaseCallTreeFinder callTreeFinder;
    @Inject
    private TestCaseImportanceManagerService testCaseImportanceManagerService;
    @Inject
    private DatasetModificationService datasetModificationService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private TestStepDisplayDao testStepDisplayDao;
    @Inject
    private CustomDatasetParamValueDao customDatasetParamValueDao;
    @Inject
    private DatasetParamValueDao datasetParamValueDao;
    @Inject
    private TestCaseLoader testCaseLoader;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    @PreAuthorize(value="(hasPermission(#parentTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') and hasPermission(#calledTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ'))  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    public CallTestStep addCallTestStep(@Id long parentTestCaseId, long calledTestCaseId) {
        return this.addCallTestStepUnsecured(parentTestCaseId, calledTestCaseId);
    }

    @Override
    public CallTestStep addCallTestStepUnsecured(@Id long parentTestCaseId, long calledTestCaseId) {
        return this.doAddCallTestStep(parentTestCaseId, calledTestCaseId, null);
    }

    @Override
    @PreAuthorize(value="(hasPermission(#parentTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') and hasPermission(#calledTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ'))  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    public CallTestStep addCallTestStep(@Id long parentTestCaseId, long calledTestCaseId, int index) {
        return this.doAddCallTestStep(parentTestCaseId, calledTestCaseId, index);
    }

    @Override
    public CallTestStep addCallTestStepUnsecured(long parentTestCaseId, long calledTestCaseId, int index) {
        return this.doAddCallTestStep(parentTestCaseId, calledTestCaseId, index);
    }

    private CallTestStep doAddCallTestStep(long parentTestCaseId, long calledTestCaseId, Integer index) {
        this.checkCyclicCalls(parentTestCaseId, calledTestCaseId);
        Object testCases = this.testCaseLoader.load(List.of(Long.valueOf(parentTestCaseId), Long.valueOf(calledTestCaseId)), EnumSet.of(TestCaseLoader.Options.FETCH_STEPS));
        TestCase parentTestCase = testCases.stream().filter(tc -> tc.getId() == parentTestCaseId).findFirst().orElseThrow();
        TestCase calledTestCase = testCases.stream().filter(tc -> tc.getId() == calledTestCaseId).findFirst().orElseThrow();
        CallTestStep newStep = new CallTestStep();
        newStep.setCalledTestCase(calledTestCase);
        newStep.setTestCase(parentTestCase);
        this.testStepDao.persist(newStep);
        if (index == null) {
            parentTestCase.addStep((TestStep)newStep);
        } else {
            parentTestCase.addStep(index.intValue(), (TestStep)newStep);
        }
        this.testCaseImportanceManagerService.changeImportanceIfCallStepAddedToTestCases(calledTestCase, parentTestCase);
        return newStep;
    }

    @Override
    @PreAuthorize(value="hasPermission(#parentTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestCase.class)
    public PasteTestStepOperationReport addCallTestSteps(@Id long parentTestCaseId, List<Long> calledTestCaseIds, Integer index) {
        PermissionsUtils.checkPermission(this.permissionEvaluationService, calledTestCaseIds, Permissions.READ.name(), TestCaseLibraryNode.class.getName());
        TestCase parentTestCase = (TestCase)this.testCaseLoader.load(parentTestCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_STEPS));
        ThrowIfNotStandardTestCaseVisitor testCaseVisitor = new ThrowIfNotStandardTestCaseVisitor((RuntimeException)new NonClassicStepCallException());
        parentTestCase.accept((TestCaseVisitor)testCaseVisitor);
        List testCases = this.entityManager.createQuery("select tc from TestCase tc, TestCasePathEdge closure where closure.ancestorId in :ids and closure.descendantId = tc.id", TestCase.class).setParameter("ids", calledTestCaseIds).getResultList();
        HibernateConfig.enableBatch(this.entityManager, 50);
        ArrayList<CallTestStep> newSteps = new ArrayList<CallTestStep>();
        for (TestCase calledTestCase : testCases) {
            this.checkCyclicCalls(parentTestCaseId, calledTestCase.getId());
            calledTestCase.accept((TestCaseVisitor)testCaseVisitor);
            CallTestStep newStep = new CallTestStep();
            newStep.setCalledTestCase(calledTestCase);
            newStep.setTestCase(parentTestCase);
            this.testStepDao.persist(newStep);
            newSteps.add(newStep);
            if (index != null) {
                parentTestCase.addStep(index.intValue(), (TestStep)newStep);
            } else {
                parentTestCase.addStep((TestStep)newStep);
            }
            this.testCaseImportanceManagerService.changeImportanceIfCallStepAddedToTestCases(calledTestCase, parentTestCase);
        }
        this.entityManager.flush();
        Set<Long> ids = newSteps.stream().map(TestStep::getId).collect(Collectors.toSet());
        HibernateConfig.disabledBatch(this.entityManager);
        return this.craftOperationReport(parentTestCase, ids);
    }

    private PasteTestStepOperationReport craftOperationReport(TestCase testCase, Set<Long> ids) {
        PasteTestStepOperationReport operationReport = new PasteTestStepOperationReport();
        List<AbstractTestStepDto> testSteps = this.testStepDisplayDao.getTestSteps(ids);
        operationReport.addTestSteps(testSteps);
        operationReport.setTestCaseImportance(testCase.getImportance().name());
        return operationReport;
    }

    private void checkCyclicCalls(long callingTestCaseId, long calledTestCaseId) {
        this.checkCyclicCallOneWay(calledTestCaseId, callingTestCaseId);
    }

    private void checkCyclicCallOneWay(long callingTestCaseId, long calledTestCaseId) {
        if (callingTestCaseId == calledTestCaseId) {
            throw new CyclicStepCallException();
        }
        Set<Long> callTree = this.callTreeFinder.getTestCaseCallTree(callingTestCaseId);
        if (callTree.contains(calledTestCaseId)) {
            throw new CyclicStepCallException();
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public TestCase findTestCase(long testCaseId) {
        return (TestCase)this.testCaseLoader.load(testCaseId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public void checkForCyclicStepCallBeforePaste(long destinationTestCaseId, String[] pastedStepId) {
        List<Long> idsAsList = this.parseLong(pastedStepId);
        this.checkForCyclicStepCallBeforePaste(destinationTestCaseId, idsAsList);
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public void checkForCyclicStepCallBeforePaste(long destinationTestCaseId, List<Long> pastedStepId) {
        List firstCalledTestCasesIds = this.testCaseDao.findCalledTestCaseOfCallSteps(pastedStepId);
        if (firstCalledTestCasesIds.contains(destinationTestCaseId)) {
            throw new CyclicStepCallException();
        }
        for (Long testCaseId : firstCalledTestCasesIds) {
            Set<Long> callTree = this.callTreeFinder.getTestCaseCallTree(testCaseId);
            if (!callTree.contains(destinationTestCaseId)) continue;
            throw new CyclicStepCallException();
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationTestCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public void checkForCyclicStepCallBeforePaste(Long destinationTestCaseId, Long calledTestCaseId) {
        if (calledTestCaseId.equals(destinationTestCaseId)) {
            throw new CyclicStepCallException();
        }
        Set<Long> callTree = this.callTreeFinder.getTestCaseCallTree(calledTestCaseId);
        if (callTree.contains(destinationTestCaseId)) {
            throw new CyclicStepCallException();
        }
    }

    private List<Long> parseLong(String[] stringArray) {
        ArrayList<Long> longList = new ArrayList<Long>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String aStringArray = stringArray2[n2];
            longList.add(Long.parseLong(aStringArray));
            ++n2;
        }
        return longList;
    }

    @Override
    @Transactional(readOnly=true)
    public void checkNoCyclicCall(TestCase testCase) throws CyclicStepCallException {
        long rootTestCaseId = testCase.getId();
        List<Long> firstCalledTestCasesIds = this.testCaseDao.findAllDistinctTestCasesIdsCalledByTestCase(rootTestCaseId);
        if (firstCalledTestCasesIds.contains(rootTestCaseId)) {
            throw new CyclicStepCallException();
        }
        for (Long testCaseId : firstCalledTestCasesIds) {
            Set<Long> callTree = this.callTreeFinder.getTestCaseCallTree(testCaseId);
            if (!callTree.contains(rootTestCaseId)) continue;
            throw new CyclicStepCallException();
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#callStepId, 'org.squashtest.tm.domain.testcase.CallTestStep', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void setParameterAssignationMode(long callStepId, ParameterAssignationMode mode, Long datasetId) {
        CallTestStep step = (CallTestStep)this.testStepDao.findById(callStepId);
        Long callerId = step.getTestCase().getId();
        this.doSetParameterAssignationMode(mode, datasetId, step, callerId);
    }

    @Override
    public void setParameterAssignationModeUnsecured(CallTestStep callTestStep, Long callerTestCaseId, ParameterAssignationMode mode, Long datasetId) {
        this.doSetParameterAssignationMode(mode, datasetId, callTestStep, callerTestCaseId);
    }

    private void doSetParameterAssignationMode(ParameterAssignationMode mode, Long datasetId, CallTestStep step, Long callerId) {
        switch (mode) {
            case NOTHING: {
                step.setCalledDataset(null);
                step.setDelegateParameterValues(false);
                this.deleteOrphanDatasetParamValuesByTestCaseCallerId(callerId);
                break;
            }
            case DELEGATE: {
                step.setCalledDataset(null);
                step.setDelegateParameterValues(true);
                break;
            }
            case CALLED_DATASET: {
                this.checkNullDataset(datasetId);
                step.setCalledDataset(this.datasetModificationService.findById(datasetId));
                step.setDelegateParameterValues(false);
                this.deleteOrphanDatasetParamValuesByTestCaseCallerId(callerId);
                break;
            }
            default: {
                throw new IllegalArgumentException("ParameterAssignationMode '" + mode + "' is not handled here, please find a dev and make him do the job");
            }
        }
        this.datasetModificationService.cascadeDatasetsUpdate(callerId);
    }

    private void checkNullDataset(Long datasetId) {
        if (datasetId == null) {
            throw new IllegalArgumentException("attempted to bind no dataset (datasetid is null) to a call step, yet the parameter assignation mode is 'CALLED_DATASET'");
        }
    }

    @Override
    public void deleteOrphanDatasetParamValuesByTestCaseCallerId(Long testCaseCallerId) {
        List<Long> orphanDatasetParamValueIds = this.customDatasetParamValueDao.findOrphanDatasetParamValuesByTestCaseCallerId(testCaseCallerId);
        List datasetParamValuesToDelete = this.datasetParamValueDao.findAllById(orphanDatasetParamValueIds);
        if (!datasetParamValuesToDelete.isEmpty()) {
            this.datasetParamValueDao.deleteAll(datasetParamValuesToDelete);
        }
    }

    @Override
    public void addImportCallSteps(Project project, List<Long> callerTestCaseIds, List<Batch<CallStepImportData>> batches) {
        Map<Long, TestCase> callerTestCases = this.testCaseLoader.load(callerTestCaseIds, EnumSet.of(TestCaseLoader.Options.FETCH_STEPS)).stream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
        Set allCalledIds = batches.stream().flatMap(b -> b.getEntities().stream()).map(CallStepImportData::getCalledTestCaseId).collect(Collectors.toSet());
        Map<Long, TestCase> calledTestCases = this.testCaseLoader.load(allCalledIds, EnumSet.of(TestCaseLoader.Options.FETCH_STEPS, TestCaseLoader.Options.FETCH_DATASETS)).stream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
        Map<TestCase, Set<Long>> calledIdsByCaller = this.batchCallStepsAddition(batches, callerTestCases, calledTestCases);
        this.testCaseImportanceManagerService.changeImportanceIfCallStepAddedToTestCases(calledIdsByCaller);
        this.updateParametersAssignation(batches);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void updateParametersAssignation(List<Batch<CallStepImportData>> batches) {
        HashSet<Long> callerIds = new HashSet<Long>();
        for (Batch<CallStepImportData> batch : batches) {
            for (CallStepImportData callStepData : batch.getEntities()) {
                CallStepManagerServiceImpl.verifyCalledDatasetMode(callStepData);
                CallTestStep callStep = callStepData.getCallTestStep();
                ParameterAssignationMode mode = callStepData.getParameterMode();
                switch (mode) {
                    case NOTHING: {
                        callStep.setCalledDataset(null);
                        callStep.setDelegateParameterValues(false);
                        callerIds.add(batch.getTargetId());
                        break;
                    }
                    case DELEGATE: {
                        callStep.setCalledDataset(null);
                        callStep.setDelegateParameterValues(true);
                        break;
                    }
                    case CALLED_DATASET: {
                        callStep.setCalledDataset(callStepData.getDataset());
                        callStep.setDelegateParameterValues(false);
                        callerIds.add(batch.getTargetId());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("ParameterAssignationMode '" + mode + "' is not handled here, please find a dev and make him do the job");
                    }
                }
            }
        }
        this.datasetModificationService.cascadeDatasetsUpdate(callerIds);
    }

    private static void verifyCalledDatasetMode(CallStepImportData callStepData) {
        if (!ParameterAssignationMode.CALLED_DATASET.equals((Object)callStepData.getParameterMode())) {
            return;
        }
        TestCase called = callStepData.getCallTestStep().getCalledTestCase();
        String datasetName = callStepData.getCalledDatasetName();
        if (!Strings.isBlank((String)datasetName)) {
            Dataset dataset = called.getDatasets().stream().filter(ds -> ds.getName().equals(datasetName)).findFirst().orElse(null);
            if (dataset != null) {
                callStepData.setDataset(dataset);
            } else {
                callStepData.setParameterMode(ParameterAssignationMode.NOTHING);
            }
        }
    }

    private Map<TestCase, Set<Long>> batchCallStepsAddition(List<Batch<CallStepImportData>> batches, Map<Long, TestCase> callerTestCases, Map<Long, TestCase> calledTestCases) {
        HashMap<TestCase, Set<Long>> calledIdsByCaller = new HashMap<TestCase, Set<Long>>();
        for (Batch<CallStepImportData> batch : batches) {
            TestCase callerTestCase = callerTestCases.get(batch.getTargetId());
            List<CallStepImportData> callSteps = batch.getEntities();
            callSteps.sort(Comparator.comparing(CallStepImportData::getIndex, Comparator.nullsLast(Comparator.naturalOrder())));
            for (CallStepImportData callStepData : callSteps) {
                TestCase calledTestCase = calledTestCases.get(callStepData.getCalledTestCaseId());
                Integer index = callStepData.getIndex();
                CallTestStep callTestStep = new CallTestStep();
                callTestStep.setCalledTestCase(calledTestCase);
                callTestStep.setTestCase(callerTestCase);
                this.testStepDao.persist(callTestStep);
                if (index != null && index >= 0 && index < callerTestCase.getSteps().size()) {
                    callerTestCase.addStep(index.intValue(), (TestStep)callTestStep);
                } else {
                    callerTestCase.addStep((TestStep)callTestStep);
                }
                callStepData.setCallTestStep(callTestStep);
            }
            calledIdsByCaller.computeIfAbsent(callerTestCase, k -> new HashSet()).add(callerTestCase.getId());
        }
        return calledIdsByCaller;
    }
}

