/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;
import org.squashtest.tm.service.testautomation.spi.UnknownConnectorKind;

@Component(value="squashtest.testautomation.connector-registry")
public class TestAutomationConnectorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationConnectorRegistry.class);
    @Autowired(required=false)
    private Collection<TestAutomationConnector> connectors = Collections.emptyList();
    private Map<TestAutomationServerKind, TestAutomationConnector> availableConnectors = new ConcurrentHashMap<TestAutomationServerKind, TestAutomationConnector>(5);

    public Collection<TestAutomationServerKind> listRegisteredConnectors() {
        return this.availableConnectors.keySet();
    }

    public TestAutomationConnector getConnectorForKind(TestAutomationServerKind kind) {
        TestAutomationConnector connector = this.availableConnectors.get(kind);
        if (connector == null) {
            UnknownConnectorKind ex = new UnknownConnectorKind("TestAutomationConnector : unknown kind '" + kind + "'");
            ex.addArg(kind.name());
            throw ex;
        }
        return connector;
    }

    public TestAutomationConnector createConnector(TestAutomationServer taServer) {
        TestAutomationServerKind kind = taServer.getKind();
        LOGGER.debug("Creating connector for Test Autoamtion Server of kind '{}'.", new Object[]{kind});
        TestAutomationConnector testAutomationConnector = this.availableConnectors.get(kind);
        if (testAutomationConnector == null) {
            throw new IllegalArgumentException("No registered TestAutomationConnector is of type '" + kind + "'.");
        }
        return testAutomationConnector;
    }

    @PostConstruct
    public void registerConnector() {
        for (TestAutomationConnector connector : this.connectors) {
            TestAutomationServerKind kind = connector.getConnectorKind();
            if (kind == null) {
                throw new IllegalArgumentException("TestAutomationConnector : kind is undefined");
            }
            LOGGER.info("Registering connector for test automation platforms of kind '{}'", new Object[]{kind});
            this.availableConnectors.put(kind, connector);
        }
    }
}

