/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.templateplugin;

import java.util.List;
import javax.validation.constraints.NotBlank;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.Plugin;
import org.squashtest.tm.api.template.TemplateConfigurablePlugin;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.project.TemplateConfigurablePluginBinding;
import org.squashtest.tm.exception.templateplugin.TemplateConfigurablePluginBindingAlreadyExistsException;
import org.squashtest.tm.service.internal.display.dto.TemplateConfigurablePluginBindingDto;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.TemplateConfigurablePluginBindingDao;
import org.squashtest.tm.service.templateplugin.TemplateConfigurablePluginBindingService;

@Service(value="squashtest.tm.service.TemplateConfigurablePluginBindingManagerService")
@Transactional
public class TemplateConfigurablePluginBindingServiceImpl
implements TemplateConfigurablePluginBindingService {
    private final TemplateConfigurablePluginBindingDao templateConfigurablePluginBindingDao;
    private final GenericProjectDao genericProjectDao;

    TemplateConfigurablePluginBindingServiceImpl(TemplateConfigurablePluginBindingDao templateConfigurablePluginBindingDao, GenericProjectDao genericProjectDao) {
        this.templateConfigurablePluginBindingDao = templateConfigurablePluginBindingDao;
        this.genericProjectDao = genericProjectDao;
    }

    @Override
    public TemplateConfigurablePluginBinding createTemplateConfigurablePluginBinding(@NonNull ProjectTemplate template, @NonNull Project project, @NonNull TemplateConfigurablePlugin plugin) {
        if (this.hasBinding(template.getId(), project.getId(), plugin.getId())) {
            throw new TemplateConfigurablePluginBindingAlreadyExistsException();
        }
        return this.templateConfigurablePluginBindingDao.createTemplateConfigurablePluginBinding(template, project, plugin);
    }

    @Override
    public List<TemplateConfigurablePluginBinding> createTemplateConfigurablePluginBindings(@NonNull ProjectTemplate template, @NonNull Project project, @NonNull List<TemplateConfigurablePlugin> plugins) {
        List<String> pluginIds;
        long projectId;
        long templateId = template.getId();
        List<TemplateConfigurablePluginBindingDto> alreadyBoundPlugins = this.templateConfigurablePluginBindingDao.findAll(templateId, projectId = project.getId().longValue(), pluginIds = plugins.stream().map(Plugin::getId).toList());
        if (!alreadyBoundPlugins.isEmpty()) {
            throw new TemplateConfigurablePluginBindingAlreadyExistsException();
        }
        return plugins.stream().map(plugin -> this.templateConfigurablePluginBindingDao.createTemplateConfigurablePluginBinding(template, project, (TemplateConfigurablePlugin)plugin)).toList();
    }

    @Override
    public void removeAllForGenericProject(long genericProjectId) {
        if (this.genericProjectDao.isProjectTemplate(genericProjectId)) {
            this.templateConfigurablePluginBindingDao.removeAllForTemplate(genericProjectId);
        } else {
            this.templateConfigurablePluginBindingDao.removeAllForProject(genericProjectId);
        }
    }

    @Override
    public boolean hasBinding(long templateId, long projectId, @NonNull @NotBlank String pluginId) {
        return this.templateConfigurablePluginBindingDao.findOne(templateId, projectId, pluginId) != null;
    }

    @Override
    public List<TemplateConfigurablePluginBindingDto> findAllByTemplateId(long templateId) {
        return this.templateConfigurablePluginBindingDao.findAllByTemplateId(templateId);
    }

    @Override
    public List<TemplateConfigurablePluginBindingDto> findAllByTemplateIdAndPluginId(long templateId, String pluginId) {
        return this.templateConfigurablePluginBindingDao.findAllByTemplateIdAndPluginId(templateId, pluginId);
    }

    @Override
    public boolean isProjectConfigurationBoundToTemplate(long projectId) {
        return this.templateConfigurablePluginBindingDao.isProjectConfigurationBoundToTemplate(projectId);
    }

    @Override
    public boolean isProjectConfigurationBoundToTemplate(long projectId, String pluginId) {
        return this.templateConfigurablePluginBindingDao.isProjectConfigurationBoundToTemplate(projectId, pluginId);
    }
}

