/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.IdCollector;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.exception.InconsistentInfoListItemException;
import org.squashtest.tm.exception.requirement.IllegalRequirementModificationException;
import org.squashtest.tm.exception.requirement.IllegalRequirementVersionCreationException;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.repository.CustomReqVersionDao;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.display.RequirementVersionDisplayDao;
import org.squashtest.tm.service.internal.requirement.CustomRequirementVersionManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.requirement.CustomRequirementVersionManagerServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.requirement.CustomRequirementVersionManagerServiceImpl$AjcClosure5;
import org.squashtest.tm.service.internal.requirement.CustomRequirementVersionManagerServiceImpl$AjcClosure7;
import org.squashtest.tm.service.milestone.MilestoneMembershipManager;
import org.squashtest.tm.service.requirement.CustomRequirementVersionManagerService;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.service.requirement.RequirementBulkUpdate;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.security.SecurityCheckableObject;
import org.squashtest.tm.service.testcase.TestCaseImportanceManagerService;

@Service(value="CustomRequirementVersionManagerService")
@Transactional
public class CustomRequirementVersionManagerServiceImpl
implements CustomRequirementVersionManagerService {
    @Inject
    private MilestoneDao milestoneDao;
    @Inject
    private RequirementVersionDao requirementVersionDao;
    @Inject
    private RequirementVersionDisplayDao requirementVersionDisplayDao;
    @Inject
    private TestCaseImportanceManagerService testCaseImportanceManagerService;
    @Inject
    private InfoListItemFinderService infoListItemService;
    @Inject
    private MilestoneMembershipManager milestoneManager;
    @Inject
    private PrivateCustomFieldValueService customFieldValueService;
    @Inject
    private LinkedRequirementVersionManagerService requirementLinkService;
    @Inject
    private PermissionEvaluationService permService;
    @Inject
    AttachmentManagerService attachmentManagerService;
    @Inject
    private CustomReqVersionDao reqVersionDao;
    @PersistenceContext
    private EntityManager em;
    @Inject
    @Qualifier(value="squashtest.tm.repository.RequirementLibraryNodeDao")
    private LibraryNodeDao<RequirementLibraryNode> requirementLibraryNodeDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    @Override
    public Requirement findRequirementById(long requirementId) {
        return this.requirementVersionDao.findRequirementById(requirementId);
    }

    @Override
    public List<String> retrieveFullNameByRequirementLibraryNodeIds(List<Long> requirementLibraryNodeIds, List<Long> projectIds) {
        return this.requirementVersionDisplayDao.retrieveFullNameByRequirementLibraryNodeIds(requirementLibraryNodeIds, projectIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'CREATE') or hasRole('ROLE_ADMIN')")
    public void createNewVersion(long requirementId, boolean inheritReqLinks, boolean inheritTestcasesReqLinks) {
        this.createNewVersion(requirementId, inheritReqLinks, inheritTestcasesReqLinks, null);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'CREATE') or hasRole('ROLE_ADMIN')")
    public void createNewVersion(long requirementId, boolean inheritReqLinks, boolean inheritTestcasesReqLinks, AuditableMixin audit) {
        Requirement req = this.requirementVersionDao.findRequirementById(requirementId);
        if (req.isSynchronized()) {
            throw new IllegalRequirementVersionCreationException();
        }
        RequirementVersion previousVersion = req.getCurrentVersion();
        if (Objects.isNull(audit)) {
            req.increaseVersion();
        } else {
            req.increaseVersionWithAuditable(audit);
        }
        this.em.persist((Object)req.getCurrentVersion());
        RequirementVersion newVersion = this.copyAttachmentsForNewVersions(req);
        this.customFieldValueService.copyCustomFieldValues((BoundEntity)previousVersion, (BoundEntity)newVersion);
        if (inheritReqLinks) {
            this.requirementLinkService.copyRequirementVersionLinks(previousVersion, newVersion);
        }
        if (inheritTestcasesReqLinks) {
            this.requirementLinkService.postponeTestCaseToNewRequirementVersion(previousVersion, newVersion);
        }
    }

    @Override
    public void createNewVersion(long requirementId, Collection<Long> milestoneIds, boolean inheritReqLinks, boolean inheritTestcasesReqLinks) {
        this.createNewVersion(requirementId, inheritReqLinks, inheritTestcasesReqLinks);
        Requirement req = this.requirementVersionDao.findRequirementById(requirementId);
        for (RequirementVersion version : req.getRequirementVersions()) {
            for (Long mid : milestoneIds) {
                version.unbindMilestone(mid);
            }
        }
        this.milestoneManager.bindRequirementVersionToMilestones(req.getCurrentVersion().getId(), milestoneIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeCriticality(long requirementVersionId, RequirementCriticality criticality) {
        RequirementCriticality requirementCriticality = criticality;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)requirementCriticality);
        RequirementVersion requirementVersion = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        RequirementCriticality oldCriticality = requirementVersion.getCriticality();
        requirementVersion.setCriticality(criticality);
        this.testCaseImportanceManagerService.changeImportanceIfRequirementCriticalityChanged(requirementVersionId, oldCriticality);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=RequirementVersion.class)
    public void rename(@Id long requirementVersionId, String newName) {
        RequirementVersion v = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        if (!v.isModifiable()) {
            throw new IllegalRequirementModificationException();
        }
        v.setName(newName.trim());
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'READ') or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public Page<RequirementVersion> findAllByRequirement(long requirementId, Pageable pageable) {
        Pageable pageable2 = pageable;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)pageable2);
        return this.requirementVersionDao.findAllByRequirementId(requirementId, pageable);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'READ') or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public List<RequirementVersion> findAllByRequirement(long requirementId) {
        PageRequest pageable = PageRequest.of((int)0, (int)Integer.MAX_VALUE, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"versionNumber"});
        return this.findAllByRequirement(requirementId, (Pageable)pageable).getContent();
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeCategory(long requirementVersionId, String categoryCode) {
        InfoListItem category = this.infoListItemService.findByCode(categoryCode);
        this.changeCategory((Long)requirementVersionId, category);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void changeCategory(long requirementVersionId, Long categoryId) {
        InfoListItem category = this.infoListItemService.findById(categoryId);
        this.changeCategory((Long)requirementVersionId, category);
    }

    private void changeCategory(Long requirementVersionId, InfoListItem category) {
        RequirementVersion version = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        if (!this.infoListItemService.isCategoryConsistent(version.getProject().getId(), category.getCode())) {
            throw new InconsistentInfoListItemException("requirementCategory", category.getCode());
        }
        version.setCategory(category);
    }

    @Override
    public Collection<Long> bulkUpdate(List<Long> requirementVersionIds, RequirementBulkUpdate update) {
        ArrayList<Long> failures = new ArrayList<Long>();
        List<Long> list = requirementVersionIds;
        RequirementVersionDao requirementVersionDao = this.requirementVersionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)requirementVersionDao, list);
        Object[] objectArray = new Object[]{this, requirementVersionDao, list, joinPoint};
        CustomRequirementVersionManagerServiceImpl$AjcClosure1 customRequirementVersionManagerServiceImpl$AjcClosure1 = new CustomRequirementVersionManagerServiceImpl$AjcClosure1(objectArray);
        List versions = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(customRequirementVersionManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        InfoListItem category = null;
        if (update.hasCategoryDefined()) {
            category = this.infoListItemService.findByCode(update.getCategory());
        }
        for (RequirementVersion rv : versions) {
            try {
                SecurityCheckableObject check = new SecurityCheckableObject(rv, "WRITE");
                PermissionsUtils.checkPermission(this.permService, check);
                RequirementVersion.PropertiesSetter ps = rv.getPropertySetter();
                if (update.hasCategoryDefined()) {
                    this.updateCategoryIfNeeded(rv, category, ps, update);
                }
                if (update.hasStatusDefined()) {
                    ps.setStatus(update.getStatus());
                }
                if (!update.hasCriticalityDefined()) continue;
                ps.setCriticality(update.getCriticality());
            }
            catch (Exception exception) {
                failures.add(rv.getId());
            }
        }
        return failures;
    }

    private void updateCategoryIfNeeded(RequirementVersion rv, InfoListItem category, RequirementVersion.PropertiesSetter ps, RequirementBulkUpdate update) {
        if (!this.infoListItemService.isCategoryConsistent(rv.getProject().getId(), update.getCategory())) {
            throw new InconsistentInfoListItemException("requirementCategory", update.getCategory());
        }
        ps.setCategory(category);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#versionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'READ') or hasRole('ROLE_ADMIN')")
    public Collection<Milestone> findAllMilestones(long versionId) {
        return this.milestoneManager.findMilestonesForRequirementVersion(versionId);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#versionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'READ') or hasRole('ROLE_ADMIN')")
    public Collection<Milestone> findAssociableMilestones(long versionId) {
        return this.milestoneManager.findAssociableMilestonesToRequirementVersion(versionId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#versionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void bindMilestones(long versionId, Collection<Long> milestoneIds) {
        this.milestoneManager.bindRequirementVersionToMilestones(versionId, milestoneIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#versionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void unbindMilestones(long versionId, Collection<Long> milestoneIds) {
        this.milestoneManager.unbindRequirementVersionFromMilestones(versionId, milestoneIds);
    }

    @Override
    public Collection<Milestone> findAssociableMilestonesForMassModif(List<Long> reqVersionIds) {
        List<Long> list = reqVersionIds;
        RequirementVersionDao requirementVersionDao = this.requirementVersionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)requirementVersionDao, list);
        Object[] objectArray = new Object[]{this, requirementVersionDao, list, joinPoint};
        CustomRequirementVersionManagerServiceImpl$AjcClosure3 customRequirementVersionManagerServiceImpl$AjcClosure3 = new CustomRequirementVersionManagerServiceImpl$AjcClosure3(objectArray);
        List versions = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(customRequirementVersionManagerServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112));
        List<Set<Milestone>> milestoneSetList = versions.stream().map(v -> v.getProject()).distinct().map(p -> this.retainModifiableMilestones(p.getMilestones())).toList();
        return this.intersect(milestoneSetList);
    }

    @Override
    public Collection<Long> findBindedMilestonesIdForMassModif(List<Long> reqVersionIds) {
        List<Long> list = reqVersionIds;
        RequirementVersionDao requirementVersionDao = this.requirementVersionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)requirementVersionDao, list);
        Object[] objectArray = new Object[]{this, requirementVersionDao, list, joinPoint};
        CustomRequirementVersionManagerServiceImpl$AjcClosure5 customRequirementVersionManagerServiceImpl$AjcClosure5 = new CustomRequirementVersionManagerServiceImpl$AjcClosure5(objectArray);
        List versions = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(customRequirementVersionManagerServiceImpl$AjcClosure5.linkClosureAndJoinPoint(4112));
        List<Set<Milestone>> milestoneSetList = versions.stream().map(version -> this.retainModifiableMilestones(version.getMilestones())).toList();
        Set<Milestone> milestones = this.intersect(milestoneSetList);
        return CollectionUtils.collect(milestones, (Transformer)new IdCollector());
    }

    private Set<Milestone> retainModifiableMilestones(Collection<Milestone> milestones) {
        return milestones.stream().filter(this::isModifiableMilestone).collect(Collectors.toSet());
    }

    private boolean isModifiableMilestone(Milestone milestone) {
        MilestoneStatus status = milestone.getStatus();
        return status != MilestoneStatus.LOCKED && status != MilestoneStatus.PLANNED;
    }

    private Set<Milestone> intersect(List<Set<Milestone>> milestoneSetList) {
        if (milestoneSetList.isEmpty()) {
            return new HashSet<Milestone>();
        }
        HashSet result = new HashSet(milestoneSetList.get(0));
        return milestoneSetList.stream().skip(1L).collect(() -> result, Collection::retainAll, CollectionUtils::retainAll);
    }

    @Override
    public boolean haveSamePerimeter(List<Long> reqVersionIds) {
        boolean allMatch = true;
        if (reqVersionIds.size() != 1) {
            List<Long> list = reqVersionIds;
            RequirementVersionDao requirementVersionDao = this.requirementVersionDao;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)requirementVersionDao, list);
            Object[] objectArray = new Object[]{this, requirementVersionDao, list, joinPoint};
            CustomRequirementVersionManagerServiceImpl$AjcClosure7 customRequirementVersionManagerServiceImpl$AjcClosure7 = new CustomRequirementVersionManagerServiceImpl$AjcClosure7(objectArray);
            List<HashSet> milestoneSetList = ((List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(customRequirementVersionManagerServiceImpl$AjcClosure7.linkClosureAndJoinPoint(4112))).stream().map(RequirementVersion::getProject).distinct().map(p -> new HashSet(p.getMilestones())).toList();
            Set sample = milestoneSetList.get(0);
            allMatch = milestoneSetList.stream().allMatch(set2 -> set2.size() == sample.size() && set2.containsAll(sample));
        }
        return allMatch;
    }

    @Override
    public boolean isOneMilestoneAlreadyBindToAnotherRequirementVersion(List<Long> reqVIds, List<Long> milestoneIds) {
        return this.milestoneDao.isOneMilestoneAlreadyBindToAnotherRequirementVersion(reqVIds, milestoneIds);
    }

    @Override
    public Long findLatestRequirementVersionByRequirementIdAndVerifyingTestCaseId(long requirementId, long tcId) {
        return this.reqVersionDao.findAllByRequirementIdAndVerifyingTestCaseId(requirementId, tcId);
    }

    @Override
    @Transactional(readOnly=true)
    public Long findReqVersionIdByRequirementAndVersionNumber(long requirementId, Integer versionNumber) {
        RequirementVersion requirementVersion = this.requirementVersionDao.findByRequirementIdAndVersionNumber(requirementId, versionNumber);
        if (requirementVersion != null) {
            return requirementVersion.getId();
        }
        return null;
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion' , 'READ') or hasRole('ROLE_ADMIN')")
    public RequirementVersion findByRequirementIdAndVersionNumber(long requirementVersionId, int versionNumber) {
        return this.requirementVersionDao.findByRequirementIdAndVersionNumber(requirementVersionId, versionNumber);
    }

    private RequirementVersion copyAttachmentsForNewVersions(Requirement req) {
        RequirementVersion newVersion = req.getCurrentVersion();
        for (Attachment attachment : newVersion.getAttachmentList().getAllAttachments()) {
            this.attachmentManagerService.copyContent(attachment);
        }
        return newVersion;
    }

    static {
        CustomRequirementVersionManagerServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findAllById_aroundBody0(CustomRequirementVersionManagerServiceImpl customRequirementVersionManagerServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    static final /* synthetic */ List findAllById_aroundBody2(CustomRequirementVersionManagerServiceImpl customRequirementVersionManagerServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    static final /* synthetic */ List findAllById_aroundBody4(CustomRequirementVersionManagerServiceImpl customRequirementVersionManagerServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    static final /* synthetic */ List findAllById_aroundBody6(CustomRequirementVersionManagerServiceImpl customRequirementVersionManagerServiceImpl, RequirementVersionDao requirementVersionDao, Iterable iterable, JoinPoint joinPoint) {
        return requirementVersionDao.findAllById(iterable);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CustomRequirementVersionManagerServiceImpl.java", CustomRequirementVersionManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "ids", "", "java.util.List"), 280);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "ids", "", "java.util.List"), 368);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "ids", "", "java.util.List"), 388);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllById", "org.squashtest.tm.service.internal.repository.RequirementVersionDao", "java.lang.Iterable", "ids", "", "java.util.List"), 436);
    }
}

