/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate.loaders.common;

import javax.persistence.TypedQuery;
import org.hibernate.jpa.QueryHints;

public class HintOption {
    public static final String FETCH_GRAPH = QueryHints.HINT_FETCHGRAPH;
    public static final HintOption CACHEABLE = new HintOption("org.hibernate.cacheable", true);
    public static final HintOption READ_ONLY = new HintOption("org.hibernate.readOnly", true);
    public static final HintOption NO_DISTINCT_IN_DB = new HintOption("hibernate.query.passDistinctThrough", false);
    private final String hint;
    private final Object value;

    public HintOption(String hint, Object value) {
        this.hint = hint;
        this.value = value;
    }

    public <T> TypedQuery<T> apply(TypedQuery<T> query) {
        return query.setHint(this.hint, this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HintOption that = (HintOption)o;
        return this.hint.equals(that.hint);
    }

    public int hashCode() {
        return this.hint.hashCode();
    }
}

