/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.commons.collections.ListUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.squashtest.tm.core.foundation.collection.DefaultSorting;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.SortOrder;
import org.squashtest.tm.core.foundation.collection.Sorting;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.NamedReferencePair;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.foundation.collection.PagingUtils;
import org.squashtest.tm.service.internal.foundation.collection.SortingUtils;
import org.squashtest.tm.service.internal.repository.CustomTestCaseDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetIdParameter;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;
import org.squashtest.tm.service.internal.repository.hibernate.SqLIdResultTransformer;

public class TestCaseDaoImpl
extends HibernateEntityDao<TestCase>
implements CustomTestCaseDao {
    private static final String TEST_CASE_ID_PARAM_NAME = "testCaseId";
    private static final String TEST_CASE_IDS_PARAM_NAME = "testCaseIds";
    private static final String TEST_CASES_IDS = "testCasesIds";
    private static final String UNCHECKED = "unchecked";
    private static final String PROJECT_ID = "projectId";
    private static final String FIND_ALL_DESCENDANT_TESTCASE_QUERY = "    select tc.tcln_id\n    from TCLN_RELATIONSHIP_CLOSURE tclnrc\n    inner join TEST_CASE tc on tclnrc.DESCENDANT_ID = tc.tcln_id\n    where tclnrc.ANCESTOR_ID in (:nodeIds)\n";
    private static final String FIND_ALL_CALLING_TEST_CASE_MAIN_HQL = "    select distinct TestCase\n    from TestCase as TestCase\n    left join TestCase.project as Project\n    join TestCase.steps as Steps\n    where Steps.calledTestCase.id = :\ntestCaseId";
    private static final String FIND_ALL_ASSOCIATED_TO_TA_SCRIPT = "    select tc.id\n    from TestCase tc\n    left join tc.automationRequest req\n    where tc.automatedTest is not null\n    and req.testCase is null\n    and tc.class = TestCase\n    and tc.project.id = :\nprojectId";
    private static final String FIND_TESTCASE_AND_DATASETS = "    select tc, ds\n    from TestCase tc\n    left join tc.datasets ds\n    where tc.id in :testCaseIds and (ds is null or ds.id in :datasetIds)\n";
    private static final String UPDATE_NATURE_IN_LIST = "UPDATE TestCase tc SET tc.nature = :nature where tc.id in (:testCaseIds)";
    private static final String UPDATE_TYPE_IN_LIST = "UPDATE TestCase tc SET tc.type = :type where tc.id in (:testCaseIds)";
    private static final String UPDATE_STATUS_IN_LIST = "UPDATE TestCase tc SET tc.status = :status where tc.id in (:testCaseIds)";
    private static final String UPDATE_AUTOMATABLE_IN_LIST = "    UPDATE TestCase tc\n    SET tc.automatable = :automatable\n    where tc.id in (:testCaseIds)\n    and exists (\n        select p.id\n        from Project p\n        where tc.project.id = p.id\n        and p.allowAutomationWorkflow\n        )\n";
    private static List<DefaultSorting> defaultVerifiedTcSorting = new LinkedList<DefaultSorting>();
    @Inject
    private DSLContext dsl;

    static {
        defaultVerifiedTcSorting.add(new DefaultSorting("TestCase.reference"));
        defaultVerifiedTcSorting.add(new DefaultSorting("TestCase.name"));
        ListUtils.unmodifiableList(defaultVerifiedTcSorting);
    }

    @Override
    public void safePersist(TestCase testCase) {
        if (testCase.getSteps().isEmpty()) {
            super.persist(testCase);
        } else {
            this.persistTestCaseAndSteps(testCase);
        }
    }

    @Override
    public void persistTestCaseAndSteps(TestCase testCase) {
        this.persistEntity(testCase);
    }

    @Override
    public TestCase findAndInit(Long testCaseId) {
        Session session = this.currentSession();
        TestCase tc = (TestCase)session.get(TestCase.class, (Serializable)testCaseId);
        if (tc == null) {
            return null;
        }
        Hibernate.initialize((Object)tc.getSteps());
        return tc;
    }

    @Override
    public List<TestStep> findTestSteps(long testCaseId) {
        TestCase tc = (TestCase)this.currentSession().getNamedQuery("TestCase.findInitialized").setParameter("tcId", (Object)testCaseId).uniqueResult();
        if (tc == null) {
            return Collections.emptyList();
        }
        return new ArrayList<TestStep>(tc.getSteps());
    }

    private SetQueryParametersCallback idParameter(long testCaseId) {
        return new SetIdParameter(TEST_CASE_ID_PARAM_NAME, testCaseId);
    }

    @Override
    public List<Long> findTestCasesHavingCaller(Collection<Long> testCasesIds) {
        org.hibernate.query.Query query = this.currentSession().getNamedQuery("testCase.findTestCasesHavingCaller");
        query.setParameterList(TEST_CASES_IDS, testCasesIds);
        return query.list();
    }

    @Override
    public List<Long> findAllTestCasesIdsCalledByTestCases(Collection<Long> testCasesIds) {
        org.hibernate.query.Query query = this.currentSession().getNamedQuery("testCase.findAllTestCasesIdsCalledByTestCases");
        query.setParameterList(TEST_CASES_IDS, testCasesIds);
        return query.list();
    }

    @Override
    public List<Long> findAllTestCasesIdsCallingTestCases(List<Long> testCasesIds) {
        if (testCasesIds.isEmpty()) {
            return Collections.emptyList();
        }
        org.hibernate.query.Query query = this.currentSession().getNamedQuery("testCase.findAllTestCasesIdsCallingTestCases");
        query.setParameterList(TEST_CASES_IDS, testCasesIds);
        return query.list();
    }

    @Override
    public List<TestCase> findAllCallingTestCases(long testCaseId, PagingAndSorting sorting) {
        String orderBy = "";
        if (sorting != null) {
            orderBy = " order by " + sorting.getSortedAttribute() + ' ' + sorting.getSortOrder().getCode();
        }
        org.hibernate.query.Query query = this.currentSession().createQuery(FIND_ALL_CALLING_TEST_CASE_MAIN_HQL + orderBy);
        query.setParameter(TEST_CASE_ID_PARAM_NAME, (Object)testCaseId);
        if (sorting != null) {
            query.setMaxResults(sorting.getPageSize());
            query.setFirstResult(sorting.getFirstItemIndex());
        }
        return query.list();
    }

    private List<NamedReference> findTestCaseDetails(Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        org.hibernate.query.Query q = this.currentSession().getNamedQuery("testCase.findTestCaseDetails");
        q.setParameterList(TEST_CASE_IDS_PARAM_NAME, ids, (Type)LongType.INSTANCE);
        return q.list();
    }

    @Override
    public List<NamedReferencePair> findTestCaseCallsUpstream(Collection<Long> testCaseIds) {
        List<NamedReferencePair> result = this.findTestCaseCallsDetails(testCaseIds, "testCase.findTestCasesHavingCallerDetails");
        HashSet<Long> remainingIds = new HashSet<Long>(testCaseIds);
        for (NamedReferencePair pair : result) {
            remainingIds.remove(pair.getCalled().getId());
        }
        List<NamedReference> noncalledReferences = this.findTestCaseDetails(remainingIds);
        for (NamedReference ref : noncalledReferences) {
            result.add(new NamedReferencePair(null, null, ref.getId(), ref.getName()));
        }
        return result;
    }

    @Override
    public List<NamedReferencePair> findTestCaseCallsDownstream(Collection<Long> testCaseIds) {
        List<NamedReferencePair> result = this.findTestCaseCallsDetails(testCaseIds, "testCase.findTestCasesHavingCallStepsDetails");
        HashSet<Long> remainingIds = new HashSet<Long>(testCaseIds);
        for (NamedReferencePair pair : result) {
            remainingIds.remove(pair.getCaller().getId());
        }
        List<NamedReference> noncalledReferences = this.findTestCaseDetails(remainingIds);
        for (NamedReference ref : noncalledReferences) {
            result.add(new NamedReferencePair(ref.getId(), ref.getName(), null, null));
        }
        return result;
    }

    private List<NamedReferencePair> findTestCaseCallsDetails(final Collection<Long> testCaseIds, String mainQuery) {
        if (testCaseIds.isEmpty()) {
            return Collections.emptyList();
        }
        SetQueryParametersCallback queryCallback = new SetQueryParametersCallback(){

            @Override
            public void setQueryParameters(org.hibernate.query.Query query) {
                query.setParameterList(TestCaseDaoImpl.TEST_CASE_IDS_PARAM_NAME, testCaseIds, (Type)new LongType());
                query.setReadOnly(true);
            }
        };
        return this.executeListNamedQuery(mainQuery, queryCallback);
    }

    @Override
    public List<Long> findCalledTestCaseOfCallSteps(List<Long> testStepsIds) {
        org.hibernate.query.Query query = this.currentSession().getNamedQuery("testCase.findCalledTestCaseOfCallSteps");
        query.setParameterList("testStepsIds", testStepsIds);
        return query.list();
    }

    @Override
    public List<TestCase> findAllByVerifiedRequirementVersion(long verifiedId, PagingAndSorting sorting) {
        List<Sorting> effectiveSortings = this.createEffectiveSorting((Sorting)sorting);
        org.hibernate.query.Query namedquery = this.currentSession().getNamedQuery("testCase.findVerifyingTestCases");
        String hql = namedquery.getQueryString();
        hql = SortingUtils.addOrders(hql, effectiveSortings);
        org.hibernate.query.Query q = this.currentSession().createQuery(hql);
        if (!sorting.shouldDisplayAll()) {
            PagingUtils.addPaging(q, (Paging)sorting);
        }
        q.setParameter("versionId", (Object)verifiedId);
        List raw = q.list();
        ArrayList<TestCase> res = new ArrayList<TestCase>(raw.size());
        for (Object[] tuple : raw) {
            res.add((TestCase)tuple[0]);
        }
        if ("endDate".equals(sorting.getSortedAttribute())) {
            Collections.sort(res, new Comparator<TestCase>(){

                @Override
                public int compare(TestCase tc1, TestCase tc2) {
                    return TestCaseDaoImpl.this.compareTcMilestoneDate(tc1, tc2);
                }
            });
            if (sorting.getSortOrder() == SortOrder.ASCENDING) {
                Collections.reverse(res);
            }
        }
        return res;
    }

    @Override
    public List<Long> findAllTestCaseAssociatedToTAScriptByProject(Long projectId) {
        org.hibernate.query.Query query = this.currentSession().createQuery(FIND_ALL_ASSOCIATED_TO_TA_SCRIPT);
        query.setParameter(PROJECT_ID, (Object)projectId);
        return query.getResultList();
    }

    @Override
    public Integer countScriptedTestCaseAssociatedToTAScriptByProject(Long projectId) {
        return (Integer)((Record1)this.dsl.selectCount().from((TableLike)Tables.SCRIPTED_TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).and(Tables.TEST_CASE.TA_TEST.isNotNull()).fetchOne()).value1();
    }

    @Override
    public List<TestCase> findTestCaseByAutomationRequestIds(List<Long> requestIds) {
        org.hibernate.query.Query query = (org.hibernate.query.Query)this.entityManager.createNamedQuery("testCase.findTestCaseByAutomationRequestIds");
        query.setParameter("requestIds", requestIds);
        return query.getResultList();
    }

    @Override
    public TestCase findTestCaseByUuid(String uuid) {
        Query query = this.entityManager.createNamedQuery("testCase.findTestCaseByUuid");
        query.setParameter("uuid", (Object)uuid);
        try {
            return (TestCase)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    @Override
    public List<String> retrieveFullNameByTestCaseLibraryNodeIds(List<Long> testCaseLibrayNodeIds, List<Long> projectIds) {
        Field fullName = DSL.when((Condition)Tables.TEST_CASE.REFERENCE.isNull().or(Tables.TEST_CASE.REFERENCE.eq((Object)"")), (Field)Tables.TEST_CASE_LIBRARY_NODE.NAME).otherwise(DSL.concat((Field[])new Field[]{Tables.TEST_CASE.REFERENCE, DSL.val((String)" - "), Tables.TEST_CASE_LIBRARY_NODE.NAME}));
        return this.dsl.select((SelectField)fullName).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(testCaseLibrayNodeIds)).and(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.in(projectIds)).orderBy((OrderField)fullName).fetch(fullName);
    }

    @Override
    public List<TestCase> findAllByIdsWithProject(List<Long> testCaseIds) {
        Query query = this.entityManager.createNamedQuery("testCase.findAllByIdsWithProject");
        query.setParameter("tcIds", testCaseIds);
        return query.getResultList();
    }

    @Override
    public void updateNature(List<Long> testCaseIds, InfoListItem nature) {
        Query query = this.entityManager.createQuery(UPDATE_NATURE_IN_LIST);
        query.setParameter("nature", (Object)nature);
        query.setParameter(TEST_CASE_IDS_PARAM_NAME, testCaseIds);
        query.executeUpdate();
    }

    @Override
    public void updateType(List<Long> testCaseIds, InfoListItem type) {
        Query query = this.entityManager.createQuery(UPDATE_TYPE_IN_LIST);
        query.setParameter("type", (Object)type);
        query.setParameter(TEST_CASE_IDS_PARAM_NAME, testCaseIds);
        query.executeUpdate();
    }

    @Override
    public void updateStatus(List<Long> testCaseIds, TestCaseStatus status) {
        Query query = this.entityManager.createQuery(UPDATE_STATUS_IN_LIST);
        query.setParameter("status", (Object)status);
        query.setParameter(TEST_CASE_IDS_PARAM_NAME, testCaseIds);
        query.executeUpdate();
    }

    @Override
    public void updateAutomatable(List<Long> testCaseIds, TestCaseAutomatable automatable) {
        Query query = this.entityManager.createQuery(UPDATE_AUTOMATABLE_IN_LIST);
        query.setParameter("automatable", (Object)automatable);
        query.setParameter(TEST_CASE_IDS_PARAM_NAME, testCaseIds);
        query.executeUpdate();
    }

    @Override
    public Set<Long> findAllTestCaseIdsCoveringRequirementVersions(Collection<Long> requirementVersionIds) {
        return new HashSet<Long>(this.dsl.selectDistinct((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.in(requirementVersionIds)).fetch().getValues((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID, Long.class));
    }

    private int compareTcMilestoneDate(TestCase tc1, TestCase tc2) {
        boolean isEmpty1 = tc1.getMilestones().isEmpty();
        boolean isEmpty2 = tc2.getMilestones().isEmpty();
        if (isEmpty1 && isEmpty2) {
            return 0;
        }
        if (isEmpty1) {
            return 1;
        }
        if (isEmpty2) {
            return -1;
        }
        return this.getMinDate(tc1).before(this.getMinDate(tc2)) ? (this.getMinDate(tc1).after(this.getMinDate(tc2)) ? 0 : 1) : -1;
    }

    private Date getMinDate(TestCase tc) {
        return Collections.min(tc.getMilestones(), new Comparator<Milestone>(){

            @Override
            public int compare(Milestone m1, Milestone m2) {
                return m1.getEndDate().before(m2.getEndDate()) ? -1 : 1;
            }
        }).getEndDate();
    }

    private List<Sorting> createEffectiveSorting(Sorting userSorting) {
        LinkedList<DefaultSorting> sortings = new LinkedList<DefaultSorting>(defaultVerifiedTcSorting);
        ListIterator iterator = sortings.listIterator();
        while (iterator.hasNext()) {
            Sorting defaultSorting = (Sorting)iterator.next();
            if (!defaultSorting.getSortedAttribute().equals(userSorting.getSortedAttribute())) continue;
            iterator.remove();
            break;
        }
        sortings.addFirst((DefaultSorting)userSorting);
        return sortings;
    }

    @Override
    public long countByVerifiedRequirementVersion(long verifiedId) {
        return (Long)this.executeEntityNamedQuery("testCase.countByVerifiedRequirementVersion", new SetVerifiedIdParameter(verifiedId));
    }

    @Override
    public List<TestCase> findUnsortedAllByVerifiedRequirementVersion(long requirementVersionId) {
        org.hibernate.query.Query query = this.currentSession().getNamedQuery("testCase.findUnsortedAllByVerifiedRequirementVersion");
        query.setParameter("requirementVersionId", (Object)requirementVersionId);
        return query.list();
    }

    @Override
    public List<Execution> findAllExecutionByTestCase(Long tcId) {
        SetQueryParametersCallback callback = this.idParameter(tcId);
        return this.executeListNamedQuery("testCase.findAllExecutions", callback);
    }

    @Override
    public List<Long> findAllTestCaseIdsByNodeIds(Collection<Long> nodeIds) {
        if (nodeIds.isEmpty()) {
            return Collections.emptyList();
        }
        NativeQuery query = this.currentSession().createNativeQuery(FIND_ALL_DESCENDANT_TESTCASE_QUERY);
        query.setParameterList("nodeIds", nodeIds, (Type)LongType.INSTANCE);
        query.setResultTransformer((ResultTransformer)new SqLIdResultTransformer());
        return query.list();
    }

    @Override
    public List<TestCase> findAllLinkedToIteration(List<Long> nodeIds) {
        return this.executeListNamedQuery("testCase.findAllLinkedToIteration", new SetIdsParameter(nodeIds));
    }

    @Override
    public Map<Long, TestCaseImportance> findAllTestCaseImportanceWithImportanceAuto(Collection<Long> testCaseIds) {
        HashMap<Long, TestCaseImportance> resultMap = new HashMap<Long, TestCaseImportance>();
        if (testCaseIds.isEmpty()) {
            return resultMap;
        }
        List resultList = this.executeListNamedQuery("testCase.findAllTCImpWithImpAuto", new SetIdsParameter(testCaseIds));
        for (Object[] resultEntry : resultList) {
            Long id = (Long)resultEntry[0];
            TestCaseImportance imp = (TestCaseImportance)resultEntry[1];
            resultMap.put(id, imp);
        }
        return resultMap;
    }

    @Override
    public List<Long> findAllEligibleTestCaseIds(List<Long> testCaseIds) {
        return this.dsl.selectDistinct((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.TEST_CASE.TCLN_ID.in(testCaseIds)).and(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).fetch((Field)Tables.TEST_CASE.TCLN_ID);
    }

    @Override
    public Map<Long, String> findAllAutomatableTestCasesByProjectId(long projectId) {
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID, (SelectField)Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER.REMOTE_STATUS).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.AUTOMATION_REQUEST.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER.AUTOMATION_REQUEST_ID)).where(Tables.AUTOMATION_REQUEST.PROJECT_ID.eq((Object)projectId)).and(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.isTrue()).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).fetchMap((Field)Tables.TEST_CASE.TCLN_ID, (Field)Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER.REMOTE_STATUS);
    }

    @Override
    public List<Long> findAllTCIdsEligibleForCopyByProjectIds(List<Long> targetTestCasesIds, List<Long> editableTCProjectIds) {
        return this.dsl.selectDistinct((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.TEST_CASE.TCLN_ID.in(targetTestCasesIds)).and(Tables.PROJECT.PROJECT_ID.in(editableTCProjectIds)).fetch((Field)Tables.TEST_CASE.TCLN_ID);
    }

    @Override
    public List<Long> findAllTCIdsForActiveMilestoneInList(Long activeMilestoneId, List<Long> testCaseIds) {
        return this.dsl.selectDistinct((SelectField)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID).from((TableLike)Tables.MILESTONE_TEST_CASE).where(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Object)activeMilestoneId)).and(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.in(testCaseIds)).fetch((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID);
    }

    @Override
    public Map<Long, String> findTestCaseExecutionModesByTestCaseIds(List<Long> testCaseIds) {
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID, (SelectField)Tables.TEST_CASE.EXECUTION_MODE).from((TableLike)Tables.TEST_CASE).where(Tables.TEST_CASE.TCLN_ID.in(testCaseIds)).fetchMap((Field)Tables.TEST_CASE.TCLN_ID, (Field)Tables.TEST_CASE.EXECUTION_MODE);
    }

    @Override
    public List<Long> filterTestCaseIdsWithLockedMilestone(List<Long> testCaseIds) {
        return this.dsl.select((SelectField)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID).from((TableLike)Tables.MILESTONE_TEST_CASE).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.in(testCaseIds).and(Tables.MILESTONE.STATUS.eq((Object)MilestoneStatus.LOCKED.name()))).union((Select)DSL.select((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.in(testCaseIds).and(Tables.MILESTONE.STATUS.eq((Object)MilestoneStatus.LOCKED.name())))).fetchInto(Long.class);
    }

    @Override
    public Map<TestCase, List<Dataset>> findTestCaseAndDatasets(Map<Long, List<Long>> datasetIdsByTestCaseId) {
        ArrayList<Long> testCaseIds = new ArrayList<Long>(datasetIdsByTestCaseId.keySet());
        List<Long> datasetIds = datasetIdsByTestCaseId.values().stream().flatMap(Collection::stream).distinct().toList();
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<Object[]> resultStream = this.getTestCaseAndDatasetsStream(testCaseIds, datasetIds);){
            return resultStream.collect(Collectors.groupingBy(objects -> (TestCase)objects[0], Collectors.mapping(objects -> (Dataset)objects[1], Collectors.toList())));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Stream<Object[]> getTestCaseAndDatasetsStream(List<Long> testCaseIds, List<Long> datasetIds) {
        return this.entityManager.createQuery(FIND_TESTCASE_AND_DATASETS, Object[].class).setParameter(TEST_CASE_IDS_PARAM_NAME, testCaseIds).setParameter("datasetIds", datasetIds).getResultStream();
    }

    @Override
    public List<String> filterExistingTestCaseUuids(Collection<String> uuids) {
        return this.dsl.select((SelectField)Tables.TEST_CASE.UUID).from((TableLike)Tables.TEST_CASE).where(Tables.TEST_CASE.UUID.in(uuids)).fetchInto(String.class);
    }

    @Override
    public Map<Long, List<Long>> findRecursiveCalledIdsByCallerId(Collection<Long> callerIds) {
        CommonTableExpression cte = DSL.name((String)"CALLED_TABLE").fields("source_id", "called_id").as((ResultQuery)DSL.select((SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from((TableLike)Tables.TEST_CASE_STEPS).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.in(callerIds)).union((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{"CALLED_TABLE", "source_id"}), Long.class), (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from(DSL.name((String)"CALLED_TABLE")).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(DSL.field((Name)DSL.name((String[])new String[]{"CALLED_TABLE", "source_id"})).eq((Object)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID))));
        return this.dsl.withRecursive(new CommonTableExpression[]{cte}).selectFrom((TableLike)cte).fetchGroups(DSL.field((String)"source_id", Long.class), DSL.field((String)"called_id", Long.class));
    }

    @Override
    public Map<Long, List<TestCase>> findRecursiveCallerTestCasesByCalledId(Collection<Long> calledIds) {
        Map<Long, List<Long>> callerIdsByCalledId = this.findRecursiveCallerByCalledId(calledIds);
        Set allCallerIds = callerIdsByCalledId.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (allCallerIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Map callerTestCaseById = this.entityManager.createQuery("SELECT DISTINCT tc FROM TestCase tc WHERE tc.id IN :ids", TestCase.class).setParameter("ids", allCallerIds).setHint("hibernate.query.passDistinctThrough", (Object)false).getResultList().stream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
        return callerIdsByCalledId.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(callerId -> Map.entry((Long)entry.getKey(), (TestCase)callerTestCaseById.get(callerId))).filter(e -> e.getValue() != null)).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private Map<Long, List<Long>> findRecursiveCallerByCalledId(Collection<Long> calledTestCaseIds) {
        CommonTableExpression cte = DSL.name((String)"CALLING_TABLE").fields("source_id", "caller_id").as((ResultQuery)DSL.select((SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID, (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID).from((TableLike)Tables.CALL_TEST_STEP).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).where(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.in(calledTestCaseIds)).union((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{"CALLING_TABLE", "source_id"}), Long.class), (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID).from(DSL.name((String)"CALLING_TABLE")).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(DSL.field((Name)DSL.name((String[])new String[]{"CALLING_TABLE", "caller_id"})).eq((Object)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID)).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID))));
        return this.dsl.withRecursive(new CommonTableExpression[]{cte}).selectFrom((TableLike)cte).fetchGroups(DSL.field((String)"source_id", Long.class), DSL.field((String)"caller_id", Long.class));
    }

    @Override
    public List<NamedReferencePair> findRecursiveTestCasesCalls(Collection<Long> sourceIds) {
        org.squashtest.tm.jooq.domain.tables.TestCaseLibraryNode calledTestCase = Tables.TEST_CASE_LIBRARY_NODE.as("CALLED_NODE");
        org.squashtest.tm.jooq.domain.tables.TestCaseLibraryNode callerTestCase = Tables.TEST_CASE_LIBRARY_NODE.as("CALLER_NODE");
        CommonTableExpression testCaseCalls = DSL.name((String)"testcase_calls").fields("CT_ID", "LINKED_CT_ID", "DIRECTION").as((ResultQuery)DSL.select((SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID, (SelectField)DSL.value((Boolean)Boolean.TRUE)).from((TableLike)Tables.TEST_CASE_STEPS).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).union((Select)DSL.select((SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID, (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (SelectField)DSL.value((Boolean)Boolean.FALSE)).from((TableLike)Tables.CALL_TEST_STEP).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID))));
        CommonTableExpression cte = DSL.name((String)"CALL_TREE").fields("TEST_CASE_ID", "LINKED_TEST_CASE_ID", "ROAD", "DIRECTION").as((ResultQuery)DSL.select((SelectField)testCaseCalls.field("CT_ID", Long.class), (SelectField)testCaseCalls.field("LINKED_CT_ID", Long.class), (SelectField)DSL.cast((Field)DSL.concat((Field[])new Field[]{DSL.value((String)" "), testCaseCalls.field("CT_ID", Long.class), DSL.value((String)" "), testCaseCalls.field("LINKED_CT_ID", Long.class)}), (DataType)SQLDataType.VARCHAR((int)1000)), (SelectField)testCaseCalls.field("DIRECTION", Boolean.class)).from((TableLike)testCaseCalls).where(testCaseCalls.field("CT_ID").in(sourceIds)).union((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{"CALL_TREE", "LINKED_TEST_CASE_ID"}), Long.class), (SelectField)testCaseCalls.field("LINKED_CT_ID", Long.class), (SelectField)DSL.cast((Field)DSL.concat((Field[])new Field[]{DSL.field((Name)DSL.name((String[])new String[]{"CALL_TREE", "ROAD"})), DSL.value((String)" "), testCaseCalls.field("LINKED_CT_ID")}), (DataType)SQLDataType.VARCHAR((int)1000)), (SelectField)testCaseCalls.field("DIRECTION", Boolean.class)).from(DSL.name((String)"CALL_TREE")).innerJoin((TableLike)testCaseCalls).on(DSL.field((Name)DSL.name((String[])new String[]{"CALL_TREE", "LINKED_TEST_CASE_ID"})).eq((Object)testCaseCalls.field("CT_ID")).and((Condition)DSL.field((Name)DSL.name((String[])new String[]{"CALL_TREE", "ROAD"})).notLike(DSL.concat((Field[])new Field[]{DSL.value((String)"% "), testCaseCalls.field("LINKED_CT_ID"), DSL.value((String)" %")}))))));
        SelectHavingStep callTreeTable = DSL.withRecursive((CommonTableExpression[])new CommonTableExpression[]{cte, testCaseCalls}).select((SelectField)DSL.when((Condition)DSL.field((String)"DIRECTION", Boolean.class).eq((Object)Boolean.TRUE), (Field)DSL.field((String)"TEST_CASE_ID", Long.class)).otherwise(DSL.field((String)"LINKED_TEST_CASE_ID", Long.class)).as("CALLER"), (SelectField)DSL.when((Condition)DSL.field((String)"DIRECTION", Boolean.class).eq((Object)Boolean.TRUE), (Field)DSL.field((String)"LINKED_TEST_CASE_ID", Long.class)).otherwise(DSL.field((String)"TEST_CASE_ID", Long.class)).as("CALLED")).from((TableLike)cte).groupBy(new GroupField[]{DSL.field((String)"CALLER"), DSL.field((String)"CALLED")});
        return this.dsl.select((SelectField)callTreeTable.field("CALLER", Long.class), (SelectField)callerTestCase.NAME.as("CALLER_NAME"), (SelectField)callTreeTable.field("CALLED", Long.class), (SelectField)calledTestCase.NAME.as("CALLED_NAME")).from((TableLike)callTreeTable).innerJoin((TableLike)callerTestCase).on(callTreeTable.field("CALLER", Long.class).eq((Field)callerTestCase.TCLN_ID)).innerJoin((TableLike)calledTestCase).on(callTreeTable.field("CALLED", Long.class).eq((Field)calledTestCase.TCLN_ID)).fetchStream().map(r -> new NamedReferencePair((Long)r.get("CALLER", Long.class), (String)r.get("CALLER_NAME", String.class), (Long)r.get("CALLED", Long.class), (String)r.get("CALLED_NAME", String.class))).toList();
    }

    @Override
    public Map<Long, String> findNameByTestCaseId(Collection<Long> testCaseIds) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream<Object[]> resultStream = this.getTestCasesNameByIdsStream(testCaseIds);){
            return resultStream.collect(Collectors.toMap(r -> (Long)r[0], r -> (String)r[1]));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Stream<Object[]> getTestCasesNameByIdsStream(Collection<Long> testCaseIds) {
        return this.entityManager.createQuery("select tc.id, tc.name from TestCase tc where tc.id in :ids", Object[].class).setParameter("ids", testCaseIds).getResultStream();
    }

    private static final class SetIdsParameter
    implements SetQueryParametersCallback {
        private Collection<Long> testCasesIds;

        private SetIdsParameter(Collection<Long> testCasesIds) {
            this.testCasesIds = testCasesIds;
        }

        @Override
        public void setQueryParameters(org.hibernate.query.Query query) {
            query.setParameterList(TestCaseDaoImpl.TEST_CASES_IDS, this.testCasesIds);
        }
    }

    private static final class SetVerifiedIdParameter
    implements SetQueryParametersCallback {
        private long verifiedId;

        private SetVerifiedIdParameter(long verifiedId) {
            this.verifiedId = verifiedId;
        }

        @Override
        public void setQueryParameters(org.hibernate.query.Query query) {
            query.setLong("verifiedId", this.verifiedId);
        }
    }
}

