/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jooq.DSLContext;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.template.TemplateConfigurablePlugin;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.project.TemplateConfigurablePluginBinding;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.TemplateConfigurablePluginBindingDto;
import org.squashtest.tm.service.internal.repository.TemplateConfigurablePluginBindingDao;

@Repository
public class TemplateConfigurablePluginBindingDaoImpl
implements TemplateConfigurablePluginBindingDao {
    @PersistenceContext
    private EntityManager entityManager;
    private final DSLContext dsl;

    public TemplateConfigurablePluginBindingDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public TemplateConfigurablePluginBinding createTemplateConfigurablePluginBinding(ProjectTemplate template, Project project, TemplateConfigurablePlugin plugin) {
        TemplateConfigurablePluginBinding binding = TemplateConfigurablePluginBinding.createBinding((ProjectTemplate)template, (Project)project, (TemplateConfigurablePlugin)plugin);
        this.entityManager.persist((Object)binding);
        return binding;
    }

    @Override
    public void removeAllForTemplate(long templateId) {
        this.entityManager.createQuery("delete from TemplateConfigurablePluginBinding binding where binding.projectTemplate.id = :templateId").setParameter("templateId", (Object)templateId).executeUpdate();
    }

    @Override
    public void removeAllForProject(long projectId) {
        this.entityManager.createQuery("delete from TemplateConfigurablePluginBinding binding where binding.project.id = :projectId").setParameter("projectId", (Object)projectId).executeUpdate();
    }

    @Override
    public TemplateConfigurablePluginBindingDto findOne(long templateId, long projectId, String pluginId) {
        return (TemplateConfigurablePluginBindingDto)this.dsl.selectFrom((TableLike)Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING).where(Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING.PLUGIN_ID.eq((Object)pluginId)).and(Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING.PROJECT_TEMPLATE_ID.eq((Object)templateId)).and(Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING.PROJECT_ID.eq((Object)projectId)).fetchOneInto(TemplateConfigurablePluginBindingDto.class);
    }

    @Override
    public List<TemplateConfigurablePluginBindingDto> findAll(long templateId, long projectId, List<String> pluginId) {
        return this.dsl.selectFrom((TableLike)Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING).where(Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING.PLUGIN_ID.in(pluginId)).and(Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING.PROJECT_TEMPLATE_ID.eq((Object)templateId)).and(Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING.PROJECT_ID.eq((Object)projectId)).fetchInto(TemplateConfigurablePluginBindingDto.class);
    }

    @Override
    public List<TemplateConfigurablePluginBindingDto> findAllByTemplateId(long templateId) {
        return this.dsl.selectFrom((TableLike)Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING).where(Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING.PROJECT_TEMPLATE_ID.eq((Object)templateId)).fetchInto(TemplateConfigurablePluginBindingDto.class);
    }

    @Override
    public List<TemplateConfigurablePluginBindingDto> findAllByTemplateIdAndPluginId(long templateId, String pluginId) {
        return this.dsl.selectFrom((TableLike)Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING).where(Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING.PLUGIN_ID.eq((Object)pluginId)).and(Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING.PROJECT_TEMPLATE_ID.eq((Object)templateId)).fetchInto(TemplateConfigurablePluginBindingDto.class);
    }

    @Override
    public boolean isProjectConfigurationBoundToTemplate(long projectId) {
        return (Integer)this.dsl.selectCount().from((TableLike)Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING).where(Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING.PROJECT_ID.eq((Object)projectId)).fetchOneInto(Integer.class) > 0;
    }

    @Override
    public boolean isProjectConfigurationBoundToTemplate(long projectId, String pluginId) {
        return (Integer)this.dsl.selectCount().from((TableLike)Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING).where(Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING.PLUGIN_ID.eq((Object)pluginId)).and(Tables.TEMPLATE_CONFIGURABLE_PLUGIN_BINDING.PROJECT_ID.eq((Object)projectId)).fetchOneInto(Integer.class) > 0;
    }
}

