/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.TagsValue;
import org.squashtest.tm.service.internal.repository.TagDao;

@Repository
public class TagDaoImpl
implements TagDao {
    @PersistenceContext
    private EntityManager em;

    @Override
    public List<TagsValue> getTagsValuesByTagLabelAndTestCaseIds(List<Long> testCasesIds, String tagLabel) {
        Query query = this.em.createQuery("SELECT tv FROM TagsValue tv JOIN FETCH tv.selectedOptions WHERE tv.boundEntityId IN (:testCasesIds) AND tv.boundEntityType = :entityType AND tv.binding.customField.inputType = :cufType AND tv.binding.customField.label = :tagLabel ");
        query.setParameter("testCasesIds", testCasesIds);
        query.setParameter("entityType", (Object)BindableEntity.TEST_CASE);
        query.setParameter("cufType", (Object)InputType.TAG);
        query.setParameter("tagLabel", (Object)tagLabel);
        return query.getResultList();
    }
}

