/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.springframework.data.jpa.repository.Modifying;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.Sorting;
import org.squashtest.tm.domain.requirement.RequirementVersionLink;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.service.internal.foundation.collection.PagingUtils;
import org.squashtest.tm.service.internal.foundation.collection.SortingUtils;
import org.squashtest.tm.service.internal.repository.CustomRequirementVersionLinkDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;

public class RequirementVersionLinkDaoImpl
extends HibernateEntityDao<RequirementVersionLink>
implements CustomRequirementVersionLinkDao {
    @Override
    public List<RequirementVersionLink> findAllByReqVersionId(long requirementVersionId, PagingAndSorting pagingAndSorting) {
        org.hibernate.query.Query baseQuery = this.currentSession().getNamedQuery("RequirementVersionLink.findAllByReqVersionId");
        String queryString = baseQuery.getQueryString();
        queryString = SortingUtils.addOrder(queryString, (Sorting)pagingAndSorting);
        org.hibernate.query.Query finalQuery = this.currentSession().createQuery(queryString);
        finalQuery.setParameter("requirementVersionId", (Object)requirementVersionId);
        PagingUtils.addPaging(finalQuery, (Paging)pagingAndSorting);
        List resultList = finalQuery.list();
        ArrayList<RequirementVersionLink> reqVerLinkList = new ArrayList<RequirementVersionLink>(resultList.size());
        for (Object[] object : resultList) {
            reqVerLinkList.add((RequirementVersionLink)object[0]);
        }
        return reqVerLinkList;
    }

    @Override
    public boolean linkAlreadyExists(Long reqVersionId, Long relatedReqVersionId) {
        Query existQuery = this.entityManager.createNamedQuery("RequirementVersionLink.linkAlreadyExists");
        existQuery.setParameter("reqVersionId", (Object)reqVersionId);
        existQuery.setParameter("relatedReqVersionId", (Object)relatedReqVersionId);
        return (Long)existQuery.getSingleResult() > 0L;
    }

    @Override
    public Map<Long, Long> countExistingLinkById(Long reqVersionId, List<Long> relatedReqVersionIds) {
        TypedQuery existQuery = this.entityManager.createNamedQuery("RequirementVersionLink.countExistingLinksById", Object[].class);
        existQuery.setParameter("reqVersionId", (Object)reqVersionId);
        existQuery.setParameter("relatedReqVersionIds", relatedReqVersionIds);
        List resultList = existQuery.getResultList();
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (Object[] object : resultList) {
            map.put((Long)object[0], (Long)object[1]);
        }
        return map;
    }

    @Override
    public RequirementVersionLink addLink(RequirementVersionLink requirementVersionLink) {
        this.entityManager.persist((Object)requirementVersionLink);
        RequirementVersionLink symmetricalRequirementVersionLink = requirementVersionLink.createSymmetricalRequirementVersionLink();
        this.entityManager.persist((Object)symmetricalRequirementVersionLink);
        return requirementVersionLink;
    }

    @Override
    public void addLinks(List<RequirementVersionLink> requirementVersionLinks) {
        this.persist(requirementVersionLinks);
        ArrayList<RequirementVersionLink> symmetricalLinks = new ArrayList<RequirementVersionLink>();
        for (RequirementVersionLink link : requirementVersionLinks) {
            symmetricalLinks.add(link.createSymmetricalRequirementVersionLink());
        }
        this.persist(symmetricalLinks);
    }

    @Override
    @Modifying
    public void setLinksTypeToDefault(RequirementVersionLinkType linkTypeToReplace, RequirementVersionLinkType defaultLinkType) {
        Query updateQuery = this.entityManager.createNamedQuery("RequirementVersionLink.setLinksTypeToDefault");
        updateQuery.setParameter("formerLinkType", (Object)linkTypeToReplace);
        updateQuery.setParameter("defaultLinkType", (Object)defaultLinkType);
        updateQuery.executeUpdate();
    }
}

