/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.service.internal.repository.TestAutomationProjectDao;

@Repository
public class HibernateTestAutomationProjectDao
implements TestAutomationProjectDao {
    @PersistenceContext
    private EntityManager em;

    @Override
    public void persist(TestAutomationProject newProject) {
        this.em.persist((Object)newProject);
    }

    @Override
    public TestAutomationProject findById(Long id) {
        return (TestAutomationProject)this.em.getReference(TestAutomationProject.class, (Object)id);
    }

    @Override
    public Collection<Long> findAllByTMProject(long tmProjectId) {
        Query query = this.em.createNamedQuery("testAutomationProject.findAllByTMPRoject");
        query.setParameter("tmProjectId", (Object)tmProjectId);
        return query.getResultList();
    }

    @Override
    public boolean haveExecutedTestsByIds(Collection<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return false;
        }
        Query q = this.em.createNamedQuery("testAutomationProject.haveExecutedTestsByIds");
        q.setParameter("projectIds", projectIds);
        Long count = (Long)q.getSingleResult();
        return count > 0L;
    }

    @Override
    public void deleteProjectsByIds(Collection<Long> projectIds) {
        if (!projectIds.isEmpty()) {
            this.dereferenceAutomatedExecutionExtender(projectIds);
            this.dereferenceTestCases(projectIds);
            this.em.flush();
            this.deleteAutomatedTests(projectIds);
            this.deleteTestAutomationProjects(projectIds);
            this.em.flush();
        }
    }

    @Override
    public void deleteAllHostedProjects(long serverId) {
        List<Long> hostedProjectIds = this.findHostedProjectIds(serverId);
        this.deleteProjectsByIds(hostedProjectIds);
    }

    @Override
    public List<TestAutomationProject> findAllHostedProjects(long serverId) {
        Query query = this.em.createNamedQuery("testAutomationServer.findAllHostedProjects");
        query.setParameter("serverId", (Object)serverId);
        return query.getResultList();
    }

    @Override
    public List<Long> findHostedProjectIds(long serverId) {
        Query q = this.em.createNamedQuery("testAutomationProject.findHostedProjectIds");
        q.setParameter("serverId", (Object)serverId);
        return q.getResultList();
    }

    private void dereferenceAutomatedExecutionExtender(Collection<Long> projectIds) {
        Query q = this.em.createNamedQuery("testAutomationProject.dereferenceAutomatedExecutionExtender");
        q.setParameter("projectIds", projectIds);
        q.executeUpdate();
    }

    private void dereferenceTestCases(Collection<Long> projectIds) {
        Query q = this.em.createNamedQuery("testAutomationProject.dereferenceTestCases");
        q.setParameter("projectIds", projectIds);
        q.executeUpdate();
    }

    private void deleteAutomatedTests(Collection<Long> projectIds) {
        Query q = this.em.createNamedQuery("testAutomationProject.deleteAutomatedTests");
        q.setParameter("projectIds", projectIds);
        q.executeUpdate();
    }

    private void deleteTestAutomationProjects(Collection<Long> projectIds) {
        Query q = this.em.createNamedQuery("testAutomationProject.delete");
        q.setParameter("projectIds", projectIds);
        q.executeUpdate();
    }
}

