/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.squashtest.tm.service.internal.repository.GenericDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;

public abstract class HibernateDao<ENTITY_TYPE>
implements GenericDao<ENTITY_TYPE> {
    private static final String UNCHECKED = "unchecked";
    protected final Class<ENTITY_TYPE> entityType;
    @PersistenceContext
    protected EntityManager entityManager;

    protected HibernateDao() {
        ParameterizedType type = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.entityType = (Class)type.getActualTypeArguments()[0];
    }

    @Deprecated
    protected Session currentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public void persist(List<ENTITY_TYPE> transientEntities) {
        for (ENTITY_TYPE transientEntity : transientEntities) {
            this.persist(transientEntity);
        }
    }

    @Override
    public void persist(ENTITY_TYPE transientEntity) {
        this.persistEntity(transientEntity);
    }

    @Override
    public void remove(ENTITY_TYPE entity) {
        this.removeEntity(entity);
    }

    @Override
    public void flush() {
        this.entityManager.flush();
    }

    protected ENTITY_TYPE getEntity(long objectId) {
        return (ENTITY_TYPE)this.entityManager.find(this.entityType, (Object)objectId);
    }

    protected void persistEntity(Object entity) {
        this.entityManager.persist(entity);
    }

    @Deprecated
    protected <R> List<R> executeListNamedQuery(String queryName, SetQueryParametersCallback setParams) {
        Session session = this.currentSession();
        Query q = session.getNamedQuery(queryName);
        setParams.setQueryParameters(q);
        return q.list();
    }

    protected <R> R executeEntityNamedQuery(String queryName, String paramName, Object paramValue) {
        return (R)this.entityManager.createNamedQuery(queryName).setParameter(paramName, paramValue).getSingleResult();
    }

    protected <R> R executeEntityNamedQuery(String queryName, SetQueryParametersCallback setParams) {
        Query q = this.currentSession().getNamedQuery(queryName);
        setParams.setQueryParameters(q);
        return (R)q.uniqueResult();
    }

    protected <R> R executeEntityNamedQuery(String queryName) {
        return (R)this.entityManager.createNamedQuery(queryName).getSingleResult();
    }

    protected void removeEntity(ENTITY_TYPE entity) {
        this.entityManager.remove(entity);
    }

    @Override
    public void removeAll(List<ENTITY_TYPE> entities) {
        for (ENTITY_TYPE entity : entities) {
            this.removeEntity(entity);
        }
    }
}

