/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.service.internal.repository.CampaignDeletionDao;
import org.squashtest.tm.service.internal.repository.hibernate.AbstractHibernateDeletionDao;

@Repository
public class HibernateCampaignDeletionDao
extends AbstractHibernateDeletionDao
implements CampaignDeletionDao {
    private static final String CAMPAIGN_IDS = "campaignIds";

    @Override
    public void removeEntities(List<Long> entityIds) {
        if (!entityIds.isEmpty()) {
            for (Long entityId : entityIds) {
                CampaignLibraryNode node = (CampaignLibraryNode)this.entityManager().getReference(CampaignLibraryNode.class, (Object)entityId);
                this.removeEntityFromParentLibraryIfExists(entityId, node);
                this.removeEntityFromParentFolderIfExists(entityId, node);
                if (node == null) continue;
                this.entityManager().remove((Object)node);
                this.entityManager().flush();
            }
        }
    }

    private void removeEntityFromParentLibraryIfExists(Long entityId, CampaignLibraryNode node) {
        Query query = this.getSession().getNamedQuery("campaignLibraryNode.findParentLibraryIfExists");
        query.setParameter("libraryNodeId", (Object)entityId);
        CampaignLibrary library = (CampaignLibrary)query.uniqueResult();
        if (library != null) {
            for (CampaignLibraryNode tcln : library.getContent()) {
                if (!tcln.getId().equals(node.getId())) continue;
                library.removeContent(tcln);
                break;
            }
        }
    }

    private void removeEntityFromParentFolderIfExists(Long entityId, CampaignLibraryNode node) {
        Query query = this.getSession().getNamedQuery("campaignLibraryNode.findParentFolderIfExists");
        query.setParameter("libraryNodeId", (Object)entityId);
        CampaignFolder folder = (CampaignFolder)query.uniqueResult();
        if (folder != null) {
            for (CampaignLibraryNode tcln : folder.getContent()) {
                if (!tcln.getId().equals(node.getId())) continue;
                folder.removeContent(tcln);
                break;
            }
        }
    }

    @Override
    public List<Long>[] separateFolderFromCampaignIds(List<Long> originalIds) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        ArrayList<Long> campaignIds = new ArrayList<Long>();
        List filtredFolderIds = this.executeSelectSQLQuery("select folder.cln_id from CAMPAIGN_FOLDER folder where folder.cln_id in (:campaignIds)", CAMPAIGN_IDS, originalIds);
        for (Long oId : originalIds) {
            if (filtredFolderIds.contains(BigInteger.valueOf(oId))) {
                folderIds.add(oId);
                continue;
            }
            campaignIds.add(oId);
        }
        List[] result = new List[]{folderIds, campaignIds};
        return result;
    }

    @Override
    public void unbindFromMilestone(List<Long> campaignIds, Long milestoneId) {
        if (!campaignIds.isEmpty()) {
            NativeQuery query = this.getSession().createNativeQuery("delete from MILESTONE_CAMPAIGN where MILESTONE_ID = :milestoneId and CAMPAIGN_ID in (:campaignIds)");
            query.setParameterList(CAMPAIGN_IDS, campaignIds, (Type)LongType.INSTANCE);
            query.setParameter("milestoneId", (Object)milestoneId);
            query.executeUpdate();
        }
    }

    @Override
    public List<Long> findCampaignsWhichMilestonesForbidsDeletion(List<Long> originalId) {
        if (!originalId.isEmpty()) {
            Object[] blockingStatuses = new MilestoneStatus[MilestoneStatus.MILESTONE_BLOCKING_STATUSES.size()];
            MilestoneStatus.MILESTONE_BLOCKING_STATUSES.toArray(blockingStatuses);
            Query query = this.getSession().getNamedQuery("campaign.findCampaignsWhichMilestonesForbidsDeletion");
            query.setParameterList(CAMPAIGN_IDS, originalId, (Type)LongType.INSTANCE);
            query.setParameterList("lockedStatuses", blockingStatuses);
            return query.list();
        }
        return new ArrayList<Long>();
    }

    @Override
    public List<Long> findRemainingCampaignIds(List<Long> originalIds) {
        List rawids = this.executeSelectSQLQuery("select CLN_ID from CAMPAIGN where CLN_ID in (:allCampaignIds)", "allCampaignIds", originalIds);
        ArrayList<Long> cIds = new ArrayList<Long>(rawids.size());
        for (BigInteger rid : rawids) {
            cIds.add(rid.longValue());
        }
        return cIds;
    }
}

