/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.Record5;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.testcase.CalledTestCaseDto;
import org.squashtest.tm.service.internal.display.dto.testcase.TestCaseDto;
import org.squashtest.tm.service.internal.display.dto.testcase.TestCaseFolderDto;
import org.squashtest.tm.service.internal.display.dto.testcase.TestCaseLibraryDto;
import org.squashtest.tm.service.internal.repository.display.TestCaseDisplayDao;

@Repository
public class TestCaseDisplayDaoImpl
implements TestCaseDisplayDao {
    private final DSLContext dsl;

    public TestCaseDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public TestCaseDto getTestCaseDtoById(Long testCaseId) {
        return (TestCaseDto)this.dsl.select(new SelectFieldOrAsterisk[]{Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("ID"), Tables.TEST_CASE_LIBRARY_NODE.NAME, Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION, Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, Tables.TEST_CASE_LIBRARY_NODE.ATTACHMENT_LIST_ID, Tables.TEST_CASE_LIBRARY_NODE.CREATED_BY, Tables.TEST_CASE_LIBRARY_NODE.CREATED_ON, Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY, Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_ON, Tables.TEST_CASE.REFERENCE, Tables.TEST_CASE.IMPORTANCE, Tables.TEST_CASE.TC_STATUS.as("STATUS"), Tables.TEST_CASE.AUTOMATABLE, Tables.TEST_CASE.IMPORTANCE_AUTO, Tables.TEST_CASE.PREREQUISITE, Tables.TEST_CASE.TC_NATURE.as("NATURE"), Tables.TEST_CASE.TC_TYPE.as("TYPE"), Tables.TEST_CASE.UUID, Tables.TEST_CASE.EXECUTION_MODE, Tables.SCRIPTED_TEST_CASE.TCLN_ID.as("SCRIPTED_TEST_CASE_ID"), Tables.SCRIPTED_TEST_CASE.SCRIPT, Tables.KEYWORD_TEST_CASE.TCLN_ID.as("KEYWORD_TEST_CASE_ID"), Tables.EXPLORATORY_TEST_CASE.TCLN_ID.as("EXPLORATORY_TEST_CASE_ID"), Tables.EXPLORATORY_TEST_CASE.CHARTER, Tables.EXPLORATORY_TEST_CASE.SESSION_DURATION, Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE, Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY, Tables.TEST_CASE.SCM_REPOSITORY_ID, Tables.TEST_CASE.DRAFTED_BY_AI}).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.KEYWORD_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.EXPLORATORY_TEST_CASE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Object)testCaseId)).fetchOne().into(TestCaseDto.class);
    }

    @Override
    public TestCaseLibraryDto getTestCaseLibraryDtoById(Long id) {
        return (TestCaseLibraryDto)((Record5)this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY.TCL_ID.as("ID"), (SelectField)Tables.TEST_CASE_LIBRARY.ATTACHMENT_LIST_ID, (SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.DESCRIPTION, (SelectField)Tables.PROJECT.NAME).from((TableLike)Tables.TEST_CASE_LIBRARY).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.TCL_ID.eq((Field)Tables.TEST_CASE_LIBRARY.TCL_ID)).where(Tables.TEST_CASE_LIBRARY.TCL_ID.eq((Object)id)).fetchOne()).into(TestCaseLibraryDto.class);
    }

    @Override
    public List<CalledTestCaseDto> getCallingTestCaseById(Long id) {
        return this.dsl.select((SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)Tables.TEST_CASE.REFERENCE, (SelectField)Tables.TEST_CASE.TCLN_ID.as("ID"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)Tables.DATASET.NAME.as("DATASET_NAME"), (SelectField)Tables.TEST_CASE_STEPS.STEP_ORDER, (SelectField)Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES.as("HAS_DELEGATED_PARAMETER")).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.CALL_TEST_STEP.CALLED_DATASET.eq((Field)Tables.DATASET.DATASET_ID)).where(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.eq((Object)id)).fetchInto(CalledTestCaseDto.class);
    }

    @Override
    public TestCaseFolderDto getTestCaseFolderDtoById(long testCaseFolderId) {
        return (TestCaseFolderDto)((Record5)this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("ID"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.ATTACHMENT_LIST_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Object)testCaseFolderId)).fetchOne()).into(TestCaseFolderDto.class);
    }

    @Override
    public Long getTestCaseIdByTestStepId(Long testStepId) {
        return (Long)this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_STEPS.STEP_ID.eq((Object)testStepId)).fetchOne((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID);
    }

    @Override
    public String getLastExecutionStatus(Long testCaseId, String executionMode) {
        Result resultStatus = TestCaseExecutionMode.EXPLORATORY.name().equals(executionMode) ? this.dsl.select((SelectField)Tables.ITERATION_TEST_PLAN_ITEM.EXECUTION_STATUS).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).leftJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID)).where(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Object)testCaseId)).and(Tables.ITERATION_TEST_PLAN_ITEM.LAST_MODIFIED_ON.eq((Select)DSL.select((SelectField)DSL.max((Field)Tables.ITERATION_TEST_PLAN_ITEM.LAST_MODIFIED_ON)).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).where(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Object)testCaseId)))).fetch() : this.dsl.select((SelectField)Tables.ITERATION_TEST_PLAN_ITEM.EXECUTION_STATUS).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).where(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Object)testCaseId)).and(Tables.ITERATION_TEST_PLAN_ITEM.LAST_EXECUTED_ON.eq((Select)DSL.select((SelectField)DSL.max((Field)Tables.ITERATION_TEST_PLAN_ITEM.LAST_EXECUTED_ON)).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).where(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Object)testCaseId)))).fetch();
        if (resultStatus.isEmpty()) {
            return "";
        }
        return (String)((Record1)resultStatus.get(0)).value1();
    }
}

