/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record15;
import org.jooq.SelectField;
import org.jooq.SelectSelectStep;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.TestAutomationServerDto;
import org.squashtest.tm.service.internal.repository.display.TestAutomationServerDisplayDao;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;

@Repository
public class TestAutomationServerDisplayDaoImpl
implements TestAutomationServerDisplayDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationServerDisplayDaoImpl.class);
    @Autowired(required=false)
    private final Collection<TestAutomationConnector> connectors = Collections.emptyList();
    @Inject
    private DSLContext dslContext;

    @Override
    public List<TestAutomationServerDto> findAll() {
        List servers = this.getSelectClause().from((TableLike)Tables.TEST_AUTOMATION_SERVER).innerJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.THIRD_PARTY_SERVER.SERVER_ID.eq((Field)Tables.TEST_AUTOMATION_SERVER.SERVER_ID)).fetchInto(TestAutomationServerDto.class);
        servers.forEach(serverDto -> serverDto.setSupportsAutomatedExecutionEnvironments(this.supportsAutomatedExecutionEnvironments(serverDto.getKind())));
        return servers;
    }

    @Override
    public Set<TestAutomationServerKind> findAllAvailableKinds() {
        return this.connectors.stream().map(TestAutomationConnector::getConnectorKind).collect(Collectors.toSet());
    }

    @Override
    public TestAutomationServerDto getTestAutomationServerById(long testAutomationServerId) {
        TestAutomationServerDto dto = (TestAutomationServerDto)((Record15)this.getSelectClause().from((TableLike)Tables.TEST_AUTOMATION_SERVER).innerJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.THIRD_PARTY_SERVER.SERVER_ID.eq((Field)Tables.TEST_AUTOMATION_SERVER.SERVER_ID)).where(Tables.TEST_AUTOMATION_SERVER.SERVER_ID.eq((Object)testAutomationServerId)).fetchOne()).into(TestAutomationServerDto.class);
        dto.setSupportsAutomatedExecutionEnvironments(this.supportsAutomatedExecutionEnvironments(dto.getKind()));
        return dto;
    }

    private SelectSelectStep<Record15<Long, String, String, String, String, String, Boolean, String, Timestamp, String, Timestamp, String, String, String, String>> getSelectClause() {
        return this.dslContext.select((SelectField)Tables.TEST_AUTOMATION_SERVER.SERVER_ID.as("ID"), (SelectField)Tables.THIRD_PARTY_SERVER.NAME, (SelectField)Tables.THIRD_PARTY_SERVER.URL.as("BASE_URL"), (SelectField)Tables.THIRD_PARTY_SERVER.AUTH_PROTOCOL, (SelectField)Tables.TEST_AUTOMATION_SERVER.KIND, (SelectField)Tables.THIRD_PARTY_SERVER.DESCRIPTION, (SelectField)Tables.TEST_AUTOMATION_SERVER.MANUAL_SLAVE_SELECTION, (SelectField)Tables.THIRD_PARTY_SERVER.CREATED_BY, (SelectField)Tables.THIRD_PARTY_SERVER.CREATED_ON, (SelectField)Tables.THIRD_PARTY_SERVER.LAST_MODIFIED_BY, (SelectField)Tables.THIRD_PARTY_SERVER.LAST_MODIFIED_ON, (SelectField)Tables.TEST_AUTOMATION_SERVER.OBSERVER_URL, (SelectField)Tables.TEST_AUTOMATION_SERVER.EVENT_BUS_URL, (SelectField)Tables.TEST_AUTOMATION_SERVER.ADDITIONAL_CONFIGURATION, (SelectField)Tables.TEST_AUTOMATION_SERVER.KILLSWITCH_URL);
    }

    @Override
    public boolean supportsAutomatedExecutionEnvironments(String kind) {
        try {
            return this.supportsAutomatedExecutionEnvironments(TestAutomationServerKind.valueOf((String)kind));
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            LOGGER.warn("No TestAutomationServerKind matches '{}'.", new Object[]{kind, ex});
            return false;
        }
    }

    private boolean supportsAutomatedExecutionEnvironments(TestAutomationServerKind connectorKind) {
        Optional<TestAutomationConnector> matchingConnector = this.connectors.stream().filter(con -> con.getConnectorKind().equals((Object)connectorKind)).findAny();
        if (matchingConnector.isPresent()) {
            return matchingConnector.get().supportsAutomatedExecutionEnvironments();
        }
        LOGGER.trace("No connector was found with kind {}.", new Object[]{connectorKind});
        return false;
    }
}

