/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import com.google.common.collect.ListMultimap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.AttachmentListDto;
import org.squashtest.tm.service.internal.display.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.display.dto.DenormalizedCustomFieldValueDto;
import org.squashtest.tm.service.internal.display.dto.execution.ExecutionStepView;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.DenormalizedCustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.ExecutionStepDisplayDao;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

@Repository
public class ExecutionStepDisplayDaoImpl
implements ExecutionStepDisplayDao {
    private DSLContext jooq;
    private AttachmentDisplayDao attachmentDisplayDao;
    private DenormalizedCustomFieldValueDisplayDao denormalizedCustomFieldValueDisplayDao;
    private CustomFieldValueDisplayDao customFieldValueDisplayDao;

    public ExecutionStepDisplayDaoImpl(DSLContext jooq, AttachmentDisplayDao attachmentDisplayDao, DenormalizedCustomFieldValueDisplayDao denormalizedCustomFieldValueDisplayDao, CustomFieldValueDisplayDao customFieldValueDisplayDao) {
        this.jooq = jooq;
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.denormalizedCustomFieldValueDisplayDao = denormalizedCustomFieldValueDisplayDao;
        this.customFieldValueDisplayDao = customFieldValueDisplayDao;
    }

    @Override
    public List<ExecutionStepView> findByExecutionId(Long executionId) {
        List<ExecutionStepView> executionStepViews = this.jooq.select((SelectField)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, (SelectField)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER, (SelectField)Tables.EXECUTION_STEP.ATTACHMENT_LIST_ID, (SelectField)Tables.EXECUTION_STEP.EXECUTION_STATUS, (SelectField)Tables.EXECUTION_STEP.ACTION, (SelectField)Tables.EXECUTION_STEP.EXPECTED_RESULT, (SelectField)Tables.EXECUTION_STEP.COMMENT, (SelectField)Tables.EXECUTION_STEP.LAST_EXECUTED_ON, (SelectField)Tables.EXECUTION_STEP.LAST_EXECUTED_BY).from((TableLike)Tables.EXECUTION_STEP).naturalJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).where(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Object)executionId)).orderBy((OrderField)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER.asc()).stream().map(record -> {
            ExecutionStepView executionStepView = new ExecutionStepView();
            executionStepView.setId((Long)record.get((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID));
            executionStepView.setOrder((Integer)record.get((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER));
            executionStepView.setExecutionStatus((String)record.get((Field)Tables.EXECUTION_STEP.EXECUTION_STATUS));
            executionStepView.setAction(HTMLCleanupUtils.cleanHtml((String)record.get((Field)Tables.EXECUTION_STEP.ACTION)));
            executionStepView.setExpectedResult(HTMLCleanupUtils.cleanHtml((String)record.get((Field)Tables.EXECUTION_STEP.EXPECTED_RESULT)));
            executionStepView.setComment(HTMLCleanupUtils.cleanHtml((String)record.get((Field)Tables.EXECUTION_STEP.COMMENT)));
            executionStepView.getAttachmentList().setId((Long)record.get((Field)Tables.EXECUTION_STEP.ATTACHMENT_LIST_ID));
            executionStepView.setLastExecutedOn((Date)record.get((Field)Tables.EXECUTION_STEP.LAST_EXECUTED_ON));
            executionStepView.setLastExecutedBy((String)record.get((Field)Tables.EXECUTION_STEP.LAST_EXECUTED_BY));
            return executionStepView;
        }).toList();
        this.addAttachments(executionStepViews);
        this.addCustomFieldValues(executionStepViews);
        this.addDenormalizedCustomFieldValues(executionStepViews);
        return executionStepViews;
    }

    private void addCustomFieldValues(List<ExecutionStepView> executionStepViews) {
        List<Long> executionStepIds = executionStepViews.stream().map(ExecutionStepView::getId).toList();
        ListMultimap<Long, CustomFieldValueDto> customFieldValues = this.customFieldValueDisplayDao.findCustomFieldValues(BindableEntity.EXECUTION_STEP, executionStepIds);
        executionStepViews.forEach(executionStepView -> executionStepView.setCustomFieldValues(customFieldValues.get((Object)executionStepView.getId())));
    }

    private void addDenormalizedCustomFieldValues(List<ExecutionStepView> executionStepViews) {
        List<Long> executionStepIds = executionStepViews.stream().map(ExecutionStepView::getId).toList();
        ListMultimap<Long, DenormalizedCustomFieldValueDto> denormalizedCustomFieldValues = this.denormalizedCustomFieldValueDisplayDao.findDenormalizedCustomFieldValues(DenormalizedFieldHolderType.EXECUTION_STEP, executionStepIds);
        executionStepViews.forEach(executionStepView -> executionStepView.setDenormalizedCustomFieldValues(denormalizedCustomFieldValues.get((Object)executionStepView.getId())));
    }

    private void addAttachments(List<ExecutionStepView> executionStepViews) {
        Set<Long> attachmentListIds = executionStepViews.stream().map(ExecutionStepView::getAttachmentList).map(AttachmentListDto::getId).collect(Collectors.toSet());
        Map attachmentMap = this.attachmentDisplayDao.findAttachmentListByIds(attachmentListIds).stream().collect(Collectors.toMap(AttachmentListDto::getId, Function.identity()));
        executionStepViews.forEach(executionStepView -> {
            AttachmentListDto attachmentListDto = (AttachmentListDto)attachmentMap.get(executionStepView.getAttachmentList().getId());
            executionStepView.setAttachmentList(attachmentListDto);
        });
    }
}

