/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.Collection;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.service.internal.repository.CustomMilestoneDao;

public interface MilestoneDao
extends JpaRepository<Milestone, Long>,
CustomMilestoneDao {
    @Query
    public Collection<Milestone> findAssociableMilestonesForUser(@Param(value="userId") long var1);

    @Query
    public Collection<Milestone> findMilestonesForRequirementVersion(@Param(value="versionId") long var1);

    @Query
    public Collection<Milestone> findMilestonesForCampaign(@Param(value="campaignId") long var1);

    @Query
    public Collection<Milestone> findMilestonesForIteration(@Param(value="iterationId") long var1);

    @Query
    public Collection<Milestone> findMilestonesForTestSuite(@Param(value="suiteId") long var1);

    @Query
    public Collection<Campaign> findCampaignsForMilestone(@Param(value="milestoneId") long var1);

    @Query
    public Milestone findByLabel(@Param(value="label") String var1);

    @Query(name="Milestone.findByLabel")
    public Milestone findByName(@Param(value="label") String var1);

    @Query
    public long countMilestonesForUsers(@Param(value="userIds") List<Long> var1);

    @Query(value="SELECT m FROM Milestone m WHERE m.id IN :milestoneIds AND m.status != 'LOCKED'")
    public List<Milestone> findAllByIdAndStatusNotLocked(@Param(value="milestoneIds") List<Long> var1);
}

