/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.xrayimporter.topivot;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporterxray.XrayField;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.ItemXrayDto;
import org.squashtest.tm.service.internal.dto.projectimporterxray.model.XrayImportModel;
import org.squashtest.tm.service.internal.dto.projectimporterxray.model.XrayItemStatus;
import org.squashtest.tm.service.internal.dto.projectimporterxray.topivotdto.entity.executionworkspace.AbstractGenericExecutionWorkspace;
import org.squashtest.tm.service.internal.dto.projectimporterxray.topivotdto.entity.executionworkspace.CampaignToPivot;
import org.squashtest.tm.service.internal.dto.projectimporterxray.topivotdto.entity.executionworkspace.IterationToPivot;
import org.squashtest.tm.service.internal.projectimporter.xrayimporter.exception.ImportXrayException;
import org.squashtest.tm.service.projectimporter.xrayimporter.SquashRules;
import org.squashtest.tm.service.projectimporter.xrayimporter.XrayTablesDao;
import org.squashtest.tm.service.projectimporter.xrayimporter.topivot.AbstractImporterXrayHelper;
import org.squashtest.tm.service.projectimporter.xrayimporter.topivot.ExecutionWorkspaceToPivotImporterService;

@Service(value="executionWorkspaceToPivotImporterService")
public class ExecutionWorkspaceToPivotImporterServiceImpl
extends AbstractImporterXrayHelper
implements ExecutionWorkspaceToPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionWorkspaceToPivotImporterServiceImpl.class);
    private final XrayTablesDao xrayTablesDao;
    private final SquashRules squashRules;

    public ExecutionWorkspaceToPivotImporterServiceImpl(XrayTablesDao xrayTablesDao, SquashRules squashRules) {
        this.xrayTablesDao = xrayTablesDao;
        this.squashRules = squashRules;
    }

    @Override
    public void writeCampaign(JsonFactory jsonFactory, PrintWriter logWriter, ArchiveOutputStream<ZipArchiveEntry> archive, XrayImportModel xrayImportModel) throws IOException {
        logWriter.write(String.format("%sCampaign%s", System.lineSeparator(), System.lineSeparator()));
        boolean isEmptyEntity = this.xrayTablesDao.isEmptyItemTable(XrayField.Type.TEST_PLAN, XrayField.Type.TEST_EXECUTION, XrayField.Type.SUB_TEST_EXECUTION);
        this.writeJson(jsonFactory, jsonGenerator -> this.handleCampaign((JsonGenerator)jsonGenerator, logWriter, xrayImportModel), JsonImportFile.CAMPAIGNS.getFileName(), archive, isEmptyEntity);
    }

    @Override
    public void writeIteration(JsonFactory jsonFactory, PrintWriter logWriter, ArchiveOutputStream<ZipArchiveEntry> archive, XrayImportModel xrayImportModel) throws IOException {
        logWriter.write(String.format("%sIteration%s", System.lineSeparator(), System.lineSeparator()));
        boolean isEmptyEntity = this.xrayTablesDao.isEmptyItemTable(XrayField.Type.TEST_EXECUTION, XrayField.Type.SUB_TEST_EXECUTION);
        this.writeJson(jsonFactory, jsonGenerator -> this.handleIteration((JsonGenerator)jsonGenerator, logWriter, xrayImportModel), JsonImportFile.ITERATIONS.getFileName(), archive, isEmptyEntity);
    }

    private void handleCampaign(JsonGenerator jsonGenerator, PrintWriter logWriter, XrayImportModel xrayImportModel) throws IOException {
        this.squashRules.handleDuplicateName(this.xrayTablesDao.selectDuplicateName(XrayField.Type.TEST_PLAN));
        this.squashRules.handleDuplicateName(this.xrayTablesDao.selectDuplicateNameOrphanTestExecution(XrayField.Type.TEST_EXECUTION, XrayField.Type.SUB_TEST_EXECUTION));
        jsonGenerator.writeFieldName("campaigns");
        jsonGenerator.writeStartArray();
        XrayImportModel.EntityCount entityCount = new XrayImportModel.EntityCount(XrayImportModel.EntityType.CAMPAIGN);
        this.xrayTablesDao.selectTestPlan(ExecutionWorkspaceToPivotImporterServiceImpl.consumerThrowingIOException(itemXrayDto -> this.generateCampaign(jsonGenerator, logWriter, (ItemXrayDto)itemXrayDto, entityCount)), XrayField.Type.TEST_PLAN);
        this.xrayTablesDao.selectOrphanTestExecution(ExecutionWorkspaceToPivotImporterServiceImpl.consumerThrowingIOException(itemXrayDto -> this.generateCampaign(jsonGenerator, logWriter, (ItemXrayDto)itemXrayDto, entityCount)), XrayField.Type.TEST_EXECUTION, XrayField.Type.SUB_TEST_EXECUTION);
        xrayImportModel.getEntityCounts().add(entityCount);
        jsonGenerator.writeEndArray();
    }

    private void generateCampaign(JsonGenerator jsonGenerator, PrintWriter logWriter, ItemXrayDto itemXrayDto, XrayImportModel.EntityCount entityCount) throws IOException {
        try {
            CampaignToPivot campaignToPivot = this.populateCampaign(itemXrayDto);
            jsonGenerator.writeObject((Object)campaignToPivot);
            this.squashRules.markWithSuccessIfStatusIsNull(itemXrayDto);
        }
        catch (ImportXrayException importXrayException) {
            LOGGER.error("Error during the generation pivot format: ", (Throwable)importXrayException);
            itemXrayDto.setItemStatus(XrayItemStatus.FAILURE);
        }
        entityCount.countEntity(itemXrayDto);
        this.writeLog(logWriter, itemXrayDto);
    }

    private CampaignToPivot populateCampaign(ItemXrayDto itemXrayDto) {
        this.squashRules.validateMandatoryCommonField(itemXrayDto);
        CampaignToPivot campaignToPivot = new CampaignToPivot();
        campaignToPivot.setPivotId(itemXrayDto.getPivotId());
        campaignToPivot.setName(itemXrayDto.getSummary());
        campaignToPivot.setReference(itemXrayDto.getKey());
        campaignToPivot.setDescription(this.generateDescription(itemXrayDto, this::addLinkPriorityStatusLabelToDescription));
        campaignToPivot.setStatus(this.squashRules.checkStatus(itemXrayDto, itemXrayDto.getStatus()));
        campaignToPivot.setParentType(EntityType.CAMPAIGN_LIBRARY);
        this.handleTestPlanTestCase(campaignToPivot, itemXrayDto);
        this.handleScheduleDate(campaignToPivot, itemXrayDto);
        return campaignToPivot;
    }

    private void handleScheduleDate(AbstractGenericExecutionWorkspace genericExecutionWorkspace, ItemXrayDto itemXrayDto) {
        String beginDate = itemXrayDto.getDateCufValue("Begin Date", XrayField.CustomFieldKey.DATE_TIME);
        String endDate = itemXrayDto.getDateCufValue("End Date", XrayField.CustomFieldKey.DATE_TIME);
        this.parseXrayDateToIsoDateIfNotNull(itemXrayDto, "Begin Date", beginDate, genericExecutionWorkspace::setScheduledStartDate);
        this.parseXrayDateToIsoDateIfNotNull(itemXrayDto, "End Date", endDate, genericExecutionWorkspace::setScheduledEndDate);
    }

    private void parseXrayDateToIsoDateIfNotNull(ItemXrayDto itemXrayDto, String dateType, String xrayDate, Consumer<String> consumeDate) {
        if (Objects.nonNull(xrayDate)) {
            try {
                DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("EEE, ").appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendPattern(" MMM yyyy HH:mm:ss Z").toFormatter(Locale.ENGLISH);
                LocalDateTime localDateTime = ZonedDateTime.parse(xrayDate, dateTimeFormatter).toLocalDateTime();
                consumeDate.accept(localDateTime.format(DateTimeFormatter.ISO_DATE));
            }
            catch (DateTimeParseException dateTimeParseException) {
                LOGGER.error("Error during the parsing of the date in xray import: ", (Throwable)dateTimeParseException);
                this.squashRules.markWithWarning(itemXrayDto, String.format("The date '%s' cannot be parsed with the pattern '%s'", xrayDate, "EEE, dd MMM yyyy HH:mm:ss Z"));
            }
        } else {
            this.squashRules.markWithWarning(itemXrayDto, String.format("The %s field is missing. The associated scheduling date has been ignored.", dateType));
        }
    }

    private void handleTestPlanTestCase(AbstractGenericExecutionWorkspace genericExecutionWorkspace, ItemXrayDto itemXrayDto) {
        String missingTest = itemXrayDto.getFilterCufValues(XrayField.CustomFieldKey.TEST_PLAN_ASSOCIATED_TESTS, XrayField.CustomFieldKey.EXECUTION_ASSOCIATED_TESTS).stream().filter(key -> !itemXrayDto.getAssociatedIssuesWithXrayKey().containsKey(key)).collect(Collectors.joining(", "));
        if (missingTest.isEmpty()) {
            genericExecutionWorkspace.getTestPlanTestCaseIds().addAll(itemXrayDto.getAssociatedIssuesWithXrayKey().values());
        } else {
            this.squashRules.markWithWarning(itemXrayDto, String.format("The following test are missing: %s. They have been ignored.", missingTest));
        }
    }

    private void handleIteration(JsonGenerator jsonGenerator, PrintWriter logWriter, XrayImportModel xrayImportModel) throws IOException {
        this.squashRules.handleDuplicateNameWithParentType(this.xrayTablesDao.selectDuplicateNameGroupBy(XrayField.CustomFieldKey.EXECUTION_ASSOCIATED_TEST_PLAN, XrayField.Type.TEST_EXECUTION, XrayField.Type.SUB_TEST_EXECUTION));
        XrayImportModel.EntityCount entityCount = new XrayImportModel.EntityCount(XrayImportModel.EntityType.ITERATION);
        jsonGenerator.writeFieldName("iterations");
        jsonGenerator.writeStartArray();
        this.xrayTablesDao.selectTestExecutionForIteration(ExecutionWorkspaceToPivotImporterServiceImpl.consumerThrowingRecordAndId((itemXrayDto, id) -> this.generateIteration(jsonGenerator, logWriter, (ItemXrayDto)itemXrayDto, entityCount, (AtomicInteger)id)), XrayField.Type.TEST_EXECUTION, XrayField.Type.SUB_TEST_EXECUTION);
        xrayImportModel.getEntityCounts().add(entityCount);
        jsonGenerator.writeEndArray();
    }

    private void generateIteration(JsonGenerator jsonGenerator, PrintWriter logWriter, ItemXrayDto itemXrayDto, XrayImportModel.EntityCount entityCount, AtomicInteger id) throws IOException {
        try {
            IterationToPivot iterationToPivot = this.populateIteration(itemXrayDto, id);
            jsonGenerator.writeObject((Object)iterationToPivot);
            this.squashRules.markWithSuccessIfStatusIsNull(itemXrayDto);
        }
        catch (ImportXrayException importXrayException) {
            LOGGER.error("Error during the generation pivot format: ", (Throwable)importXrayException);
            itemXrayDto.setItemStatus(XrayItemStatus.FAILURE);
        }
        entityCount.countEntity(itemXrayDto);
        this.writeLog(logWriter, itemXrayDto);
    }

    private IterationToPivot populateIteration(ItemXrayDto itemXrayDto, AtomicInteger id) {
        this.squashRules.validateMandatoryCommonField(itemXrayDto);
        IterationToPivot iterationToPivot = new IterationToPivot();
        iterationToPivot.setPivotId(id.incrementAndGet());
        iterationToPivot.setName(itemXrayDto.getSummary());
        iterationToPivot.setReference(itemXrayDto.getKey());
        iterationToPivot.setDescription(this.generateDescription(itemXrayDto, this::addLinkPriorityStatusLabelToDescription));
        iterationToPivot.setStatus(this.squashRules.checkStatus(itemXrayDto, itemXrayDto.getStatus()));
        this.handleTestPlanTestCase(iterationToPivot, itemXrayDto);
        this.handleScheduleDate(iterationToPivot, itemXrayDto);
        this.addIterationParentId(itemXrayDto, iterationToPivot);
        return iterationToPivot;
    }

    private void addIterationParentId(ItemXrayDto itemXrayDto, IterationToPivot iterationToPivot) {
        if (!itemXrayDto.getTestPlanPivotIds().isEmpty()) {
            if (itemXrayDto.getTestPlanPivotIds().size() > 1) {
                this.squashRules.markWithWarning(itemXrayDto, "Multiple Test Plan associations found. Only the first one has been taken into account.");
            }
            iterationToPivot.setParentId(itemXrayDto.getTestPlanPivotIds().get(0));
        } else if (Objects.nonNull(itemXrayDto.getPivotId())) {
            iterationToPivot.setParentId(itemXrayDto.getPivotId());
        } else {
            this.squashRules.markWithErrorAndThrow(itemXrayDto, "The issue is linked to a Test Plan, but the Test Plan is not found in the export.");
        }
    }
}

