/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.xrayimporter.exception;

import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.exception.ActionException;

public class XrayParsingException
extends ActionException {
    private static final long serialVersionUID = -8935819669759117567L;
    private final String messageKey;
    private final Object[] messageArgs;

    public XrayParsingException(String fileName, String message) {
        super(message);
        this.messageArgs = new Object[]{fileName, this.escapeMessageHtml(message)};
        this.messageKey = "sqtm-core.exception.xray-import.xray-parsing-exception";
    }

    public XrayParsingException(String fileName, String message, Throwable cause) {
        super(message, cause);
        this.messageArgs = new Object[]{fileName, this.escapeMessageHtml(message)};
        this.messageKey = "sqtm-core.exception.xray-import.xray-parsing-exception";
    }

    public XrayParsingException(String fileName, int line, String message, Throwable cause) {
        super(message, cause);
        this.messageArgs = new Object[]{fileName, this.escapeMessageHtml(message), line};
        this.messageKey = "sqtm-core.exception.xray-import.xray-parsing-exception-line";
    }

    public XrayParsingException(String fileName, String itemName, int line, String message, Throwable cause) {
        super(message, cause);
        this.messageArgs = new Object[]{fileName, this.escapeMessageHtml(message), line, itemName};
        this.messageKey = "sqtm-core.exception.xray-import.xray-parsing-exception-line-item-name";
    }

    public String getI18nKey() {
        return this.messageKey;
    }

    public Object[] messageArgs() {
        return this.messageArgs;
    }

    private String escapeMessageHtml(String message) {
        return HtmlUtils.htmlEscape((String)message);
    }
}

