/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter.parsers;

import com.fasterxml.jackson.core.JsonParser;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.requirement.NewRequirementVersionDto;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.RequirementToImport;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.parsers.AttachmentParserHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.PivotJsonParsingHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.parsers.RequirementWorkspaceParser;

@Service(value="RequirementWorkspaceParser")
public class RequirementWorkspaceParserImpl
implements RequirementWorkspaceParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementWorkspaceParserImpl.class);
    private static final String REQ_CAT_PREFIX = "CAT_";

    @Override
    public RequirementToImport parseRequirement(JsonParser jsonParser, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        RequirementToImport requirementToImport = new RequirementToImport();
        NewRequirementVersionDto requirementDto = new NewRequirementVersionDto();
        try {
            while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
                String fieldName = jsonParser.getCurrentName();
                jsonParser.nextToken();
                switch (fieldName) {
                    case "id": {
                        requirementToImport.setInternalId(jsonParser.getText());
                        break;
                    }
                    case "name": {
                        requirementDto.setName(jsonParser.getText());
                        break;
                    }
                    case "description": {
                        requirementDto.setDescription(jsonParser.getText());
                        break;
                    }
                    case "reference": {
                        requirementDto.setReference(jsonParser.getText());
                        break;
                    }
                    case "status": {
                        requirementToImport.setStatus(RequirementStatus.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "criticality": {
                        requirementDto.setCriticality(RequirementCriticality.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "category": {
                        this.handleCategory(requirementDto, jsonParser.getText());
                        break;
                    }
                    case "custom_fields": {
                        requirementDto.setCustomFields(PivotJsonParsingHelper.getCustomFieldValues(jsonParser, pivotImportMetadata.getCustomFieldIdsMap()));
                        break;
                    }
                    case "parent_type": {
                        requirementToImport.setParentType(EntityType.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "parent_id": {
                        requirementToImport.setParentId(jsonParser.getText());
                        break;
                    }
                    case "attachments": {
                        requirementToImport.setAttachments(AttachmentParserHelper.parseAttachments(jsonParser));
                        break;
                    }
                }
                PivotFormatLoggerHelper.logParsingSuccessForEntity(LOGGER, "requirement", requirementDto.getName(), requirementToImport.getInternalId(), pivotFormatImport);
            }
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleParsingErrorForEntity(LOGGER, "requirement", requirementToImport.getInternalId(), pivotFormatImport, e);
        }
        this.updateNullValueWithDefaultValues(requirementToImport, requirementDto);
        requirementToImport.setRequirement(requirementDto);
        return requirementToImport;
    }

    private void handleCategory(NewRequirementVersionDto requirementVersionDto, String category) {
        if (Objects.nonNull(category)) {
            requirementVersionDto.setCategory(REQ_CAT_PREFIX + category);
        } else {
            requirementVersionDto.setCategory("CAT_FUNCTIONAL");
        }
    }

    private void updateNullValueWithDefaultValues(RequirementToImport requirementToImport, NewRequirementVersionDto requirementDto) {
        if (Objects.isNull(requirementDto.getReference())) {
            requirementDto.setReference("");
        }
        if (Objects.isNull(requirementDto.getCategory())) {
            requirementDto.setCategory("CAT_FUNCTIONAL");
        }
        if (Objects.isNull(requirementDto.getCriticality())) {
            requirementDto.setCriticality(RequirementCriticality.UNDEFINED);
        }
        if (Objects.isNull(requirementToImport.getStatus())) {
            requirementToImport.setStatus(RequirementStatus.WORK_IN_PROGRESS);
        }
    }
}

