/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.dto.projectimporter.RequirementToImport;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.AttachmentHolderInfo;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.AttachmentPivotImportService;
import org.squashtest.tm.service.projectimporter.pivotimporter.PivotJsonParsingHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.RequirementPivotImporterService;
import org.squashtest.tm.service.projectimporter.pivotimporter.parsers.RequirementWorkspaceParser;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;

@Service(value="RequirementPivotImporterService")
public class RequirementPivotImporterServiceImpl
implements RequirementPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementPivotImporterServiceImpl.class);
    private final RequirementLibraryNavigationService requirementLibraryNavigationService;
    private final RequirementWorkspaceParser requirementWorkspaceParser;
    private final AttachmentPivotImportService attachmentPivotImportService;
    @PersistenceContext
    private EntityManager entityManager;

    public RequirementPivotImporterServiceImpl(RequirementLibraryNavigationService requirementLibraryNavigationService, RequirementWorkspaceParser requirementWorkspaceParser, AttachmentPivotImportService attachmentPivotImportService) {
        this.requirementLibraryNavigationService = requirementLibraryNavigationService;
        this.requirementWorkspaceParser = requirementWorkspaceParser;
        this.attachmentPivotImportService = attachmentPivotImportService;
    }

    @Override
    public void importRequirementsFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        PivotFormatLoggerHelper.logImportStartedForEntitiesKind(LOGGER, zipFile.getName(), "requirements", pivotFormatImport);
        ZipEntry entry = zipFile.getEntry(JsonImportFile.REQUIREMENTS.getFileName());
        if (Objects.nonNull(entry)) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream jsonInputStream = zipFile.getInputStream(entry);){
                    this.handleRequirementsInJsonFile(jsonInputStream, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
                    PivotFormatLoggerHelper.logImportSuccessForEntitiesKind(LOGGER, "requirements", pivotFormatImport);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.logImportFailureForEntitiesKind(LOGGER, "requirements", pivotFormatImport);
                throw e;
            }
        }
    }

    private void handleRequirementsInJsonFile(InputStream jsonInputStream, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        Throwable throwable = null;
        Object var7_8 = null;
        try (JsonParser jsonParser = jsonFactory.createParser(jsonInputStream);){
            while (jsonParser.nextToken() != null) {
                this.parseRequirementsArray(projectIdsReferences, pivotImportMetadata, jsonParser, pivotFormatImport);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseRequirementsArray(ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, JsonParser jsonParser, PivotFormatImport pivotFormatImport) throws IOException {
        requirementsToImport = new ArrayList<RequirementToImport>();
        if ("requirements".equals(jsonParser.getCurrentName())) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            if (PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) {
                requirementToImport = this.requirementWorkspaceParser.parseRequirement(jsonParser, pivotImportMetadata, pivotFormatImport);
                requirementsToImport.add(requirementToImport);
            }
            if (requirementsToImport.size() != 100) continue;
            this.createRequirements(requirementsToImport, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
lbl10:
            // 3 sources

            ** while (PivotJsonParsingHelper.isNotTheEndOfParsedArray((JsonParser)jsonParser))
        }
lbl11:
        // 1 sources

        if (!requirementsToImport.isEmpty()) {
            this.createRequirements(requirementsToImport, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        }
    }

    private void createRequirements(List<RequirementToImport> requirementsToImport, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        for (RequirementToImport requirementToImport : requirementsToImport) {
            PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "requirement", requirementToImport.getInternalId(), pivotFormatImport);
            try {
                this.createRequirement(requirementToImport, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
                PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "requirement", requirementToImport.getRequirement().getName(), requirementToImport.getInternalId(), pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "requirement", requirementToImport.getRequirement().getName(), requirementToImport.getInternalId(), pivotFormatImport, e);
            }
        }
        requirementsToImport.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createRequirement(RequirementToImport requirementsToImport, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        Requirement squashRequirement = this.createSquashRequirement(requirementsToImport, projectIdsReferences, pivotImportMetadata);
        squashRequirement.getCurrentVersion().updateStatusWithoutCheck(requirementsToImport.getStatus());
        pivotImportMetadata.getRequirementIdsMap().put(requirementsToImport.getInternalId(), squashRequirement.getId());
        this.attachmentPivotImportService.addAttachmentsToEntity(requirementsToImport.getAttachments(), new AttachmentHolderInfo(squashRequirement.getId(), squashRequirement.getAttachmentList().getId(), EntityType.REQUIREMENT, requirementsToImport.getInternalId()), pivotFormatImport, pivotImportMetadata);
    }

    private Requirement createSquashRequirement(RequirementToImport requirementsToImport, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata) {
        return switch (requirementsToImport.getParentType()) {
            case EntityType.REQUIREMENT_LIBRARY -> this.requirementLibraryNavigationService.addRequirementToRequirementLibraryUnsecured(projectIdsReferences.getRequirementLibraryId(), requirementsToImport.getRequirement(), new ArrayList<Long>());
            case EntityType.REQUIREMENT_FOLDER -> {
                Long squashTargetId = pivotImportMetadata.getRequirementFoldersIdsMap().get(requirementsToImport.getParentId());
                yield this.requirementLibraryNavigationService.addRequirementToRequirementFolderUnsecured(squashTargetId, requirementsToImport.getRequirement(), new ArrayList<Long>());
            }
            case EntityType.REQUIREMENT -> {
                Long squashTargetId = pivotImportMetadata.getRequirementIdsMap().get(requirementsToImport.getParentId());
                yield this.requirementLibraryNavigationService.addRequirementToRequirementUnsecured(squashTargetId, requirementsToImport.getRequirement(), new ArrayList<Long>());
            }
            default -> throw new IllegalArgumentException("This entity type is not handled " + requirementsToImport.getParentType());
        };
    }
}

