/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Service;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.campaign.CustomIterationModificationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.campaign.TestSuiteTestPlanManagerService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.dto.projectimporter.TestSuiteInfo;
import org.squashtest.tm.service.internal.dto.projectimporter.campaignworkspace.CampaignToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.campaignworkspace.ExecutionStepInfo;
import org.squashtest.tm.service.internal.dto.projectimporter.campaignworkspace.ExecutionToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.campaignworkspace.IterationToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.campaignworkspace.TestSuiteToImport;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.AttachmentHolderInfo;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.ExecutionWorkspacePivotImporterServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.ExecutionWorkspacePivotImporterServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.AttachmentPivotImportService;
import org.squashtest.tm.service.projectimporter.pivotimporter.ExecutionWorkspacePivotImporterService;
import org.squashtest.tm.service.projectimporter.pivotimporter.PivotJsonParsingHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.parsers.ExecutionWorkspaceParser;

@Service(value="ExecutionWorkspacePivotImporterService")
public class ExecutionWorkspacePivotImporterServiceImpl
implements ExecutionWorkspacePivotImporterService {
    private static final Logger LOGGER;
    private final CampaignLibraryNavigationService campaignLibraryNavigationService;
    private final CampaignTestPlanManagerService campaignTestPlanManagerService;
    private final IterationTestPlanManagerService iterationTestPlanManagerService;
    private final TestSuiteTestPlanManagerService testSuiteTestPlanManagerService;
    private final IterationModificationService iterationModificationService;
    private final PrivateCustomFieldValueService privateCustomFieldValueService;
    private final CustomIterationModificationService customIterationModificationService;
    private final ExecutionWorkspaceParser executionWorkspaceParser;
    private final IterationTestPlanManagerService testPlanService;
    private final AttachmentPivotImportService attachmentPivotImportService;
    private final DSLContext dsl;
    @PersistenceContext
    private EntityManager entityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        ExecutionWorkspacePivotImporterServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ExecutionWorkspacePivotImporterService.class);
    }

    public ExecutionWorkspacePivotImporterServiceImpl(CampaignLibraryNavigationService campaignLibraryNavigationService, CampaignTestPlanManagerService campaignTestPlanManagerService, IterationTestPlanManagerService iterationTestPlanManagerService, TestSuiteTestPlanManagerService testSuiteTestPlanManagerService, IterationModificationService iterationModificationService, PrivateCustomFieldValueService privateCustomFieldValueService, CustomIterationModificationService customIterationModificationService, ExecutionWorkspaceParser executionWorkspaceParser, IterationTestPlanManagerService testPlanService, AttachmentPivotImportService attachmentPivotImportService, DSLContext dsl) {
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
        this.campaignTestPlanManagerService = campaignTestPlanManagerService;
        this.iterationTestPlanManagerService = iterationTestPlanManagerService;
        this.testSuiteTestPlanManagerService = testSuiteTestPlanManagerService;
        this.iterationModificationService = iterationModificationService;
        this.privateCustomFieldValueService = privateCustomFieldValueService;
        this.customIterationModificationService = customIterationModificationService;
        this.executionWorkspaceParser = executionWorkspaceParser;
        this.testPlanService = testPlanService;
        this.attachmentPivotImportService = attachmentPivotImportService;
        this.dsl = dsl;
    }

    @Override
    public void importCampaignsFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        PivotFormatLoggerHelper.logImportStartedForEntitiesKind(LOGGER, zipFile.getName(), "campaigns", pivotFormatImport);
        ZipEntry entry = zipFile.getEntry(JsonImportFile.CAMPAIGNS.getFileName());
        if (Objects.nonNull(entry)) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream jsonInputStream = zipFile.getInputStream(entry);){
                    this.handleCampaignsFromJsonFile(jsonInputStream, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
                    PivotFormatLoggerHelper.logImportSuccessForEntitiesKind(LOGGER, "campaigns", pivotFormatImport);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.logImportFailureForEntitiesKind(LOGGER, "campaigns", pivotFormatImport);
                throw e;
            }
        }
    }

    private void handleCampaignsFromJsonFile(InputStream jsonInputStream, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        Throwable throwable = null;
        Object var7_8 = null;
        try (JsonParser jsonParser = jsonFactory.createParser(jsonInputStream);){
            while (jsonParser.nextToken() != null) {
                this.parseCampaignsArray(projectIdsReferences, pivotImportMetadata, jsonParser, pivotFormatImport);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseCampaignsArray(ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, JsonParser jsonParser, PivotFormatImport pivotFormatImport) throws IOException {
        campaignsToImport = new ArrayList<CampaignToImport>();
        if ("campaigns".equals(jsonParser.getCurrentName())) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            if (PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) {
                campaignToImport = this.executionWorkspaceParser.parseCampaign(jsonParser, pivotImportMetadata, pivotFormatImport);
                campaignsToImport.add(campaignToImport);
            }
            if (campaignsToImport.size() != 100) continue;
            this.createCampaigns(campaignsToImport, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
lbl10:
            // 3 sources

            ** while (PivotJsonParsingHelper.isNotTheEndOfParsedArray((JsonParser)jsonParser))
        }
lbl11:
        // 1 sources

        if (!campaignsToImport.isEmpty()) {
            this.createCampaigns(campaignsToImport, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        }
    }

    private void createCampaigns(List<CampaignToImport> campaignsToImport, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        for (CampaignToImport campaignToImport : campaignsToImport) {
            PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "campaign", campaignToImport.getInternalId(), pivotFormatImport);
            try {
                this.createCampaign(campaignToImport, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
                PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "campaign", campaignToImport.getName(), campaignToImport.getInternalId(), pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "campaign", campaignToImport.getName(), campaignToImport.getInternalId(), pivotFormatImport, e);
            }
        }
        campaignsToImport.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createCampaign(CampaignToImport campaignToImport, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        Long squashFolderTargetId = pivotImportMetadata.getCampaignFoldersIdsMap().get(campaignToImport.getParentId());
        Campaign squashCampaign = switch (campaignToImport.getParentType()) {
            case EntityType.CAMPAIGN_LIBRARY -> this.campaignLibraryNavigationService.addCampaignToCampaignLibraryUnsecured(projectIdsReferences.getCampaignLibraryId(), campaignToImport.toCampaign(), campaignToImport.getCustomFields());
            case EntityType.CAMPAIGN_FOLDER -> this.campaignLibraryNavigationService.addCampaignToCampaignFolderUnsecured(squashFolderTargetId, campaignToImport.toCampaign(), campaignToImport.getCustomFields());
            default -> throw new IllegalArgumentException("This entity type is not handled " + campaignToImport.getParentType());
        };
        pivotImportMetadata.getCampaignIdsMap().put(campaignToImport.getInternalId(), squashCampaign.getId());
        this.addTestCaseToCampaignTestPlan(campaignToImport.getTestPlanTestCaseIds(), pivotImportMetadata, squashCampaign.getId());
        this.attachmentPivotImportService.addAttachmentsToEntity(campaignToImport.getAttachments(), new AttachmentHolderInfo(squashCampaign.getId(), squashCampaign.getAttachmentList().getId(), EntityType.CAMPAIGN, campaignToImport.getInternalId()), pivotFormatImport, pivotImportMetadata);
    }

    private void addTestCaseToCampaignTestPlan(List<String> testPlanTestCaseIds, PivotImportMetadata pivotImportMetadata, Long campaignId) {
        List<Long> squashTestCaseIds = testPlanTestCaseIds.stream().map(internalId -> pivotImportMetadata.getTestCaseIdsMap().get(internalId)).toList();
        this.campaignTestPlanManagerService.addTestCasesToCampaignTestPlanUnsecured(squashTestCaseIds, campaignId);
    }

    @Override
    public void importIterationsFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        PivotFormatLoggerHelper.logImportStartedForEntitiesKind(LOGGER, zipFile.getName(), "iterations", pivotFormatImport);
        ZipEntry entry = zipFile.getEntry(JsonImportFile.ITERATIONS.getFileName());
        if (Objects.nonNull(entry)) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream jsonInputStream = zipFile.getInputStream(entry);){
                    this.handleIterationsFromJsonFile(jsonInputStream, pivotImportMetadata, pivotFormatImport);
                    PivotFormatLoggerHelper.logImportSuccessForEntitiesKind(LOGGER, "iterations", pivotFormatImport);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.logImportFailureForEntitiesKind(LOGGER, "iterations", pivotFormatImport);
                throw e;
            }
        }
    }

    private void handleIterationsFromJsonFile(InputStream jsonInputStream, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        Throwable throwable = null;
        Object var6_7 = null;
        try (JsonParser jsonParser = jsonFactory.createParser(jsonInputStream);){
            while (jsonParser.nextToken() != null) {
                this.parseIterationsArray(pivotImportMetadata, jsonParser, pivotFormatImport);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseIterationsArray(PivotImportMetadata pivotImportMetadata, JsonParser jsonParser, PivotFormatImport pivotFormatImport) throws IOException {
        iterationsToImport = new ArrayList<IterationToImport>();
        if ("iterations".equals(jsonParser.getCurrentName())) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            if (PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) {
                iterationToImport = this.executionWorkspaceParser.parseIteration(jsonParser, pivotImportMetadata, pivotFormatImport);
                iterationsToImport.add(iterationToImport);
            }
            if (iterationsToImport.size() != 100) continue;
            this.createIterations(iterationsToImport, pivotImportMetadata, pivotFormatImport);
lbl10:
            // 3 sources

            ** while (PivotJsonParsingHelper.isNotTheEndOfParsedArray((JsonParser)jsonParser))
        }
lbl11:
        // 1 sources

        if (!iterationsToImport.isEmpty()) {
            this.createIterations(iterationsToImport, pivotImportMetadata, pivotFormatImport);
        }
    }

    private void createIterations(List<IterationToImport> iterationsToImport, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        for (IterationToImport iterationToImport : iterationsToImport) {
            PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "iteration", iterationToImport.getInternalId(), pivotFormatImport);
            try {
                this.createIteration(iterationToImport, pivotImportMetadata, pivotFormatImport);
                PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "iteration", iterationToImport.getName(), iterationToImport.getInternalId(), pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "iteration", iterationToImport.getName(), iterationToImport.getInternalId(), pivotFormatImport, e);
            }
        }
        iterationsToImport.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createIteration(IterationToImport iterationToImport, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        Long squashTargetId = pivotImportMetadata.getCampaignIdsMap().get(iterationToImport.getParentId());
        Iteration squashIteration = this.customIterationModificationService.addIterationToCampaignUnsecured(iterationToImport.toIteration(), squashTargetId, false, iterationToImport.getCustomFields());
        pivotImportMetadata.getIterationIdsMap().put(iterationToImport.getInternalId(), squashIteration.getId());
        this.addTestCaseToIterationTestPlan(iterationToImport.getTestPlanTestCaseIds(), pivotImportMetadata, squashIteration.getId());
        this.attachmentPivotImportService.addAttachmentsToEntity(iterationToImport.getAttachments(), new AttachmentHolderInfo(squashIteration.getId(), squashIteration.getAttachmentList().getId(), EntityType.ITERATION, iterationToImport.getInternalId()), pivotFormatImport, pivotImportMetadata);
    }

    private void addTestCaseToIterationTestPlan(List<String> testPlanTestCaseIds, PivotImportMetadata pivotImportMetadata, Long testSuiteId) {
        List<Long> squashTestCaseIds = testPlanTestCaseIds.stream().map(internalId -> pivotImportMetadata.getTestCaseIdsMap().get(internalId)).toList();
        this.iterationTestPlanManagerService.addTestCasesToIterationUnsecured(squashTestCaseIds, testSuiteId);
    }

    @Override
    public void importTestSuitesFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        PivotFormatLoggerHelper.logImportStartedForEntitiesKind(LOGGER, zipFile.getName(), "test suites", pivotFormatImport);
        ZipEntry entry = zipFile.getEntry(JsonImportFile.TEST_SUITES.getFileName());
        if (Objects.nonNull(entry)) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream jsonInputStream = zipFile.getInputStream(entry);){
                    this.handleTestSuitesFromJsonFile(jsonInputStream, pivotImportMetadata, pivotFormatImport);
                    PivotFormatLoggerHelper.logImportSuccessForEntitiesKind(LOGGER, "test suites", pivotFormatImport);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.logImportFailureForEntitiesKind(LOGGER, "test suites", pivotFormatImport);
                throw e;
            }
        }
    }

    private void handleTestSuitesFromJsonFile(InputStream jsonInputStream, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        Throwable throwable = null;
        Object var6_7 = null;
        try (JsonParser jsonParser = jsonFactory.createParser(jsonInputStream);){
            while (jsonParser.nextToken() != null) {
                this.parseTestSuitesArray(pivotImportMetadata, jsonParser, pivotFormatImport);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseTestSuitesArray(PivotImportMetadata pivotImportMetadata, JsonParser jsonParser, PivotFormatImport pivotFormatImport) throws IOException {
        testSuitesToImport = new ArrayList<TestSuiteToImport>();
        if ("test_suites".equals(jsonParser.getCurrentName())) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            if (PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) {
                testSuiteToImport = this.executionWorkspaceParser.parseTestSuite(jsonParser, pivotImportMetadata, pivotFormatImport);
                testSuitesToImport.add(testSuiteToImport);
            }
            if (testSuitesToImport.size() != 100) continue;
            this.createTestSuites(testSuitesToImport, pivotImportMetadata, pivotFormatImport);
lbl10:
            // 3 sources

            ** while (PivotJsonParsingHelper.isNotTheEndOfParsedArray((JsonParser)jsonParser))
        }
lbl11:
        // 1 sources

        if (!testSuitesToImport.isEmpty()) {
            this.createTestSuites(testSuitesToImport, pivotImportMetadata, pivotFormatImport);
        }
    }

    private void createTestSuites(List<TestSuiteToImport> testSuitesToImport, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        for (TestSuiteToImport testSuiteToImport : testSuitesToImport) {
            PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "test suite", testSuiteToImport.getInternalId(), pivotFormatImport);
            try {
                this.createTestSuite(testSuiteToImport, pivotImportMetadata, pivotFormatImport);
                PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "test suite", testSuiteToImport.getName(), testSuiteToImport.getInternalId(), pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "test suite", testSuiteToImport.getName(), testSuiteToImport.getInternalId(), pivotFormatImport, e);
            }
        }
        testSuitesToImport.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createTestSuite(TestSuiteToImport testSuiteToImport, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        Long squashTargetId = pivotImportMetadata.getIterationIdsMap().get(testSuiteToImport.getParentId());
        TestSuite squashTestSuite = this.campaignLibraryNavigationService.addTestSuiteToIterationUnsecured(squashTargetId, testSuiteToImport.toTestSuite(), testSuiteToImport.getCustomFields());
        pivotImportMetadata.getTestSuiteIdsMap().put(testSuiteToImport.getInternalId(), new TestSuiteInfo(squashTestSuite.getId(), testSuiteToImport.getExecutionStatus()));
        this.addTestCaseToTestSuiteTestPlan(testSuiteToImport.getTestPlanTestCaseIds(), pivotImportMetadata, squashTestSuite.getId());
        squashTestSuite.setExecutionStatus(testSuiteToImport.getExecutionStatus());
        this.attachmentPivotImportService.addAttachmentsToEntity(testSuiteToImport.getAttachments(), new AttachmentHolderInfo(squashTestSuite.getId(), squashTestSuite.getAttachmentList().getId(), EntityType.TEST_SUITE, testSuiteToImport.getInternalId()), pivotFormatImport, pivotImportMetadata);
    }

    private void addTestCaseToTestSuiteTestPlan(List<String> testPlanTestCaseIds, PivotImportMetadata pivotImportMetadata, Long testSuiteId) {
        List<Long> squashTestCaseIds = testPlanTestCaseIds.stream().map(internalId -> pivotImportMetadata.getTestCaseIdsMap().get(internalId)).toList();
        this.testSuiteTestPlanManagerService.addTestCasesToIterationAndTestSuiteUnsecured(squashTestCaseIds, testSuiteId);
    }

    @Override
    public void importExecutionsFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        PivotFormatLoggerHelper.logImportStartedForEntitiesKind(LOGGER, zipFile.getName(), "executions", pivotFormatImport);
        ZipEntry entry = zipFile.getEntry(JsonImportFile.EXECUTIONS.getFileName());
        if (Objects.nonNull(entry)) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream jsonInputStream = zipFile.getInputStream(entry);){
                    this.handleExecutionsFromJsonFile(jsonInputStream, pivotImportMetadata, pivotFormatImport);
                    PivotFormatLoggerHelper.logImportSuccessForEntitiesKind(LOGGER, "executions", pivotFormatImport);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.logImportFailureForEntitiesKind(LOGGER, "executions", pivotFormatImport);
                throw e;
            }
        }
    }

    private void handleExecutionsFromJsonFile(InputStream jsonInputStream, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        Throwable throwable = null;
        Object var6_7 = null;
        try (JsonParser jsonParser = jsonFactory.createParser(jsonInputStream);){
            while (jsonParser.nextToken() != null) {
                this.parseExecutionsArray(pivotImportMetadata, jsonParser, pivotFormatImport);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseExecutionsArray(PivotImportMetadata pivotImportMetadata, JsonParser jsonParser, PivotFormatImport pivotFormatImport) throws IOException {
        executionsToImport = new ArrayList<ExecutionToImport>();
        if ("executions".equals(jsonParser.getCurrentName())) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            if (PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) {
                executionToImport = this.executionWorkspaceParser.parseExecution(jsonParser, pivotImportMetadata, pivotFormatImport);
                executionsToImport.add(executionToImport);
            }
            if (executionsToImport.size() != 100) continue;
            this.createExecutions(executionsToImport, pivotImportMetadata, pivotFormatImport);
lbl10:
            // 3 sources

            ** while (PivotJsonParsingHelper.isNotTheEndOfParsedArray((JsonParser)jsonParser))
        }
lbl11:
        // 1 sources

        if (!executionsToImport.isEmpty()) {
            this.createExecutions(executionsToImport, pivotImportMetadata, pivotFormatImport);
        }
    }

    private void createExecutions(List<ExecutionToImport> executionsToImport, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        for (ExecutionToImport executionToImport : executionsToImport) {
            PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "execution", executionToImport.getInternalId(), pivotFormatImport);
            try {
                this.createExecution(executionToImport, pivotImportMetadata, pivotFormatImport);
                PivotFormatLoggerHelper.logUnnamedEntityCreatedSuccessfully(LOGGER, "execution", executionToImport.getInternalId(), pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleUnnamedEntityCreationFailed(LOGGER, "execution", executionToImport.getInternalId(), pivotFormatImport, e);
            }
        }
        executionsToImport.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createExecution(ExecutionToImport executionToImport, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        Long testPlanItemId = executionToImport.getParentType().equals((Object)EntityType.ITERATION) ? this.findTestPlanItemIdForIteration(executionToImport, pivotImportMetadata) : this.findTestPlanItemIdForTestSuite(executionToImport, pivotImportMetadata);
        Execution execution = this.iterationModificationService.addManualExecutionUnsecured(testPlanItemId);
        ExecutionToImport executionToImport2 = executionToImport;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)executionToImport2);
        Object[] objectArray = new Object[]{this, executionToImport2, joinPoint};
        ExecutionWorkspacePivotImporterServiceImpl$AjcClosure1 executionWorkspacePivotImporterServiceImpl$AjcClosure1 = new ExecutionWorkspacePivotImporterServiceImpl$AjcClosure1(objectArray);
        execution.setDescription((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionWorkspacePivotImporterServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112)));
        execution.setLastExecutedBy(executionToImport.getLastExecutedBy());
        execution.setLastExecutedOn(executionToImport.getLastExecutedOn());
        if (Objects.nonNull(executionToImport.getExecutionStatus())) {
            execution.setExecutionStatus(executionToImport.getExecutionStatus());
        }
        this.attachmentPivotImportService.addAttachmentsToEntity(executionToImport.getAttachments(), new AttachmentHolderInfo(execution.getId(), execution.getAttachmentList().getId(), EntityType.EXECUTION, executionToImport.getInternalId()), pivotFormatImport, pivotImportMetadata);
        this.privateCustomFieldValueService.initCustomFieldValues((BoundEntity)execution, executionToImport.getCustomFields());
        this.updateExecutionSteps(execution, executionToImport, pivotImportMetadata, pivotFormatImport);
        if (executionToImport.getParentType().equals((Object)EntityType.TEST_SUITE)) {
            TestSuiteInfo testSuiteInfo = pivotImportMetadata.getTestSuiteIdsMap().get(executionToImport.getParentId());
            TestSuite testSuite = (TestSuite)this.entityManager.find(TestSuite.class, (Object)testSuiteInfo.id());
            testSuite.setExecutionStatus(testSuiteInfo.status());
        }
        IterationTestPlanItem testPlan = execution.getTestPlan();
        this.testPlanService.updateMetadata(testPlan);
    }

    private void updateExecutionSteps(Execution execution, ExecutionToImport executionToImport, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        List<Long> executionStepIds = execution.getSteps().stream().map(ExecutionStep::getId).toList();
        Map<Long, Long> referencedTestStepIdByExecutionStepIdMap = this.findReferencedTestStepIdForExecutionStepIds(executionStepIds);
        for (ExecutionStepInfo executionStepInfo : executionToImport.getExecutionSteps()) {
            Long testStepId = pivotImportMetadata.getTestStepsIdsMap().get(executionStepInfo.getTestStepId());
            ExecutionStep executionStep = execution.getSteps().stream().filter(step -> ((Long)referencedTestStepIdByExecutionStepIdMap.get(step.getId())).equals(testStepId)).findFirst().orElse(null);
            if (!Objects.nonNull(executionStep)) continue;
            this.updateExecutionStep(execution, executionToImport, executionStepInfo, executionStep, pivotFormatImport, pivotImportMetadata);
        }
    }

    private void updateExecutionStep(Execution execution, ExecutionToImport executionToImport, ExecutionStepInfo executionStepInfo, ExecutionStep executionStep, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) throws IOException {
        ExecutionStepInfo executionStepInfo2 = executionStepInfo;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)executionStepInfo2);
        Object[] objectArray = new Object[]{this, executionStepInfo2, joinPoint};
        ExecutionWorkspacePivotImporterServiceImpl$AjcClosure3 executionWorkspacePivotImporterServiceImpl$AjcClosure3 = new ExecutionWorkspacePivotImporterServiceImpl$AjcClosure3(objectArray);
        executionStep.setComment((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(executionWorkspacePivotImporterServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112)));
        executionStep.setExecutionStatus(executionStepInfo.getStatus());
        executionStep.setLastExecutedBy(executionStepInfo.getLastExecutedBy());
        executionStep.setLastExecutedOn(executionStepInfo.getLastExecutedOn());
        this.privateCustomFieldValueService.initCustomFieldValues((BoundEntity)executionStep, executionToImport.getCustomFields());
        this.attachmentPivotImportService.addAttachmentsToEntity(executionStepInfo.getAttachments(), new AttachmentHolderInfo(execution.getId(), executionStep.getAttachmentList().getId(), EntityType.EXECUTION_STEP, executionToImport.getInternalId()), pivotFormatImport, pivotImportMetadata);
    }

    private Long findTestPlanItemIdForIteration(ExecutionToImport execution, PivotImportMetadata pivotImportMetadata) {
        Long squashTestCaseId = pivotImportMetadata.getTestCaseIdsMap().get(execution.getTestCaseId());
        Long squashDatasetId = pivotImportMetadata.getDatasetIdsMap().get(execution.getDatasetId());
        Long squashIterationId = pivotImportMetadata.getIterationIdsMap().get(execution.getParentId());
        SelectConditionStep baseQuery = this.dsl.select((SelectField)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).leftJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).where(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Object)squashTestCaseId)).and(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Object)squashIterationId)).and(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.notIn((Select)this.dsl.select((SelectField)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID).from((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM)));
        if (Objects.nonNull(squashDatasetId)) {
            return (Long)baseQuery.and(Tables.ITERATION_TEST_PLAN_ITEM.DATASET_ID.eq((Object)squashDatasetId)).fetchOneInto(Long.class);
        }
        return (Long)baseQuery.fetchOneInto(Long.class);
    }

    private Long findTestPlanItemIdForTestSuite(ExecutionToImport execution, PivotImportMetadata pivotImportMetadata) {
        Long squashTestCaseId = pivotImportMetadata.getTestCaseIdsMap().get(execution.getTestCaseId());
        Long squashDatasetId = pivotImportMetadata.getDatasetIdsMap().get(execution.getDatasetId());
        Long squashSuiteId = pivotImportMetadata.getTestSuiteIdsMap().get(execution.getParentId()).id();
        SelectConditionStep baseQuery = this.dsl.select((SelectField)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).where(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Object)squashTestCaseId)).and(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Object)squashSuiteId));
        if (Objects.nonNull(squashDatasetId)) {
            return (Long)baseQuery.and(Tables.ITERATION_TEST_PLAN_ITEM.DATASET_ID.eq((Object)squashDatasetId)).fetchOneInto(Long.class);
        }
        return (Long)baseQuery.fetchOneInto(Long.class);
    }

    private Map<Long, Long> findReferencedTestStepIdForExecutionStepIds(List<Long> executionStepIds) {
        return this.dsl.select((SelectField)Tables.EXECUTION_STEP.TEST_STEP_ID, (SelectField)Tables.EXECUTION_STEP.EXECUTION_STEP_ID).from((TableLike)Tables.EXECUTION_STEP).where(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.in(executionStepIds)).fetchMap((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, (Field)Tables.EXECUTION_STEP.TEST_STEP_ID);
    }

    static final /* synthetic */ String getComment_aroundBody0(ExecutionWorkspacePivotImporterServiceImpl executionWorkspacePivotImporterServiceImpl, ExecutionToImport executionToImport, JoinPoint joinPoint) {
        return executionToImport.getComment();
    }

    static final /* synthetic */ String getComment_aroundBody2(ExecutionWorkspacePivotImporterServiceImpl executionWorkspacePivotImporterServiceImpl, ExecutionStepInfo executionStepInfo, JoinPoint joinPoint) {
        return executionStepInfo.getComment();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ExecutionWorkspacePivotImporterServiceImpl.java", ExecutionWorkspacePivotImporterServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getComment", "org.squashtest.tm.service.internal.dto.projectimporter.campaignworkspace.ExecutionToImport", "", "", "", "java.lang.String"), 665);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getComment", "org.squashtest.tm.service.internal.dto.projectimporter.campaignworkspace.ExecutionStepInfo", "", "", "", "java.lang.String"), 739);
    }
}

