/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.attachment.UploadedData;
import org.squashtest.tm.service.internal.dto.projectimporter.AttachmentToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.ImportWarningEntry;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.AttachmentHolderInfo;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.AttachmentPivotImportService;

@Service(value="AttachmentPivotImportService")
public class AttachmentPivotImportServiceImpl
implements AttachmentPivotImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentPivotImportService.class);
    private static final String ATTACHMENT_DIR = "attachments";
    private static final String TEST_CASES_DIR = "test_cases";
    private static final String TEST_CASE_FOLDERS_DIR = "test_case_folders";
    private static final String REQUIREMENTS_DIR = "requirements";
    private static final String REQUIREMENT_FOLDERS_DIR = "requirement_folders";
    private static final String CAMPAIGNS_DIR = "campaigns";
    private static final String CAMPAIGN_FOLDERS_DIR = "campaign_folders";
    private static final String ITERATIONS_DIR = "iterations";
    private static final String TEST_SUITES_DIR = "test_suites";
    private static final String EXECUTIONS_DIR = "executions";
    private static final String PATH_SEPARATOR = "/";
    private final AttachmentManagerService attachmentManagerService;

    public AttachmentPivotImportServiceImpl(AttachmentManagerService attachmentManagerService) {
        this.attachmentManagerService = attachmentManagerService;
    }

    @Override
    public void addAttachmentsToEntity(List<AttachmentToImport> attachments, AttachmentHolderInfo holderInfo, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) throws IOException {
        File importFile = new File(pivotFormatImport.getFilePath());
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (ZipFile zipFile = new ZipFile(importFile);){
                for (AttachmentToImport attachment : attachments) {
                    this.addAttachmentToEntity(attachment, holderInfo, zipFile, pivotFormatImport, pivotImportMetadata);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            LOGGER.error("Could not open zip file to find attachments", (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addAttachmentToEntity(AttachmentToImport attachment, AttachmentHolderInfo holderInfo, ZipFile zipFile, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) throws IOException {
        String attachmentPath = this.getAttachmentPathByHolderType(attachment, holderInfo);
        ZipEntry entry = zipFile.getEntry(attachmentPath);
        if (Objects.isNull(entry)) {
            PivotFormatLoggerHelper.handleAttachmentNotFound(LOGGER, attachmentPath, holderInfo, pivotFormatImport, pivotImportMetadata);
            return;
        }
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try {
                InputStream zipFileInputStream = zipFile.getInputStream(entry);
                try {
                    try (InputStream convertedInputStream = this.convertZipInputStreamToByteArrayInputStream(zipFileInputStream);){
                        EntityReference permissionOwner = this.getEntityReferenceForHolderType(holderInfo);
                        UploadedData data = new UploadedData(convertedInputStream, attachment.getOriginalFileName(), entry.getSize());
                        this.checkAttachmentType(data, holderInfo, pivotImportMetadata.getAttachmentTypeWhiteList(), pivotFormatImport);
                        this.checkAttachmentMaxSize(data, pivotImportMetadata.getMaxAttachmentSize(), holderInfo, pivotFormatImport);
                        this.attachmentManagerService.addAttachment(holderInfo.attachmentListId(), data, permissionOwner, holderInfo.holderType());
                    }
                    if (zipFileInputStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (zipFileInputStream == null) throw throwable;
                    zipFileInputStream.close();
                    throw throwable;
                }
                zipFileInputStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Import {} - Could not add attachment \"{}\" for entity type {}", new Object[]{pivotFormatImport.getId(), attachment.getZipImportFileName(), holderInfo.holderType(), ex});
            pivotImportMetadata.getImportWarningEntries().add(new ImportWarningEntry(holderInfo.holderType(), ex.getMessage()));
        }
    }

    private InputStream convertZipInputStreamToByteArrayInputStream(InputStream zipFileInputStream) throws IOException {
        byte[] bytes = zipFileInputStream.readAllBytes();
        return new ByteArrayInputStream(bytes);
    }

    private void checkAttachmentType(UploadedData data, AttachmentHolderInfo holderInfo, List<String> attachmentWhiteList, PivotFormatImport pivotFormatImport) {
        String fileType = FilenameUtils.getExtension((String)data.getName());
        boolean isAllowed = attachmentWhiteList.stream().anyMatch(type -> type.equalsIgnoreCase(fileType));
        if (!isAllowed) {
            PivotFormatLoggerHelper.handleAttachmentTypeNotAllowed(LOGGER, fileType, data.getName(), holderInfo, pivotFormatImport);
        }
    }

    private void checkAttachmentMaxSize(UploadedData data, Long maxAllowedSize, AttachmentHolderInfo holderInfo, PivotFormatImport pivotFormatImport) {
        if (data.getSizeInBytes() > maxAllowedSize) {
            PivotFormatLoggerHelper.handleAttachmentMaxSizeExceeded(LOGGER, data.getName(), data.getSizeInBytes(), maxAllowedSize, holderInfo, pivotFormatImport);
        }
    }

    private EntityReference getEntityReferenceForHolderType(AttachmentHolderInfo holderInfo) {
        if (EntityType.ACTION_TEST_STEP.equals((Object)holderInfo.holderType())) {
            return new EntityReference(EntityType.TEST_CASE, holderInfo.ownerId());
        }
        if (EntityType.EXECUTION_STEP.equals((Object)holderInfo.holderType())) {
            return new EntityReference(EntityType.EXECUTION, holderInfo.ownerId());
        }
        return new EntityReference(holderInfo.holderType(), holderInfo.ownerId());
    }

    private String getAttachmentPathByHolderType(AttachmentToImport attachment, AttachmentHolderInfo holderInfo) {
        String entityTypeDir = switch (holderInfo.holderType()) {
            case EntityType.TEST_CASE_FOLDER -> TEST_CASE_FOLDERS_DIR;
            case EntityType.ACTION_TEST_STEP, EntityType.TEST_CASE -> TEST_CASES_DIR;
            case EntityType.REQUIREMENT_FOLDER -> REQUIREMENT_FOLDERS_DIR;
            case EntityType.REQUIREMENT -> REQUIREMENTS_DIR;
            case EntityType.CAMPAIGN_FOLDER -> CAMPAIGN_FOLDERS_DIR;
            case EntityType.CAMPAIGN -> CAMPAIGNS_DIR;
            case EntityType.ITERATION -> ITERATIONS_DIR;
            case EntityType.TEST_SUITE -> TEST_SUITES_DIR;
            case EntityType.EXECUTION, EntityType.EXECUTION_STEP -> EXECUTIONS_DIR;
            default -> throw new IllegalArgumentException("This entity type is not handled " + holderInfo.holderType());
        };
        return "attachments/" + entityTypeDir + PATH_SEPARATOR + attachment.getZipImportFileName();
    }
}

