/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.milestone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneRange;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.internal.display.dto.BindableProjectToMilestoneDto;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.milestone.MilestoneBindingManagerService;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.service.project.CustomProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;

@Transactional
@Service(value="squashtest.tm.service.MilestoneBindingManagerService")
public class CustomMilestoneBindingServiceImpl
implements MilestoneBindingManagerService {
    private static final String MILESTONE_UNBINDING_UPDATING_AUDITABLE_MESSAGE = "Milestone unbinding: updating auditable milestone {}";
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomMilestoneBindingServiceImpl.class);
    @Inject
    private MilestoneDao milestoneDao;
    @Inject
    private MilestoneDisplayDao milestoneDisplayDao;
    @Inject
    private GenericProjectDao projectDao;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private AuditModificationService auditModificationService;
    @Inject
    private CustomProjectFinder customProjectFinder;
    @Inject
    private MilestoneManagerService milestoneManagerService;

    @Override
    public List<Milestone> getAllBindableMilestoneForProject(long projectId) {
        List<Milestone> milestoneBoundToProject = this.getAllBindedMilestoneForProject(projectId);
        List allMilestones = this.milestoneDao.findAll();
        allMilestones.removeAll(milestoneBoundToProject);
        GenericProject project = (GenericProject)this.projectDao.getReferenceById(projectId);
        return this.getMilestoneYouCanSee(allMilestones, project);
    }

    private List<Milestone> getMilestoneYouCanSee(List<Milestone> allMilestones, GenericProject project) {
        ArrayList<Milestone> filtered = new ArrayList();
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            filtered = allMilestones;
        } else {
            for (Milestone milestone : allMilestones) {
                if (this.isRestricted(milestone) && !this.isCreatedBySelf(milestone) && !milestone.isInPerimeter(project)) continue;
                filtered.add(milestone);
            }
        }
        return filtered;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_MILESTONE')  or hasRole('ROLE_ADMIN')")
    public void bindMilestonesToProject(List<Long> milestoneIds, long projectId) {
        this.milestoneManagerService.checkIfCanManageMilestonesOrAdmin(milestoneIds);
        this.doBindMilestonesToProject(milestoneIds, projectId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_MILESTONE')  or hasRole('ROLE_ADMIN')")
    public void bindNewMilestonesToProject(List<Long> milestoneIds, long projectId) {
        this.doBindMilestonesToProject(milestoneIds, projectId);
    }

    private void doBindMilestonesToProject(List<Long> milestoneIds, long projectId) {
        GenericProject project = (GenericProject)this.projectDao.getReferenceById(projectId);
        List<Milestone> milestones = this.milestoneDao.findAllByIdAndStatusNotLocked(milestoneIds);
        project.bindMilestones(milestones);
        for (Milestone milestone : milestones) {
            milestone.addProjectToPerimeter(project);
            LOGGER.debug("Milestone binding: updating auditable milestone {}", new Object[]{milestone.getId()});
            this.auditModificationService.updateAuditable((AuditableMixin)milestone);
        }
        LOGGER.debug("Milestone binding: updating auditable project {}", new Object[]{projectId});
        this.auditModificationService.updateAuditable((AuditableMixin)project);
    }

    @Override
    public void bindProjectsToMilestone(List<Long> projectIds, long milestoneId) {
        this.milestoneManagerService.verifyCanEditMilestone(milestoneId);
        List projects = this.projectDao.findAllById(projectIds);
        Milestone milestone = (Milestone)this.milestoneDao.getReferenceById(milestoneId);
        milestone.bindProjects(projects);
        milestone.addProjectsToPerimeter(projects);
        LOGGER.debug("Milestone binding: updating auditable milestone {}", new Object[]{milestoneId});
        this.auditModificationService.updateAuditable((AuditableMixin)milestone);
        LOGGER.debug("Milestone binding: updating multiple auditable projects", new Object[0]);
        projects.forEach(project -> this.auditModificationService.updateAuditable((AuditableMixin)project));
    }

    @Override
    public List<Milestone> getAllBindedMilestoneForProject(long projectId) {
        GenericProject project = (GenericProject)this.projectDao.getReferenceById(projectId);
        return project.getMilestones();
    }

    @Override
    public List<BindableProjectToMilestoneDto> getAllBindableProjectForMilestone(long milestoneId) {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List<Long> allMilestoneManageableProjectIds = this.customProjectFinder.findAllMilestoneManageableIds(currentUser);
        if (!currentUser.isAdmin()) {
            if (allMilestoneManageableProjectIds.isEmpty()) {
                throw new AccessDeniedException(HttpStatus.FORBIDDEN.getReasonPhrase());
            }
            this.milestoneDisplayDao.checkIfAllMilestoneAreGlobalOrInOneManageableProjectPerimeterOrOwner(Collections.singletonList(milestoneId), allMilestoneManageableProjectIds, currentUser.getUserId());
        }
        return this.milestoneDao.findBindableProjectByMilestoneId(milestoneId, allMilestoneManageableProjectIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_MILESTONE')  or hasRole('ROLE_ADMIN')")
    public void unbindMilestonesFromProject(List<Long> milestoneIds, long projectId) {
        this.milestoneManagerService.checkIfCanManageMilestonesOrAdmin(milestoneIds);
        GenericProject project = (GenericProject)this.projectDao.getReferenceById(projectId);
        List milestones = this.milestoneDao.findAllById(milestoneIds);
        this.unbindMilestonesFromProject(project, milestones);
    }

    private void unbindMilestonesFromProject(GenericProject project, List<Milestone> milestones) {
        project.unbindMilestones(milestones);
        LOGGER.debug("Milestone unbinding: updating auditable project {}", new Object[]{project.getId()});
        this.auditModificationService.updateAuditable((AuditableMixin)project);
        for (Milestone milestone : milestones) {
            milestone.removeProjectFromPerimeter(project);
            LOGGER.debug(MILESTONE_UNBINDING_UPDATING_AUDITABLE_MESSAGE, new Object[]{milestone.getId()});
            this.auditModificationService.updateAuditable((AuditableMixin)milestone);
        }
        for (Milestone milestone : milestones) {
            this.milestoneDao.unbindAllObjectsForProject(milestone.getId(), project.getId());
        }
        this.milestoneDao.removeProjectFromAllPerimeters(project.getId());
    }

    @Override
    public void unbindAllMilestonesFromProject(@NotNull GenericProject project) {
        GenericProject genericProject = project;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)genericProject);
        this.unbindMilestonesFromProject(project, project.getMilestones());
    }

    @Override
    public void unbindProjectsFromMilestone(List<Long> projectIds, long milestoneId) {
        this.milestoneManagerService.verifyCanEditMilestone(milestoneId);
        Milestone milestone = (Milestone)this.milestoneDao.getReferenceById(milestoneId);
        List projects = this.projectDao.findAllById(projectIds);
        milestone.unbindProjects(projects);
        LOGGER.debug("Milestone unbinding: updating multiple auditable projects", new Object[0]);
        projects.forEach(project -> this.auditModificationService.updateAuditable((AuditableMixin)project));
        milestone.removeProjectsFromPerimeter(projects);
        LOGGER.debug(MILESTONE_UNBINDING_UPDATING_AUDITABLE_MESSAGE, new Object[]{milestone.getId()});
        this.auditModificationService.updateAuditable((AuditableMixin)milestone);
        this.milestoneDao.unbindAllObjectsForProjects(milestoneId, projectIds);
    }

    @Override
    public List<Milestone> getAllBindableMilestoneForProject(long projectId, String type) {
        List<Milestone> milestones = this.getAllBindableMilestoneForProject(projectId);
        return this.removeNonBindableStatus(this.filterByType(milestones, type));
    }

    private List<Milestone> removeNonBindableStatus(List<Milestone> milestones) {
        ArrayList<Milestone> filtered = new ArrayList<Milestone>();
        for (Milestone milestone : milestones) {
            if (!milestone.getStatus().isBindableToProject()) continue;
            filtered.add(milestone);
        }
        return filtered;
    }

    private List<Milestone> filterByType(List<Milestone> milestones, String type) {
        List<Milestone> filtered = "global".equals(type) ? this.getGlobalMilestones(milestones) : ("personal".equals(type) ? this.getMilestoneCreatedBySelf(milestones) : this.getOtherMilestones(milestones));
        return filtered;
    }

    private List<Milestone> getOtherMilestones(List<Milestone> milestones) {
        ArrayList<Milestone> filtered = new ArrayList<Milestone>();
        for (Milestone milestone : milestones) {
            if (!this.isRestricted(milestone) || this.isCreatedBySelf(milestone)) continue;
            filtered.add(milestone);
        }
        return filtered;
    }

    private List<Milestone> getMilestoneCreatedBySelf(List<Milestone> milestones) {
        ArrayList<Milestone> filtered = new ArrayList<Milestone>();
        for (Milestone milestone : milestones) {
            if (!this.isRestricted(milestone) || !this.isCreatedBySelf(milestone)) continue;
            filtered.add(milestone);
        }
        return filtered;
    }

    private boolean isRestricted(Milestone milestone) {
        boolean isRestricted = false;
        if (milestone.getRange() == MilestoneRange.RESTRICTED) {
            isRestricted = true;
        }
        return isRestricted;
    }

    private boolean isCreatedBySelf(Milestone milestone) {
        boolean isCreatedBySelf = false;
        String myName = UserContextHolder.getUsername();
        if (myName.equals(milestone.getOwner().getLogin())) {
            isCreatedBySelf = true;
        }
        return isCreatedBySelf;
    }

    private List<Milestone> getGlobalMilestones(List<Milestone> milestones) {
        ArrayList<Milestone> filtered = new ArrayList<Milestone>();
        for (Milestone milestone : milestones) {
            if (milestone.getRange() != MilestoneRange.GLOBAL) continue;
            filtered.add(milestone);
        }
        return filtered;
    }

    @Override
    public void unbindProjectsFromMilestoneKeepInPerimeter(List<Long> projectIds, long milestoneId) {
        this.milestoneManagerService.verifyCanEditMilestone(milestoneId);
        Milestone milestone = (Milestone)this.milestoneDao.getReferenceById(milestoneId);
        List projects = this.projectDao.findAllById(projectIds);
        milestone.unbindProjects(projects);
        LOGGER.debug(MILESTONE_UNBINDING_UPDATING_AUDITABLE_MESSAGE, new Object[]{milestone.getId()});
        this.auditModificationService.updateAuditable((AuditableMixin)milestone);
        LOGGER.debug("Milestone unbinding: updating multiple auditable project", new Object[0]);
        projects.forEach(project -> this.auditModificationService.updateAuditable((AuditableMixin)project));
        this.milestoneDao.unbindAllObjectsForProjects(milestoneId, projectIds);
    }

    @Override
    public void unbindTemplateFrom(long milestoneId) {
        Milestone milestone = (Milestone)this.milestoneDao.getReferenceById(milestoneId);
        milestone.removeTemplates();
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_MILESTONE')  or hasRole('ROLE_ADMIN')")
    public void bindMilestonesToProjectAndBindObject(long projectId, List<Long> milestoneIds) {
        this.bindMilestonesToProject(milestoneIds, projectId);
        this.doBindMilestonesToProjectAndBindObject(projectId, milestoneIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_MILESTONE')  or hasRole('ROLE_ADMIN')")
    public void bindNewMilestonesToProjectAndBindObject(long projectId, List<Long> milestoneIds) {
        this.bindNewMilestonesToProject(milestoneIds, projectId);
        this.doBindMilestonesToProjectAndBindObject(projectId, milestoneIds);
    }

    private void doBindMilestonesToProjectAndBindObject(long projectId, List<Long> milestoneIds) {
        for (Long milestoneId : milestoneIds) {
            this.milestoneDao.bindMilestoneToProjectTestCases(projectId, milestoneId);
            this.milestoneDao.bindMilestoneToProjectRequirementVersions(projectId, milestoneId);
        }
    }
}

