/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.milestone.MilestoneHolder;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementFolderSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestLibrary;
import org.squashtest.tm.service.campaign.SprintManagerService;
import org.squashtest.tm.service.infolist.InfoListItemManagerService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.repository.IssueDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderSyncExtenderDao;
import org.squashtest.tm.service.internal.repository.RequirementSyncExtenderDao;
import org.squashtest.tm.service.internal.repository.SprintGroupDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryNodeDao;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;

@Component
public class TreeNodeUpdater
implements NodeVisitor {
    @Inject
    private PrivateCustomFieldValueService privateCustomFieldValueService;
    @Inject
    private TestCaseModificationService testcaseService;
    @Inject
    private IssueDao issueDao;
    @Inject
    private SprintManagerService sprintManagerService;
    @Inject
    private SprintGroupDao sprintGroupDao;
    @Inject
    private InfoListItemManagerService infoListItemService;
    @Inject
    private MilestoneManagerService milestoneService;
    @Inject
    private RequirementSyncExtenderDao syncreqDao;
    @Inject
    private RequirementFolderSyncExtenderDao requirementFolderSyncExtenderDao;
    @Inject
    private TestCaseLibraryNodeDao testCaseLibraryNodeDao;

    public void visit(CampaignFolder campaignFolder) {
        this.updateCustomFields((BoundEntity)campaignFolder);
    }

    public void visit(RequirementFolder requirementFolder) {
        this.stripFolderSyncExtender(requirementFolder);
        this.updateCustomFields((BoundEntity)requirementFolder);
    }

    public void visit(TestCaseFolder testCaseFolder) {
        this.updateCustomFields((BoundEntity)testCaseFolder);
    }

    public void visit(Campaign campaign) {
        this.updateCustomFields((BoundEntity)campaign);
        this.updateMilestones((MilestoneHolder)campaign);
    }

    public void visit(Iteration iteration) {
        this.updateCustomFields((BoundEntity)iteration);
        List<Issue> issues = this.issueDao.findAllForIteration(iteration.getId());
        this.updateIssues(issues, iteration.getProject());
    }

    public void visit(TestSuite testSuite) {
        this.updateCustomFields((BoundEntity)testSuite);
        this.updateIssues(this.issueDao.findAllForTestSuite(testSuite.getId()), testSuite.getProject());
    }

    public void visit(Sprint sprint) {
        this.updateCustomFields((BoundEntity)sprint);
        List<Issue> issues = this.issueDao.findAllForSprint(sprint.getId());
        this.updateIssues(issues, sprint.getProject());
        sprint.migrateTestPlans();
        this.removeSprintSynchronisation(sprint);
    }

    public void visit(SprintGroup sprintGroup) {
        this.updateCustomFields((BoundEntity)sprintGroup);
        this.removeRemoteSynchronisationId(sprintGroup);
    }

    public void visit(Requirement requirement) {
        for (RequirementVersion version : requirement.getRequirementVersions()) {
            this.updateCustomFields((BoundEntity)version);
            this.updateCategory(version);
            this.updateMilestones((MilestoneHolder)version);
        }
        this.stripSyncExtender(requirement);
    }

    public void visit(HighLevelRequirement highLevelRequirement) {
        for (RequirementVersion version : highLevelRequirement.getRequirementVersions()) {
            this.updateCustomFields((BoundEntity)version);
            this.updateCategory(version);
            this.updateMilestones((MilestoneHolder)version);
        }
        this.stripSyncExtender((Requirement)highLevelRequirement);
    }

    public void visit(TestCase testCase) {
        this.updateCustomFields((BoundEntity)testCase);
        this.updateMilestones((MilestoneHolder)testCase);
        TestStepVisitor visitor = new TestStepVisitor(){

            public void visit(CallTestStep visited) {
            }

            public void visit(ActionTestStep visited) {
                TreeNodeUpdater.this.updateCustomFields((BoundEntity)visited);
            }

            public void visit(KeywordTestStep visited) {
            }
        };
        for (TestStep step : testCase.getSteps()) {
            step.accept(visitor);
        }
        this.updateAutomationParams(testCase);
        this.updateNatureAndType(testCase);
        this.updateAutomationRequests(testCase);
    }

    public void updateCustomFields(BoundEntity entity) {
        this.privateCustomFieldValueService.migrateCustomFieldValues(entity);
    }

    public void updateIssues(List<Issue> issues, Project project) {
        for (Issue issue : issues) {
            if (project == null || project.isBoundToBugtracker() && issue.getBugtracker().getId().equals(project.getBugTracker().getId())) continue;
            this.issueDao.delete(issue);
        }
    }

    public void updateAutomationParams(TestCase testCase) {
        TestAutomationProject newTAProject;
        boolean couldConvert = false;
        AutomatedTest formerTATest = testCase.getAutomatedTest();
        if (formerTATest != null && (newTAProject = testCase.getProject().findTestAutomationProjectByJob(formerTATest.getProject())) != null) {
            this.testcaseService.bindAutomatedTest(testCase.getId(), newTAProject.getId(), formerTATest.getName());
            couldConvert = true;
        }
        if (!couldConvert) {
            testCase.removeAutomatedScript();
        }
    }

    private void updateNatureAndType(TestCase testCase) {
        Project project = testCase.getProject();
        InfoListItem nature = testCase.getNature();
        InfoListItem type = testCase.getType();
        if (!this.infoListItemService.isNatureConsistent(project.getId(), nature.getCode())) {
            testCase.setNature(project.getTestCaseNatures().getDefaultItem());
        }
        if (!this.infoListItemService.isTypeConsistent(project.getId(), type.getCode())) {
            testCase.setType(project.getTestCaseTypes().getDefaultItem());
        }
    }

    private void updateAutomationRequests(TestCase testCase) {
        if (testCase.getAutomationRequest() != null) {
            Project project = testCase.getProject();
            AutomationRequest request = testCase.getAutomationRequest();
            AutomationRequestLibrary formerLibrary = request.getLibrary();
            AutomationRequestLibrary newLibrary = project.getAutomationRequestLibrary();
            formerLibrary.removeContent(request);
            this.testCaseLibraryNodeDao.flush();
            newLibrary.addContent(request);
            request.notifyAssociatedWithProject(project);
        }
    }

    private void updateCategory(RequirementVersion requirement) {
        Project project = requirement.getProject();
        InfoListItem category = requirement.getCategory();
        if (!this.infoListItemService.isCategoryConsistent(project.getId(), category.getCode())) {
            requirement.updateCategoryWhithoutCheck(project.getRequirementCategories().getDefaultItem());
        }
    }

    private void updateMilestones(MilestoneHolder element) {
        this.milestoneService.migrateMilestones(element);
    }

    private void removeSprintSynchronisation(Sprint sprint) {
        if (sprint.isSynchronized()) {
            this.sprintManagerService.deleteSprintSynchronisation(sprint.getId());
        }
    }

    private void removeRemoteSynchronisationId(SprintGroup sprintGroup) {
        if (sprintGroup.isSynchronized()) {
            this.sprintGroupDao.updateRemoteSyncId(sprintGroup.getId(), null);
        }
    }

    private void stripSyncExtender(Requirement req) {
        if (req.isSynchronized()) {
            RequirementSyncExtender extender = req.getSyncExtender();
            req.removeSyncExtender();
            this.syncreqDao.delete(extender);
        }
    }

    private void stripFolderSyncExtender(RequirementFolder requirementFolder) {
        if (requirementFolder.isSynchronized()) {
            RequirementFolderSyncExtender extender = requirementFolder.getRequirementFolderSyncExtender();
            requirementFolder.setRequirementFolderSyncExtender(null);
            this.requirementFolderSyncExtenderDao.delete(extender);
        }
    }
}

