/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;

@Service(value="squashtest.tm.service.PathHeaderService")
public class EntityPathHeaderServiceImpl
implements EntityPathHeaderService {
    private final EntityPathHeaderDao entityPathHeaderDao;

    public EntityPathHeaderServiceImpl(EntityPathHeaderDao entityPathHeaderDao) {
        this.entityPathHeaderDao = entityPathHeaderDao;
    }

    @Override
    @PreAuthorize(value="hasPermission(#tclnId, 'org.squashtest.tm.domain.testcase.TestCaseLibraryNode', 'READ') or hasRole('ROLE_ADMIN') or hasRole('ROLE_TA_API_CLIENT')")
    public String buildTCLNPathHeader(Long tclnId) {
        return this.entityPathHeaderDao.buildTestCaseLibraryNodePathHeader(tclnId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#rlnId, 'org.squashtest.tm.domain.requirement.RequirementLibraryNode', 'READ') or hasRole('ROLE_ADMIN')")
    public String buildRLNPathHeader(Long rlnId) {
        return this.entityPathHeaderDao.buildRequirementLibraryNodePathHeader(rlnId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#clnId, 'org.squashtest.tm.domain.campaign.CampaignLibraryNode', 'READ') or hasRole('ROLE_ADMIN')")
    public String buildCLNPathHeader(Long clnId) {
        return this.entityPathHeaderDao.buildCampaignLibraryNodePathHeader(clnId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration' , 'READ') or hasRole('ROLE_ADMIN') or hasRole('ROLE_TA_API_CLIENT')")
    public String buildIterationPathHeader(Long iterationId) {
        return this.entityPathHeaderDao.buildIterationPathHeader(iterationId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testSuiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'READ') or hasRole('ROLE_ADMIN') or hasRole('ROLE_TA_API_CLIENT')")
    public String buildTestSuitePathHeader(Long testSuiteId) {
        return this.entityPathHeaderDao.buildTestSuitePathHeader(testSuiteId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#executionId, 'org.squashtest.tm.domain.execution.Execution', 'READ') or hasRole('ROLE_ADMIN')")
    public String buildExecutionPathHeader(Long executionId) {
        return this.entityPathHeaderDao.buildExecutionPathHeader(executionId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sessionOverviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview', 'READ') or hasRole('ROLE_ADMIN')")
    public String buildExploratorySessionOverviewPathHeader(Long sessionOverviewId) {
        return this.entityPathHeaderDao.buildExploratorySessionOverviewPathHeader(sessionOverviewId);
    }
}

