/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.infolist;

import java.util.Collection;
import javax.inject.Inject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.exception.project.LockedParameterException;
import org.squashtest.tm.service.infolist.InfoListBindingManagerService;
import org.squashtest.tm.service.internal.project.ProjectHelper;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.InfoListDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;

@Transactional
@Service(value="squashtest.tm.service.InfoListBindingManagerService")
public class InfoListBindingManagerServiceImpl
implements InfoListBindingManagerService {
    @Inject
    private GenericProjectDao genericProjectDao;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private InfoListDao infoListDao;

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void bindListToProjectReqCategory(long infoListId, long projectId) {
        GenericProject project = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        this.checkIfParameterIsModifiable(project);
        InfoList infoList = (InfoList)this.infoListDao.getReferenceById(infoListId);
        InfoListItem defaultItem = infoList.getDefaultItem();
        project.setRequirementCategories(infoList);
        this.infoListDao.setDefaultCategoryForProject(projectId, defaultItem);
        if (ProjectHelper.isTemplate(project)) {
            Collection<Project> boundProjects = this.projectDao.findAllBoundToTemplate(projectId);
            for (Project boundProject : boundProjects) {
                boundProject.setRequirementCategories(infoList);
                this.infoListDao.setDefaultCategoryForProject(boundProject.getId(), defaultItem);
            }
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void bindListToProjectTcNature(long infoListId, long projectId) {
        GenericProject project = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        this.checkIfParameterIsModifiable(project);
        InfoList infoList = (InfoList)this.infoListDao.getReferenceById(infoListId);
        InfoListItem defaultItem = infoList.getDefaultItem();
        project.setTestCaseNatures(infoList);
        this.infoListDao.setDefaultNatureForProject(projectId, defaultItem);
        if (ProjectHelper.isTemplate(project)) {
            Collection<Project> boundProjects = this.projectDao.findAllBoundToTemplate(projectId);
            for (Project boundProject : boundProjects) {
                boundProject.setTestCaseNatures(infoList);
                this.infoListDao.setDefaultNatureForProject(boundProject.getId(), defaultItem);
            }
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void bindListToProjectTcType(long infoListId, long projectId) {
        GenericProject project = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        this.checkIfParameterIsModifiable(project);
        InfoList infoList = (InfoList)this.infoListDao.getReferenceById(infoListId);
        InfoListItem defaultItem = infoList.getDefaultItem();
        project.setTestCaseTypes(infoList);
        this.infoListDao.setDefaultTypeForProject(projectId, defaultItem);
        if (ProjectHelper.isTemplate(project)) {
            Collection<Project> boundProjects = this.projectDao.findAllBoundToTemplate(projectId);
            for (Project boundProject : boundProjects) {
                boundProject.setTestCaseTypes(infoList);
                this.infoListDao.setDefaultTypeForProject(boundProject.getId(), defaultItem);
            }
        }
    }

    private void checkIfParameterIsModifiable(GenericProject genericProject) {
        if (genericProject.isBoundToTemplate()) {
            throw new LockedParameterException();
        }
    }
}

