/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.execution;

import java.util.Collections;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.exception.UnknownEntityException;
import org.squashtest.tm.service.execution.SessionNoteService;
import org.squashtest.tm.service.internal.repository.SessionNoteDao;
import org.squashtest.tm.service.internal.repository.display.SessionNoteDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;

@Service
@Transactional(readOnly=true)
public class SessionNoteServiceImpl
implements SessionNoteService {
    private final SessionNoteDisplayDao sessionNoteDisplayDao;
    private final SessionNoteDao sessionNoteDao;
    private final PermissionEvaluationService permissionService;
    @PersistenceContext
    private EntityManager em;

    public SessionNoteServiceImpl(SessionNoteDisplayDao sessionNoteDisplayDao, SessionNoteDao sessionNoteDao, PermissionEvaluationService permissionService) {
        this.sessionNoteDisplayDao = sessionNoteDisplayDao;
        this.sessionNoteDao = sessionNoteDao;
        this.permissionService = permissionService;
    }

    @Override
    public Project findProjectBySessionNoteId(long noteId) {
        this.checkReadExecutionPermission(noteId);
        Long projectId = this.sessionNoteDisplayDao.findProjectIdBySessionNoteId(noteId);
        if (projectId == null) {
            throw new UnknownEntityException(noteId, SessionNote.class);
        }
        return (Project)this.em.find(Project.class, (Object)projectId);
    }

    @Override
    public SessionNote findSessionNoteById(long noteId) {
        this.checkReadExecutionPermission(noteId);
        return (SessionNote)this.em.find(SessionNote.class, (Object)noteId);
    }

    private void checkReadExecutionPermission(long noteId) {
        Long executionId = this.sessionNoteDao.findExploratoryExecutionId(noteId);
        PermissionsUtils.checkPermission(this.permissionService, Collections.singletonList(executionId), Permissions.READ.name(), Execution.class.getName());
    }
}

