/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.executioncomparator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.squashtest.tm.jooq.domain.tables.AutomatedSuite;
import org.squashtest.tm.jooq.domain.tables.Execution;
import org.squashtest.tm.service.internal.dto.executioncomparator.TestExecutionInfo;

public class TestExecutionInfoMapper
implements RecordMapper<Record, TestExecutionInfo> {
    public TestExecutionInfo map(Record record) {
        TestExecutionInfo testExecutionInfo = new TestExecutionInfo();
        testExecutionInfo.setTestId((Long)record.get((Field)Execution.EXECUTION.TCLN_ID));
        testExecutionInfo.setTestName((String)record.get((Field)Execution.EXECUTION.NAME));
        testExecutionInfo.setDataset((String)record.get((Field)Execution.EXECUTION.DATASET_LABEL));
        HashMap<String, String> statusBySuite = new HashMap<String, String>();
        statusBySuite.put((String)record.get((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID), (String)record.get((Field)Execution.EXECUTION.EXECUTION_STATUS));
        testExecutionInfo.setStatusBySuite(statusBySuite);
        return testExecutionInfo;
    }

    public static List<TestExecutionInfo> aggregate(List<TestExecutionInfo> testExecutionInfos) {
        HashMap<String, TestExecutionInfo> filter = new HashMap<String, TestExecutionInfo>();
        for (TestExecutionInfo testInfo : testExecutionInfos) {
            String key = testInfo.getTestId() + "-" + testInfo.getDataset();
            filter.putIfAbsent(key, testInfo);
            Map<String, String> statusBySuite = ((TestExecutionInfo)filter.get(key)).getStatusBySuite();
            testInfo.getStatusBySuite().forEach((statusKey, statusValue) -> {
                String string = statusBySuite.merge((String)statusKey, (String)statusValue, (oldValue, newValue) -> oldValue);
            });
        }
        return new ArrayList<TestExecutionInfo>(filter.values());
    }
}

