/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.testcase;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.PluginType;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.project.LibraryPluginBinding;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.display.requirements.RequirementPathFinderService;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.display.testcase.TestCasePathFinderService;
import org.squashtest.tm.service.display.testcase.exploratory.session.TestCaseExploratorySessionsDisplayService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.TestCaseKnownIssueFinder;
import org.squashtest.tm.service.internal.display.dto.AutomationRequestDto;
import org.squashtest.tm.service.internal.display.dto.RequirementVersionCoverageDto;
import org.squashtest.tm.service.internal.display.dto.requirement.DetailedStepViewRequirementVersionDto;
import org.squashtest.tm.service.internal.display.dto.testcase.AbstractTestStepDto;
import org.squashtest.tm.service.internal.display.dto.testcase.CalledTestCaseDto;
import org.squashtest.tm.service.internal.display.dto.testcase.DataSetDto;
import org.squashtest.tm.service.internal.display.dto.testcase.DatasetParamValueDto;
import org.squashtest.tm.service.internal.display.dto.testcase.ParameterDto;
import org.squashtest.tm.service.internal.display.dto.testcase.TestCaseDto;
import org.squashtest.tm.service.internal.display.dto.testcase.TestCaseFolderDto;
import org.squashtest.tm.service.internal.display.dto.testcase.TestCaseLibraryDto;
import org.squashtest.tm.service.internal.display.dto.testcase.TestCaseMultiSelectionDto;
import org.squashtest.tm.service.internal.display.testcase.parameter.TestCaseParameterOperationReport;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.AutomatedTestDisplayDao;
import org.squashtest.tm.service.internal.repository.display.AutomationRequestDisplayDao;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.DatasetDisplayDao;
import org.squashtest.tm.service.internal.repository.display.DatasetParamValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.ParameterDisplayDao;
import org.squashtest.tm.service.internal.repository.display.RequirementVersionCoverageDisplayDao;
import org.squashtest.tm.service.internal.repository.display.RequirementVersionDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TestCaseDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TestStepDisplayDao;
import org.squashtest.tm.service.internal.testcase.TestCaseCallTreeFinder;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.user.PartyPreferenceService;

@Service
@Transactional(readOnly=true)
public class TestCaseDisplayServiceImpl
implements TestCaseDisplayService {
    private static final String FINAL_STATE = "finalState";
    @Inject
    private TestCaseDisplayDao testCaseDisplayDao;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private MilestoneDisplayDao milestoneDisplayDao;
    @Inject
    private TestStepDisplayDao testStepDisplayDao;
    @Inject
    private CustomFieldValueDisplayDao customFieldValueDisplayDao;
    @Inject
    private AutomationRequestDisplayDao automationRequestDisplayDao;
    @Inject
    private ParameterDisplayDao parameterDisplayDao;
    @Inject
    private DatasetDisplayDao datasetDisplayDao;
    @Inject
    private DatasetParamValueDisplayDao datasetParamValueDisplayDao;
    @Inject
    private RequirementVersionCoverageDisplayDao requirementVersionCoverageDisplayDao;
    @Inject
    private RequirementVersionDisplayDao requirementVersionDisplayDao;
    @Inject
    private TestCaseCallTreeFinder testCaseCallTreeFinder;
    @Inject
    private AttachmentDisplayDao attachmentDisplayDao;
    @Inject
    private AutomatedTestDisplayDao automatedTestDisplayDao;
    @Inject
    private ExecutionDao executionDao;
    @Inject
    private UltimateLicenseAvailabilityService ultimateLicenseService;
    @Inject
    private CustomReportDashboardService customReportDashboardService;
    @Inject
    private PartyPreferenceService partyPreferenceService;
    @Inject
    private GenericProjectManagerService projectManager;
    @Inject
    private RequirementPathFinderService requirementsPathService;
    @Inject
    private TestCasePathFinderService testCasePathService;
    @Inject
    private TestCaseKnownIssueFinder testCaseKnownIssueFinder;
    @Inject
    private EntityPathHeaderService entityPathHeaderService;
    @Inject
    private TestCaseExploratorySessionsDisplayService testCaseExploratorySessionsDisplayService;

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.testcase.TestCaseLibrary' , 'READ') or hasRole('ROLE_ADMIN')")
    public TestCaseLibraryDto getTestCaseLibraryView(long libraryId) {
        TestCaseLibraryDto libraryDto = this.testCaseDisplayDao.getTestCaseLibraryDtoById(libraryId);
        libraryDto.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(libraryDto.getAttachmentListId()));
        this.appendFavoriteDashboardInformation(libraryDto);
        return libraryDto;
    }

    private void appendFavoriteDashboardInformation(TestCaseLibraryDto libraryDto) {
        libraryDto.setCanShowFavoriteDashboard(this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.TEST_CASE));
        libraryDto.setShouldShowFavoriteDashboard(this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.TEST_CASE));
        PartyPreference preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_TEST_CASE.getPreferenceKey());
        if (preference != null) {
            Long dashboardId = Long.valueOf(preference.getPreferenceValue());
            libraryDto.setFavoriteDashboardId(dashboardId);
        }
    }

    @Override
    public TestCaseMultiSelectionDto getTestCaseMultiView() {
        TestCaseMultiSelectionDto testCaseMultiSelectionDto = new TestCaseMultiSelectionDto();
        testCaseMultiSelectionDto.setCanShowFavoriteDashboard(this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.TEST_CASE));
        testCaseMultiSelectionDto.setShouldShowFavoriteDashboard(this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.TEST_CASE));
        PartyPreference preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_TEST_CASE.getPreferenceKey());
        if (preference != null) {
            Long dashboardId = Long.valueOf(preference.getPreferenceValue());
            testCaseMultiSelectionDto.setFavoriteDashboardId(dashboardId);
        }
        return testCaseMultiSelectionDto;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public TestCaseDto getTestCaseView(long testCaseId) {
        TestCaseDto testCase = this.testCaseDisplayDao.getTestCaseDtoById(testCaseId);
        testCase.setMilestones(this.milestoneDisplayDao.getMilestonesByTestCaseId(testCaseId));
        testCase.setTestSteps(this.testStepDisplayDao.getTestStepsByTestCase(testCaseId));
        testCase.setCustomFieldValues(this.customFieldValueDisplayDao.findCustomFieldValues(BindableEntity.TEST_CASE, testCaseId));
        AutomationRequestDto automationRequestDto = this.automationRequestDisplayDao.findByTestCaseId(testCaseId);
        testCase.setAutomationRequest(automationRequestDto);
        this.setParameterDatasetEntities(testCase);
        testCase.setAutomatedTest(this.automatedTestDisplayDao.findByTestCaseId(testCaseId));
        testCase.setCoverages(this.doFindCoverages(testCaseId));
        testCase.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(testCase.getAttachmentListId()));
        testCase.setNbIssues(this.testCaseKnownIssueFinder.countKnownIssues(testCaseId));
        testCase.setCalledTestCases(this.getCalledTestCases(testCaseId));
        testCase.setLastExecutionStatus(this.testCaseDisplayDao.getLastExecutionStatus(testCaseId, testCase.getExecutionMode()));
        testCase.setNbExecutions(this.executionDao.countByTestCaseId(testCaseId));
        testCase.setNbSessions(this.testCaseExploratorySessionsDisplayService.countExploratorySessionOverviewByTestCaseId(testCaseId));
        testCase.setActionWordLibraryActive(this.ultimateLicenseService.isAvailable());
        testCase.setConfiguredRemoteFinalStatus(this.getRemoteFinalStatus(testCase.getProjectId()));
        testCase.setPath(this.entityPathHeaderService.buildTCLNPathHeader(testCaseId));
        return testCase;
    }

    private String getRemoteFinalStatus(Long projectId) {
        LibraryPluginBinding lpb;
        String automationWorkflowTypeKey = this.projectDao.findAutomationWorkflowTypeByProjectId(projectId);
        if (automationWorkflowTypeKey.equals(AutomationWorkflowType.REMOTE_WORKFLOW.getI18nKey()) && (lpb = this.projectDao.findPluginForProject(projectId, PluginType.AUTOMATION)) != null) {
            Map<String, String> pluginConfiguration = this.projectManager.getPluginConfigurationWithoutCheck(projectId, WorkspaceType.TEST_CASE_WORKSPACE, lpb.getPluginId());
            return pluginConfiguration == null ? null : pluginConfiguration.get(FINAL_STATE);
        }
        return null;
    }

    private List<CalledTestCaseDto> getCalledTestCases(Long testCaseId) {
        List<CalledTestCaseDto> calledTestCaseDtoList = this.testCaseDisplayDao.getCallingTestCaseById(testCaseId);
        for (CalledTestCaseDto calledTestCase : calledTestCaseDtoList) {
            calledTestCase.setPath(this.testCasePathService.buildTestCasePath(calledTestCase.getId(), calledTestCase.getProjectName()));
        }
        return calledTestCaseDtoList;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseFolderId, 'org.squashtest.tm.domain.testcase.TestCaseFolder' , 'READ') or hasRole('ROLE_ADMIN')")
    public TestCaseFolderDto getTestCaseFolderView(long testCaseFolderId) {
        TestCaseFolderDto testCaseFolder = this.testCaseDisplayDao.getTestCaseFolderDtoById(testCaseFolderId);
        testCaseFolder.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(testCaseFolder.getAttachmentListId()));
        testCaseFolder.setCustomFieldValues(this.customFieldValueDisplayDao.findCustomFieldValues(BindableEntity.TESTCASE_FOLDER, testCaseFolderId));
        this.appendFavoriteDashboardInformation(testCaseFolder);
        testCaseFolder.setPath(this.entityPathHeaderService.buildTCLNPathHeader(testCaseFolderId));
        return testCaseFolder;
    }

    private void appendFavoriteDashboardInformation(TestCaseFolderDto requirementFolderDto) {
        requirementFolderDto.setCanShowFavoriteDashboard(this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.TEST_CASE));
        requirementFolderDto.setShouldShowFavoriteDashboard(this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.TEST_CASE));
        PartyPreference preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_TEST_CASE.getPreferenceKey());
        if (preference != null) {
            Long dashboardId = Long.valueOf(preference.getPreferenceValue());
            requirementFolderDto.setFavoriteDashboardId(dashboardId);
        }
    }

    private void setParameterDatasetEntities(TestCaseDto testCase) {
        List<ParameterDto> parameters = this.parameterDisplayDao.findAllByTestCaseId(testCase.getId());
        testCase.setParameters(parameters);
        List<DataSetDto> datasets = this.datasetDisplayDao.findAllByTestCaseId(testCase.getId());
        testCase.setDatasets(datasets);
        testCase.setDatasetParamValues(this.findDataSetParamValues(parameters, datasets));
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public List<RequirementVersionCoverageDto> findCoverages(Long testCaseId) {
        return this.doFindCoverages(testCaseId);
    }

    private List<RequirementVersionCoverageDto> doFindCoverages(Long testCaseId) {
        Set<Long> calledIds = this.testCaseCallTreeFinder.getTestCaseCallTree(testCaseId);
        List<RequirementVersionCoverageDto> requirementVersionCoverageDtoList = this.requirementVersionCoverageDisplayDao.findByTestCaseIds(testCaseId, calledIds);
        for (RequirementVersionCoverageDto requirement : requirementVersionCoverageDtoList) {
            requirement.setPath(this.requirementsPathService.buildRequirementLinkPath(requirement.getRequirementId(), requirement.getProjectName()));
        }
        return requirementVersionCoverageDtoList;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public TestCaseParameterOperationReport findParametersData(Long testCaseId) {
        TestCaseParameterOperationReport testCaseParametersData = new TestCaseParameterOperationReport();
        List<DataSetDto> dataSets = this.datasetDisplayDao.findAllByTestCaseId(testCaseId);
        testCaseParametersData.setDataSets(dataSets);
        List<ParameterDto> parameters = this.parameterDisplayDao.findAllByTestCaseId(testCaseId);
        testCaseParametersData.setParameters(parameters);
        testCaseParametersData.setParamValues(this.findDataSetParamValues(parameters, dataSets));
        return testCaseParametersData;
    }

    @Override
    public TestCaseParameterOperationReport findParametersDataByTestStepId(Long testStepId) {
        Long testCaseId = this.testCaseDisplayDao.getTestCaseIdByTestStepId(testStepId);
        return this.findParametersData(testCaseId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public List<AbstractTestStepDto> findTestStepsByTestCaseId(Long testCaseId) {
        return this.testStepDisplayDao.getTestStepsByTestCase(testCaseId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public TestCaseDto getDetailedTestStepView(long testCaseId) {
        TestCaseDto testCase = this.testCaseDisplayDao.getTestCaseDtoById(testCaseId);
        testCase.setMilestones(this.milestoneDisplayDao.getMilestonesByTestCaseId(testCaseId));
        testCase.setTestSteps(this.testStepDisplayDao.getTestStepsByTestCase(testCaseId));
        testCase.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(testCase.getAttachmentListId()));
        testCase.setCoverages(this.doFindCoverages(testCaseId));
        this.setParameterDatasetEntities(testCase);
        return testCase;
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion' , 'READ') or hasRole('ROLE_ADMIN')")
    public DetailedStepViewRequirementVersionDto getDetailedTestStepViewRequirement(long requirementVersionId) {
        return this.requirementVersionDisplayDao.findById(requirementVersionId);
    }

    private List<DatasetParamValueDto> findDataSetParamValues(List<ParameterDto> parameters, List<DataSetDto> dataSets) {
        List<Long> parameterIds = parameters.stream().map(ParameterDto::getId).toList();
        List<Long> datasetIds = dataSets.stream().map(DataSetDto::getId).toList();
        return this.datasetParamValueDisplayDao.findAllByParameterAndDataset(parameterIds, datasetIds);
    }
}

