/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.team;

import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.project.ProjectPermission;
import org.squashtest.tm.service.display.team.TeamDisplayService;
import org.squashtest.tm.service.internal.display.dto.ProfileDto;
import org.squashtest.tm.service.internal.display.dto.ProjectPermissionDto;
import org.squashtest.tm.service.internal.display.dto.TeamAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.testcase.TeamMemberDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.administration.TeamGrid;
import org.squashtest.tm.service.internal.repository.ProfileDao;
import org.squashtest.tm.service.internal.repository.display.ProfileDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TeamDisplayDao;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.project.ProjectsPermissionFinder;

@Service
@Transactional
public class TeamDisplayServiceImpl
implements TeamDisplayService {
    private final DSLContext dsl;
    private final TeamDisplayDao teamDisplayDao;
    private final ProjectsPermissionFinder permissionFinder;
    private final ProfileDisplayDao profileDisplayDao;
    private final UltimateLicenseAvailabilityService ultimateLicenseService;
    private final ProfileDao profileDao;

    @Inject
    public TeamDisplayServiceImpl(DSLContext dsl, TeamDisplayDao teamDisplayDao, ProjectsPermissionFinder permissionFinder, ProfileDisplayDao profileDisplayDao, UltimateLicenseAvailabilityService ultimateLicenseService, ProfileDao profileDao) {
        this.dsl = dsl;
        this.teamDisplayDao = teamDisplayDao;
        this.permissionFinder = permissionFinder;
        this.profileDisplayDao = profileDisplayDao;
        this.ultimateLicenseService = ultimateLicenseService;
        this.profileDao = profileDao;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public GridResponse findAll(GridRequest request) {
        TeamGrid teamGrid = new TeamGrid();
        GridResponse response = teamGrid.getRows(request, this.dsl);
        response.sanitizeField("description");
        return response;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public TeamAdminViewDto getTeamView(long teamId) {
        TeamAdminViewDto team = this.teamDisplayDao.getTeamById(teamId);
        team.setProjectPermissions(this.getProjectPermissions(teamId));
        team.setMembers(this.teamDisplayDao.getMembersByTeam(teamId));
        this.appendProfiles(team);
        return team;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<ProjectPermissionDto> getProjectPermissions(Long teamId) {
        List<ProjectPermission> projectPermissions = this.permissionFinder.findProjectPermissionByParty(teamId);
        return projectPermissions.stream().map(projectPermission -> {
            ProjectPermissionDto dto = new ProjectPermissionDto();
            dto.setProjectId(projectPermission.getProject().getId());
            dto.setProjectName(projectPermission.getProject().getName());
            dto.setPermissionGroup(projectPermission.getPermissionGroup());
            return dto;
        }).toList();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<TeamMemberDto> getTeamMembers(Long teamId) {
        return this.teamDisplayDao.getMembersByTeam(teamId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public boolean hasCustomProfile(long teamId) {
        Set profileNames = this.profileDao.findProfileNamesByPartyId(teamId);
        return profileNames.stream().anyMatch(profileName -> !AclGroup.isSystem((String)profileName));
    }

    private void appendProfiles(TeamAdminViewDto team) {
        boolean isUltimateAvailable = this.ultimateLicenseService.isAvailable();
        List<ProfileDto> profiles = this.profileDisplayDao.findAll().stream().filter(profile -> isUltimateAvailable || profile.isSystem()).filter(ProfileDto::isActive).toList();
        team.setProfiles(profiles);
    }
}

