/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.testcase;

import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectLimitStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.ClnRelationshipClosure;
import org.squashtest.tm.service.internal.display.execution.ExecPlanType;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.columns.LevelEnumColumn;

public class TestCaseExecutionGrid
extends AbstractGrid {
    private static final String EXEC_ID = "EXEC_ID";
    private static final String CLN_FULL_PATH = "CLN_FULL_PATH";
    private static final String CLN_PATH = "CLN_PATH";
    private static final String PATH_SEPARATOR = " > ";
    private final Long testCaseId;

    public TestCaseExecutionGrid(Long testCaseId) {
        this.testCaseId = testCaseId;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn(DSL.field((String)EXEC_ID).as("EXECUTION_ID")), new GridColumn(DSL.field((String)"DATASET_LABEL")), new GridColumn(DSL.field((String)"EXECUTION_MODE").as("INFERRED_EXECUTION_MODE")), new LevelEnumColumn(ExecutionStatus.class, (Field<String>)DSL.field((String)"EXECUTION_STATUS", String.class)), new GridColumn(DSL.field((String)"LAST_EXECUTED_BY")), new GridColumn(DSL.field((String)"LAST_EXECUTED_ON")), new GridColumn(DSL.field((String)"EXECUTION_ORDER")), new GridColumn(this.generateFieldIssues()), new GridColumn(DSL.field((String)"EXEC_PLAN_TYPE")), new GridColumn(DSL.field((String)"EXECUTION_PATH")), new GridColumn(DSL.field((String)"PROJECT_ID")));
    }

    private Field<Integer> generateFieldIssues() {
        return DSL.select((SelectField)DSL.countDistinct((Field)Tables.ISSUE.REMOTE_ISSUE_ID)).from((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).leftJoin((TableLike)Tables.ISSUE).on(Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID.eq((Field)Tables.ISSUE.ISSUE_ID)).where(DSL.field((String)EXEC_ID).eq((Object)Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID)).asField("NB_ISSUES");
    }

    @Override
    protected Table<?> getTable() {
        Table<?> clnPathTable = this.getClnPathTable();
        return DSL.select((SelectField)Tables.EXECUTION.EXECUTION_ID.as(EXEC_ID), (SelectField)Tables.EXECUTION.TCLN_ID, (SelectField)Tables.EXECUTION.DATASET_LABEL, (SelectField)Tables.EXECUTION.EXECUTION_MODE, (SelectField)Tables.EXECUTION.EXECUTION_STATUS, (SelectField)Tables.EXECUTION.LAST_EXECUTED_BY, (SelectField)Tables.EXECUTION.LAST_EXECUTED_ON, (SelectField)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER.as("EXECUTION_ORDER"), (SelectField)DSL.when((Condition)Tables.TEST_SUITE.NAME.isNotNull(), (Field)DSL.inline((String)ExecPlanType.TEST_SUITE.name())).otherwise((Field)DSL.inline((String)ExecPlanType.ITERATION.name())).as("EXEC_PLAN_TYPE"), (SelectField)DSL.concat((Field[])new Field[]{clnPathTable.field(CLN_FULL_PATH, String.class), DSL.val((String)PATH_SEPARATOR), Tables.ITERATION.NAME, DSL.coalesce((Field)DSL.concat((String)PATH_SEPARATOR, (Field)Tables.TEST_SUITE.NAME), (Object)"")}).as("EXECUTION_PATH"), (SelectField)Tables.PROJECT.PROJECT_ID.as("PROJECT_ID")).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).leftJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).leftJoin(clnPathTable).on(clnPathTable.field("CLN_ID", Long.class).eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).union((Select)DSL.select((SelectField)Tables.EXECUTION.EXECUTION_ID.as(EXEC_ID), (SelectField)Tables.EXECUTION.TCLN_ID, (SelectField)Tables.EXECUTION.DATASET_LABEL, (SelectField)Tables.EXECUTION.EXECUTION_MODE, (SelectField)Tables.EXECUTION.EXECUTION_STATUS, (SelectField)Tables.EXECUTION.LAST_EXECUTED_BY, (SelectField)Tables.EXECUTION.LAST_EXECUTED_ON, (SelectField)Tables.EXECUTION.EXECUTION_ORDER.as("EXECUTION_ORDER"), (SelectField)DSL.val((String)ExecPlanType.SPRINT.name()).as("EXEC_PLAN_TYPE"), (SelectField)clnPathTable.field(CLN_FULL_PATH, String.class).as("EXECUTION_PATH"), (SelectField)clnPathTable.field("PROJECT_ID", Long.class).as("PROJECT_ID")).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).leftJoin(clnPathTable).on(clnPathTable.field("CLN_ID", Long.class).eq((Field)Tables.SPRINT.CLN_ID))).asTable();
    }

    private Table<?> getClnPathTable() {
        short zero = 0;
        ClnRelationshipClosure descendant = Tables.CLN_RELATIONSHIP_CLOSURE.as("descendant");
        Table path = DSL.select((SelectField)Tables.PROJECT.PROJECT_ID.as("PROJECT_ID"), (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.as("CLN_ID"), (SelectField)DSL.groupConcat((Field)Tables.CAMPAIGN_LIBRARY_NODE.NAME).orderBy(new OrderField[]{Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH.desc()}).separator(PATH_SEPARATOR).as(CLN_PATH)).from((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)descendant).on(Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)descendant.ANCESTOR_ID)).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(descendant.DESCENDANT_ID.eq((Field)Tables.CAMPAIGN_FOLDER.CLN_ID).and(Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH.ne((Object)zero))).where(Tables.CAMPAIGN_FOLDER.CLN_ID.isNull()).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID, Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID}).asTable("CLN_PATH_TABLE", new String[]{"PROJECT_ID", "PROJECT_NAME", "CLN_ID", CLN_PATH});
        return DSL.select((SelectField)path.field("CLN_ID"), (SelectField)path.field("PROJECT_ID"), (SelectField)DSL.concat((Field[])new Field[]{path.field("PROJECT_NAME"), DSL.value((String)PATH_SEPARATOR), path.field(CLN_PATH), DSL.when((Condition)Tables.CAMPAIGN_FOLDER.CLN_ID.isNotNull(), (Field)DSL.value((String)PATH_SEPARATOR)).otherwise((Object)"")}).as(CLN_FULL_PATH)).from((TableLike)path).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(path.field("CLN_ID", Long.class).eq((Field)Tables.CAMPAIGN_FOLDER.CLN_ID)).where(path.field("CLN_ID", Long.class).in(this.getClnIdsContainingTestCaseExecutions())).asTable();
    }

    private SelectLimitStep<Record1<Long>> getClnIdsContainingTestCaseExecutions() {
        return DSL.selectDistinct((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.EXECUTION.TCLN_ID.eq((Object)this.testCaseId)).union((Select)DSL.selectDistinct((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.EXECUTION.TCLN_ID.eq((Object)this.testCaseId)));
    }

    @Override
    protected Field<?> getIdentifier() {
        return DSL.field((String)"EXECUTION_ID");
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return DSL.field((String)"PROJECT_ID");
    }

    @Override
    protected Condition craftInvariantFilter() {
        return DSL.field((String)"TCLN_ID").eq((Object)this.testCaseId);
    }
}

