/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Record4;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.IterationTestPlanItemRecord;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.campaign.AbstractTestPlanGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.columns.LevelEnumColumn;
import org.squashtest.tm.service.internal.repository.display.TestSuiteDisplayDao;

public class TestSuiteTestPlanGrid
extends AbstractTestPlanGrid<IterationTestPlanItemRecord> {
    private final Long testSuiteId;
    private final TestSuiteDisplayDao testSuiteDisplayDao;

    public TestSuiteTestPlanGrid(Long testSuiteId, String userLoginToRestrictTo, TestSuiteDisplayDao testSuiteDisplayDao) {
        super(userLoginToRestrictTo);
        this.testSuiteId = testSuiteId;
        this.testSuiteDisplayDao = testSuiteDisplayDao;
    }

    @Override
    protected TableField<IterationTestPlanItemRecord, Long> getItemIdColumn() {
        return Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID;
    }

    @Override
    protected TableField<IterationTestPlanItemRecord, Long> getAssigneeIdColumn() {
        return Tables.ITERATION_TEST_PLAN_ITEM.USER_ID;
    }

    @Override
    protected Table<IterationTestPlanItemRecord> getItemTable() {
        return Tables.ITERATION_TEST_PLAN_ITEM;
    }

    @Override
    protected TableField<IterationTestPlanItemRecord, Long> getTestCaseIdColumn() {
        return Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID;
    }

    @Override
    protected Long countRows(DSLContext dslContext, GridRequest request) {
        if (request.getFilterValues().isEmpty()) {
            return this.testSuiteDisplayDao.getNbTestPlanItem(this.testSuiteId, this.userLoginToRestrictTo);
        }
        return super.countRows(dslContext, request);
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn((Field<?>)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID), new GridColumn((Field<?>)Tables.ITERATION_TEST_PLAN_ITEM.LAST_EXECUTED_ON), new GridColumn(this.findItpiWithLatestExecution().field("LATEST_EXECUTION_ID")), new GridColumn(Tables.ITERATION_TEST_PLAN_ITEM.USER_ID.as("ASSIGNEE_ID")), new GridColumn((Field<?>)Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID), new GridColumn((Field<?>)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID), new GridColumn(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("TEST_CASE_ID")), new GridColumn((Field<?>)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("TEST_CASE_NAME"), (Field<?>)Tables.TEST_CASE_LIBRARY_NODE.NAME), new GridColumn(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.as("PROJECT_ID")), new GridColumn((Field<?>)Tables.PROJECT.NAME.as("PROJECT_NAME"), (Field<?>)Tables.PROJECT.NAME), new GridColumn((Field<?>)Tables.TEST_CASE.REFERENCE.as("TEST_CASE_REFERENCE"), (Field<?>)Tables.TEST_CASE.REFERENCE), new LevelEnumColumn(TestCaseImportance.class, (Field<String>)Tables.TEST_CASE.IMPORTANCE), new GridColumn(this.getUser().field("ASSIGNEE_FULL_NAME")), new GridColumn(this.getUser().field("ASSIGNEE_LOGIN")), new GridColumn((Field<?>)Tables.DATASET.NAME.as("DATASET_NAME"), (Field<?>)Tables.DATASET.NAME), new GridColumn(DSL.coalesce((Field)this.getAutomationFields().field("INFERRED_EXECUTION_MODE"), (Field[])new Field[]{Tables.EXECUTION.EXECUTION_MODE}).as("INFERRED_EXECUTION_MODE")), new GridColumn((Field<?>)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID), new GridColumn(DSL.ifnull((Object)this.computeSuccessRate().field("SUCCESS_RATE"), (Object)0).as("SUCCESS_RATE")), new LevelEnumColumn(ExecutionStatus.class, (Field<String>)Tables.ITERATION_TEST_PLAN_ITEM.EXECUTION_STATUS), new GridColumn(DSL.field((String)"MILESTONE_MIN_DATE")), new GridColumn(DSL.field((String)"MILESTONE_MAX_DATE")), new GridColumn(DSL.field((String)"MILESTONE_LABELS")), new GridColumn(DSL.field((String)"BOUND_TO_BLOCKING_MILESTONE")), new GridColumn(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.isNull().as("TEST_CASE_DELETED")));
    }

    @Override
    protected Table<?> getTable() {
        SelectHavingStep<Record2<Long, String>> getAutomationFields = this.getAutomationFields();
        SelectHavingStep<?> computeSuccessRate = this.computeSuccessRate();
        SelectHavingStep<Record> getUser = this.getUser();
        SelectOnConditionStep<Record2<Long, Long>> findItpiWithLatestExecution = this.findItpiWithLatestExecution();
        SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> milestoneDates = this.getMilestoneDates();
        SelectHavingStep<Record2<Long, Boolean>> boundToLockedMilestone = this.getBoundToBlockingMilestone();
        return this.getFilteredTableOnAssigneeIfNotExploratory((Table<Record>)Tables.ITERATION_TEST_PLAN_ITEM.innerJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).leftJoin((TableLike)Tables.ITERATION).on(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.ITERATION_TEST_PLAN_ITEM.DATASET_ID.eq((Field)Tables.DATASET.DATASET_ID)).leftJoin(getAutomationFields).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq(getAutomationFields.field("ITEM_ID", Long.class))).leftJoin(computeSuccessRate).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq(computeSuccessRate.field("ITEM_ID", Long.class))).leftJoin(getUser).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq(getUser.field("ITEM_ID", Long.class))).leftJoin(findItpiWithLatestExecution).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq(findItpiWithLatestExecution.field("ITEM_ID", Long.class))).leftJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq(findItpiWithLatestExecution.field("LATEST_EXECUTION_ID", Long.class))).leftJoin(milestoneDates).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq(milestoneDates.field("ITEM_ID", Long.class))).leftJoin(boundToLockedMilestone).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq(boundToLockedMilestone.field("ITEM_ID", Long.class))).leftJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.ITEM_TEST_PLAN_ID)));
    }

    @Override
    protected Condition craftInvariantFilter() {
        return Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Object)this.testSuiteId);
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID;
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID;
    }

    @Override
    protected SelectHavingStep<Record2<Long, Integer>> findLastExecutionByOrder() {
        return DSL.select((SelectField)Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.as("ITEM_ID"), (SelectField)DSL.max((Field)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER).as("MAX_EXECUTION_ORDER")).from((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).innerJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Object)this.testSuiteId)).groupBy(new GroupField[]{DSL.field((String)"ITEM_ID")});
    }

    private SelectHavingStep<?> computeSuccessRate() {
        SelectHavingStep<?> stepsWithStatus = this.getStepsWithStatus();
        SelectHavingStep successQuery = DSL.select((SelectField)stepsWithStatus.field("ITEM_ID").as("ITEM_ID"), (SelectField)DSL.count((Field)DSL.field((String)"STEP_ID")).as("NUM_SUCCESS")).from(stepsWithStatus).where(stepsWithStatus.field("STEP_STATUS", String.class).eq((Object)"SUCCESS")).groupBy(new GroupField[]{stepsWithStatus.field("ITEM_ID")});
        SelectHavingStep totalQuery = DSL.select((SelectField)stepsWithStatus.field("ITEM_ID").as("ITEM_ID"), (SelectField)DSL.count((Field)DSL.field((String)"STEP_ID")).as("NUM_STEPS")).from(stepsWithStatus).groupBy(new GroupField[]{stepsWithStatus.field("ITEM_ID")});
        return DSL.select((SelectField)totalQuery.field("ITEM_ID").as("ITEM_ID"), (SelectField)successQuery.field("NUM_SUCCESS").cast(Double.class).divide(totalQuery.field("NUM_STEPS").cast(Double.class)).multiply((Number)100.0).as("SUCCESS_RATE")).from((TableLike)successQuery).rightJoin((TableLike)totalQuery).on(successQuery.field("ITEM_ID", Long.class).eq(totalQuery.field("ITEM_ID", Long.class)));
    }

    private SelectHavingStep<?> getStepsWithStatus() {
        SelectOnConditionStep<Record2<Long, Long>> itpiWithLatestExecution = this.findItpiWithLatestExecution();
        return DSL.select((SelectField)itpiWithLatestExecution.field("ITEM_ID").as("ITEM_ID"), (SelectField)Tables.EXECUTION_STEP.EXECUTION_STEP_ID.as("STEP_ID"), (SelectField)Tables.EXECUTION_STEP.EXECUTION_STATUS.as("STEP_STATUS")).from((TableLike)Tables.EXECUTION_EXECUTION_STEPS).innerJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).innerJoin(itpiWithLatestExecution).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq(DSL.field((String)"LATEST_EXECUTION_ID", Long.class)));
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return Tables.TEST_SUITE_TEST_PLAN_ITEM.TEST_PLAN_ORDER.asc();
    }
}

