/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.NotImplementedException;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Record4;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectHavingStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.TestPlanGridHelpers;

public abstract class AbstractTestPlanGrid<R extends Record>
extends AbstractGrid {
    protected static final String MAX_EXECUTION_ORDER = "MAX_EXECUTION_ORDER";
    protected String userLoginToRestrictTo;

    protected AbstractTestPlanGrid(String userLoginToRestrictTo) {
        this.userLoginToRestrictTo = userLoginToRestrictTo;
    }

    protected abstract Table<R> getItemTable();

    protected abstract TableField<R, Long> getItemIdColumn();

    protected abstract TableField<R, Long> getAssigneeIdColumn();

    protected abstract TableField<R, Long> getTestCaseIdColumn();

    protected SelectOnConditionStep<Record2<Long, Long>> findItpiWithLatestExecution() {
        SelectHavingStep<Record2<Long, Integer>> findLastExecutionByOrder = this.findLastExecutionByOrder();
        return DSL.select((SelectField)Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.as("ITEM_ID"), (SelectField)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID.as("LATEST_EXECUTION_ID")).from((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).innerJoin(findLastExecutionByOrder).on(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq(findLastExecutionByOrder.field("ITEM_ID", Long.class))).and(Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER.eq(findLastExecutionByOrder.field(MAX_EXECUTION_ORDER, Integer.class)));
    }

    protected SelectHavingStep<Record2<Long, Integer>> findLastExecutionByOrder() {
        throw new NotImplementedException("This method should be implemented in subclasses");
    }

    protected SelectHavingStep<Record> getUser() {
        return DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[]{this.getItemIdColumn().as("ITEM_ID"), Tables.CORE_USER.LOGIN.as("ASSIGNEE_LOGIN"), TestPlanGridHelpers.formatAssigneeFullName()}).from(this.getItemTable()).innerJoin((TableLike)Tables.CORE_USER).on(this.getAssigneeIdColumn().eq((Field)Tables.CORE_USER.PARTY_ID));
    }

    protected SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> getMilestoneDates() {
        return DSL.select((SelectField)this.getItemIdColumn().as("ITEM_ID"), (SelectField)DSL.min((Field)Tables.MILESTONE.END_DATE).as("MILESTONE_MIN_DATE"), (SelectField)DSL.max((Field)Tables.MILESTONE.END_DATE).as("MILESTONE_MAX_DATE"), (SelectField)DSL.listAgg((Field)Tables.MILESTONE.LABEL, (String)", ").withinGroupOrderBy(new OrderField[]{Tables.MILESTONE.END_DATE.asc()}).as("MILESTONE_LABELS")).from(this.getItemTable()).innerJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(this.getTestCaseIdColumn().eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).groupBy(new GroupField[]{this.getItemIdColumn(), Tables.MILESTONE_TEST_CASE.TEST_CASE_ID});
    }

    protected SelectHavingStep<Record2<Long, String>> getAutomationFields() {
        return DSL.select((SelectField)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.as("ITEM_ID"), (SelectField)DSL.when((Condition)Tables.TEST_CASE.EXECUTION_MODE.eq((Object)TestCaseExecutionMode.EXPLORATORY.name()), (Object)TestCaseExecutionMode.EXPLORATORY.name()).otherwise(DSL.when((Condition)Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE.eq((Object)AutomationWorkflowType.NONE.name()).or(Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE.ne((Object)AutomationWorkflowType.NONE.name()).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).and(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.eq((Object)AutomationRequestStatus.AUTOMATED.name()))).and(Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.jenkins.name()).and(Tables.TEST_CASE.TA_TEST.isNotNull()).or(Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.squashOrchestrator.name()).and(Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.isNotNull()).and(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.isNotNull()).and(Tables.TEST_CASE.SCM_REPOSITORY_ID.isNotNull()))), (Object)TestCaseExecutionMode.AUTOMATED.name()).otherwise((Object)TestCaseExecutionMode.MANUAL.name())).as("INFERRED_EXECUTION_MODE")).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.TEST_CASE.AUTOMATION_REQUEST_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.TEST_AUTOMATION_SERVER).on(Tables.TEST_AUTOMATION_SERVER.SERVER_ID.eq((Field)Tables.PROJECT.TA_SERVER_ID));
    }

    protected Table<Record> getFilteredTableOnAssigneeIfNotExploratory(Table<Record> table) {
        if (this.userLoginToRestrictTo != null) {
            Field assigneeLoginField = Objects.requireNonNull(table.field("ASSIGNEE_LOGIN", String.class), "Assignee login field should not be null");
            return table.where(assigneeLoginField.eq((Object)this.userLoginToRestrictTo).or(this.isExploratoryRow())).asTable();
        }
        return table;
    }

    protected Condition isExploratoryRow() {
        return Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.isNotNull();
    }

    protected SelectHavingStep<Record2<Long, Boolean>> getBoundToBlockingMilestone() {
        return DSL.select((SelectField)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.as("ITEM_ID"), (SelectField)DSL.field((Condition)DSL.countDistinct((Field)Tables.MILESTONE.MILESTONE_ID).gt((Object)0)).as("BOUND_TO_BLOCKING_MILESTONE")).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID)).innerJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID)).where(Tables.MILESTONE.STATUS.in((Collection)MilestoneStatus.MILESTONE_BLOCKING_STATUSES)).groupBy(new GroupField[]{Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID});
    }
}

