/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.campaign;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.testautomation.AutomatedSuiteWorkflow;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Attachment;
import org.squashtest.tm.jooq.domain.tables.AttachmentList;
import org.squashtest.tm.jooq.domain.tables.AutomatedExecutionExtender;
import org.squashtest.tm.jooq.domain.tables.AutomatedSuite;
import org.squashtest.tm.service.display.campaign.AutomatedSuiteDisplayService;
import org.squashtest.tm.service.grid.GridConfigurationService;
import org.squashtest.tm.service.internal.display.dto.campaign.AutomatedSuiteExecutionReportDto;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.AutomatedSuiteExecutionGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.IterationAutomatedSuiteGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.TestSuiteAutomatedSuiteGrid;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.AutomatedSuiteDisplayDao;
import org.squashtest.tm.service.internal.repository.display.utils.RequestAliasesConstants;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional(readOnly=true)
public class AutomatedSuiteDisplayServiceImpl
implements AutomatedSuiteDisplayService {
    private static final String AUTOMATED_SUITE_ATTACHMENT = "automatedSuiteAttachment";
    private static final String AUTOMATED_SUITE_ATTACHMENT_LIST = "automatedSuiteAttachmentList";
    private static final String AUTOMATED_SUITE_HAS_ATTACHMENT = "AUTOMATED_SUITE_HAS_ATTACHMENT";
    private static final String EXECUTION_ATTACHMENT = "executionAttachment";
    private static final String EXECUTION_ATTACHMENT_LIST = "executionAttachmentList";
    private static final String EXECUTION_EXTENDER_HAS_ATTACHMENT = "EXECUTION_EXTENDER_HAS_ATTACHMENT";
    private static final String HAS_EXECUTION = "HAS_EXECUTION";
    private static final String HAS_RESULT_URL = "HAS_RESULT_URL";
    private static final List<String> specificDisplayedStatuses = Arrays.asList("SUCCESS", "FAILURE");
    private MessageSource messageSource;
    private final EntityManager entityManager;
    private final GridConfigurationService gridConfigurationService;
    private final PermissionEvaluationService permissionEvaluationService;
    private DSLContext dslContext;
    private AutomatedSuiteDisplayDao automatedSuiteDisplayDao;
    private AttachmentDisplayDao attachmentDisplayDao;

    public AutomatedSuiteDisplayServiceImpl(DSLContext dslContext, AutomatedSuiteDisplayDao automatedSuiteDisplayDao, AttachmentDisplayDao attachmentDisplayDao, EntityManager entityManager, GridConfigurationService gridConfigurationService, MessageSource messageSource, PermissionEvaluationService permissionEvaluationService) {
        this.dslContext = dslContext;
        this.automatedSuiteDisplayDao = automatedSuiteDisplayDao;
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.entityManager = entityManager;
        this.gridConfigurationService = gridConfigurationService;
        this.messageSource = messageSource;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @Override
    public GridResponse findAutomatedSuitesByIterationId(Long iterationId, GridRequest request) {
        IterationAutomatedSuiteGrid grid = new IterationAutomatedSuiteGrid(iterationId, this.messageSource, this.automatedSuiteDisplayDao, this.permissionEvaluationService);
        Iteration iteration = (Iteration)this.entityManager.find(Iteration.class, (Object)iterationId);
        Long projectId = iteration.getProject().getId();
        GridResponse response = grid.getRows(request, this.dslContext);
        this.appendsAdditionalAutomatedSuiteInformations(response.getDataRows());
        response.setActiveColumnIds(this.gridConfigurationService.findActiveColumnIdsForUserWithProjectId(request.getGridId(), projectId));
        return response;
    }

    private void appendsAdditionalAutomatedSuiteInformations(List<DataRow> dataRows) {
        this.appendReportsData(dataRows);
        this.appendsAutomatedSuitesExecutionsStatistics(dataRows);
        this.appendsAutomatedSuitesWorkflows(dataRows);
    }

    private void appendReportsData(List<DataRow> dataRows) {
        Set automatedSuiteIds = dataRows.stream().map(DataRow::getId).collect(Collectors.toSet());
        AttachmentList automatedSuiteAttachmentList = Tables.ATTACHMENT_LIST.as(AUTOMATED_SUITE_ATTACHMENT_LIST);
        AttachmentList executionAttachmentList = Tables.ATTACHMENT_LIST.as(EXECUTION_ATTACHMENT_LIST);
        Attachment automatedSuiteAttachment = Tables.ATTACHMENT.as(AUTOMATED_SUITE_ATTACHMENT);
        Attachment executionAttachment = Tables.ATTACHMENT.as(EXECUTION_ATTACHMENT);
        Map map = this.dslContext.select((SelectField)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID, (SelectField)DSL.field((Condition)DSL.count((Field)Tables.EXECUTION.EXECUTION_ID).gt((Object)0)).as(HAS_EXECUTION), (SelectField)DSL.field((Condition)DSL.count((Field)DSL.field((Condition)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.RESULT_URL.like(""))).gt((Object)0)).as(HAS_RESULT_URL), (SelectField)DSL.field((Condition)DSL.count((Field)automatedSuiteAttachment.ATTACHMENT_ID).gt((Object)0)).as(AUTOMATED_SUITE_HAS_ATTACHMENT), (SelectField)DSL.field((Condition)DSL.count((Field)executionAttachment.ATTACHMENT_ID).gt((Object)0)).as(EXECUTION_EXTENDER_HAS_ATTACHMENT)).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).leftJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).leftJoin((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)automatedSuiteAttachmentList).on(AutomatedSuite.AUTOMATED_SUITE.ATTACHMENT_LIST_ID.eq((Field)automatedSuiteAttachmentList.ATTACHMENT_LIST_ID)).leftJoin((TableLike)automatedSuiteAttachment).on(automatedSuiteAttachmentList.ATTACHMENT_LIST_ID.eq((Field)automatedSuiteAttachment.ATTACHMENT_LIST_ID)).leftJoin((TableLike)executionAttachmentList).on(Tables.EXECUTION.ATTACHMENT_LIST_ID.eq((Field)executionAttachmentList.ATTACHMENT_LIST_ID)).leftJoin((TableLike)executionAttachment).on(executionAttachmentList.ATTACHMENT_LIST_ID.eq((Field)executionAttachment.ATTACHMENT_LIST_ID)).where(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.in(automatedSuiteIds)).groupBy(new GroupField[]{AutomatedSuite.AUTOMATED_SUITE.SUITE_ID}).fetch().intoMap((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID, AutomatedSuiteReportData.class);
        Converter converter = CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);
        String hasExecution = (String)converter.convert((Object)HAS_EXECUTION);
        String hasResultUrl = (String)converter.convert((Object)HAS_RESULT_URL);
        String executionExtenderHasAttachment = (String)converter.convert((Object)AUTOMATED_SUITE_HAS_ATTACHMENT);
        String automatedSuiteHasAttachment = (String)converter.convert((Object)EXECUTION_EXTENDER_HAS_ATTACHMENT);
        dataRows.forEach(dataRow -> {
            AutomatedSuiteReportData automatedSuiteTest = map.getOrDefault(dataRow.getId(), new AutomatedSuiteReportData());
            dataRow.getData().put(hasExecution, automatedSuiteTest.isHasExecution());
            dataRow.getData().put(hasResultUrl, automatedSuiteTest.isHasResultUrl());
            dataRow.getData().put(executionExtenderHasAttachment, automatedSuiteTest.isExecutionExtenderHasAttachment());
            dataRow.getData().put(automatedSuiteHasAttachment, automatedSuiteTest.isAutomatedSuiteHasAttachment());
        });
    }

    private void appendsAutomatedSuitesExecutionsStatistics(List<DataRow> dataRows) {
        Set automatedSuiteIds = dataRows.stream().map(DataRow::getId).collect(Collectors.toSet());
        Map executionsStatuses = this.dslContext.select((SelectField)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID, (SelectField)Tables.EXECUTION.EXECUTION_STATUS).from((TableLike)AutomatedSuite.AUTOMATED_SUITE).leftJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).leftJoin((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).where(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.in(automatedSuiteIds)).and(Tables.EXECUTION.EXECUTION_STATUS.isNotNull()).fetch().intoGroups((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID, (Field)Tables.EXECUTION.EXECUTION_STATUS);
        dataRows.forEach(dataRow -> {
            if (executionsStatuses.containsKey(dataRow.getId())) {
                this.compileAutomatedSuiteStatus((DataRow)dataRow, executionsStatuses.getOrDefault(dataRow.getId(), null));
            }
        });
    }

    private void appendsAutomatedSuitesWorkflows(List<DataRow> dataRows) {
        Set automatedSuiteIds = dataRows.stream().map(DataRow::getId).collect(Collectors.toSet());
        Map workflows = this.dslContext.select((SelectField)Tables.AUTOMATED_SUITE_WORKFLOWS.SUITE_ID, (SelectField)Tables.AUTOMATED_SUITE_WORKFLOWS.WORKFLOW_ID, (SelectField)Tables.AUTOMATED_SUITE_WORKFLOWS.PROJECT_ID).from((TableLike)Tables.AUTOMATED_SUITE_WORKFLOWS).where(Tables.AUTOMATED_SUITE_WORKFLOWS.SUITE_ID.in(automatedSuiteIds)).fetchGroups(record -> (String)record.get((Field)Tables.AUTOMATED_SUITE_WORKFLOWS.SUITE_ID), record -> new AutomatedSuiteWorkflow((String)record.get((Field)Tables.AUTOMATED_SUITE_WORKFLOWS.WORKFLOW_ID), (Long)record.get((Field)Tables.AUTOMATED_SUITE_WORKFLOWS.PROJECT_ID)));
        dataRows.forEach(dataRow -> {
            Object v0 = dataRow.getData().put(RequestAliasesConstants.toCamelCase("WORKFLOWS"), workflows.getOrDefault(dataRow.getId(), null));
        });
    }

    private void compileAutomatedSuiteStatus(DataRow dataRow, List<String> statuses) {
        if (statuses == null) {
            return;
        }
        dataRow.getData().put(RequestAliasesConstants.toCamelCase("NB_STATUS_TOTAL"), statuses.size());
        Map<String, Long> occurrenceOfEachStatus = statuses.stream().collect(Collectors.groupingBy(String::toString, Collectors.counting()));
        occurrenceOfEachStatus.forEach((key, value) -> {
            if (specificDisplayedStatuses.contains(key)) {
                dataRow.getData().put(String.valueOf(RequestAliasesConstants.toCamelCase("NB_STATUS_")) + (String)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.UPPER_CAMEL).convert(key), value);
            }
        });
        long executionsStatusOtherCount = occurrenceOfEachStatus.entrySet().stream().filter(entry -> !specificDisplayedStatuses.contains(entry.getKey())).mapToLong(entry -> ((Long)entry.getValue()).intValue()).sum();
        if (executionsStatusOtherCount > 0L) {
            dataRow.getData().put(RequestAliasesConstants.toCamelCase("NB_STATUS_OTHER"), executionsStatusOtherCount);
        }
    }

    @Override
    public GridResponse findExecutionByAutomatedSuiteID(String automatedSuiteId, GridRequest request) {
        AutomatedSuiteExecutionGrid grid = new AutomatedSuiteExecutionGrid(automatedSuiteId);
        return grid.getRows(request, this.dslContext);
    }

    @Override
    public AutomatedSuiteExecutionReportDto findReportUrlsByAutomatedSuite(String automatedSuiteId) {
        AutomatedSuiteExecutionReportDto dto = new AutomatedSuiteExecutionReportDto();
        dto.setReportUrls(this.automatedSuiteDisplayDao.findReportUrlsByAutomatedSuiteId(automatedSuiteId));
        Long attachmentListId = this.automatedSuiteDisplayDao.findAttachmentListIdByAutomatedSuite(automatedSuiteId);
        dto.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(attachmentListId));
        return dto;
    }

    @Override
    public GridResponse findAutomatedSuitesByTestSuiteId(Long testSuiteId, GridRequest request) {
        TestSuiteAutomatedSuiteGrid grid = new TestSuiteAutomatedSuiteGrid(testSuiteId, this.messageSource, this.automatedSuiteDisplayDao, this.permissionEvaluationService);
        Long projectId = ((TestSuite)this.entityManager.find(TestSuite.class, (Object)testSuiteId)).getProject().getId();
        GridResponse response = grid.getRows(request, this.dslContext);
        this.appendsAdditionalAutomatedSuiteInformations(response.getDataRows());
        response.setActiveColumnIds(this.gridConfigurationService.findActiveColumnIdsForUserWithProjectId(request.getGridId(), projectId));
        return response;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    private static class AutomatedSuiteReportData {
        private boolean hasExecution;
        private boolean hasResultUrl;
        private boolean executionExtenderHasAttachment;
        private boolean automatedSuiteHasAttachment;

        private AutomatedSuiteReportData() {
        }

        public boolean isHasExecution() {
            return this.hasExecution;
        }

        public void setHasExecution(boolean hasExecution) {
            this.hasExecution = hasExecution;
        }

        public boolean isHasResultUrl() {
            return this.hasResultUrl;
        }

        public void setHasResultUrl(boolean hasResultUrl) {
            this.hasResultUrl = hasResultUrl;
        }

        public boolean isExecutionExtenderHasAttachment() {
            return this.executionExtenderHasAttachment;
        }

        public void setExecutionExtenderHasAttachment(boolean executionExtenderHasAttachment) {
            this.executionExtenderHasAttachment = executionExtenderHasAttachment;
        }

        public boolean isAutomatedSuiteHasAttachment() {
            return this.automatedSuiteHasAttachment;
        }

        public void setAutomatedSuiteHasAttachment(boolean automatedSuiteHasAttachment) {
            this.automatedSuiteHasAttachment = automatedSuiteHasAttachment;
        }
    }
}

